/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByGroupData;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class HeelByGroupScreen
extends StringEntrySelectScreen {
    private final List<DogGroupsManager.DogGroup> dogGroupList = new ArrayList<DogGroupsManager.DogGroup>();
    private boolean heelAndSit = false;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;

    public HeelByGroupScreen() {
        super((Component)Component.translatable((String)"doggytalents.screen.heel_by_group"));
    }

    public static void open() {
        Minecraft mc = Minecraft.getInstance();
        HeelByGroupScreen screen = new HeelByGroupScreen();
        mc.setScreen((Screen)screen);
        screen.requestGroups();
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.width / 2;
        int mY = this.height / 2;
        FlatButton help = new FlatButton(mX - 100 - 20 - 2, mY - 100, 20, 20, (Component)Component.literal((String)"?"), b -> {}){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                ArrayList<Component> list = new ArrayList<Component>();
                list.add((Component)Component.translatable((String)"doggytalents.screen.heel_by_group.help_title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                String str = I18n.get((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByGroupScreen.this.font));
                ScreenUtil.renderComponentTooltip_21_5(graphics, HeelByGroupScreen.this.font, list, mouseX, mouseY);
            }
        };
        this.addRenderableWidget((GuiEventListener)help);
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.drawString(this.font, I18n.get((String)"doggytalents.screen.heel_by_group.no_group_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    protected Component modifyEntryText(Component entryText, int entryId, boolean is_selected) {
        if (this.heelAndSit && is_selected) {
            entryText = entryText.copy().withStyle(Style.EMPTY.withColor(0xFF6F00));
        }
        return entryText;
    }

    @Override
    protected void drawEntry(GuiGraphics graphics, int entry_x, int entry_y, int entry_id, boolean is_selected) {
        super.drawEntry(graphics, entry_x + 12, entry_y, entry_id, is_selected);
        DogGroupsManager.DogGroup group = this.dogGroupList.get(entry_id);
        graphics.fill(entry_x, entry_y - 1, entry_x + 9, entry_y - 1 + 9, group.color);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestHeelByGroup(this.dogGroupList.get(id), this.heelAndSit);
        Minecraft.getInstance().setScreen(null);
    }

    private void requestGroups() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByGroupData.REQUEST_GROUP_LIST());
    }

    public void assignResponse(List<DogGroupsManager.DogGroup> groups) {
        this.dogGroupList.clear();
        for (DogGroupsManager.DogGroup group : groups) {
            this.dogGroupList.add(group);
        }
        this.updateEntries(this.dogGroupList.stream().map(x -> x.name).collect(Collectors.toList()));
    }

    private void requestHeelByGroup(DogGroupsManager.DogGroup group, boolean heelAndSit) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByGroupData.REQUEST_HEEL(group, heelAndSit));
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }
}

