/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.block;

import com.mojang.serialization.MapCodec;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyTileEntityTypes;
import doggytalents.common.backward_imitate.ResourceKeyHelper_21_3;
import doggytalents.common.block.tileentity.RiceMillBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RiceMillBlock
extends BaseEntityBlock
implements WorldlyContainerHolder {
    private static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final MapCodec<RiceMillBlock> CODEC = RiceMillBlock.simpleCodec(RiceMillBlock::new);

    public RiceMillBlock() {
        super(BlockBehaviour.Properties.of().setId(ResourceKeyHelper_21_3.blockKey("rice_mill")).mapColor(MapColor.WOOD).strength(1.0f, 5.0f).sound(SoundType.WOOD));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH));
    }

    public RiceMillBlock(BlockBehaviour.Properties props) {
        this();
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        return SHAPE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)player;
            RiceMillBlockEntity.openContainer(sP, level, pos);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RiceMillBlockEntity(pos, state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return RiceMillBlock.createTickerHelper(blockEntityType, DoggyTileEntityTypes.RICE_MILL.get(), RiceMillBlockEntity::tick);
    }

    public WorldlyContainer getContainer(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof RiceMillBlockEntity)) {
            return null;
        }
        RiceMillBlockEntity mill = (RiceMillBlockEntity)blockEntity;
        return mill.getWorldlyContainer();
    }

    public static Direction getFacing(BlockState state) {
        if (state.getBlock() != DoggyBlocks.RICE_MILL.get()) {
            return Direction.NORTH;
        }
        Direction facing = (Direction)state.getValue(FACING);
        if (facing.getAxis() == Direction.Axis.Y) {
            return Direction.NORTH;
        }
        return facing;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

