/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.DogSounds;
import doggytalents.DogVariants;
import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogWantsAttentionGoal
extends Goal {
    private final Dog dog;
    private LivingEntity owner;
    private int lastStopTick;
    private int cooldownTime = 200;
    private Phase phase = Phase.GO_TO_OWNER;
    private int goToOwnerTimeout;
    private int tickTillPathRecalc;
    private boolean whinedToAttention;
    private int tickAnim;
    private int stopTick;

    public DogWantsAttentionGoal(Dog dog) {
        this.dog = dog;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.isOnFire()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.onGround()) {
            return false;
        }
        if (this.dog.tickCount - this.lastStopTick < this.cooldownTime) {
            return false;
        }
        if (this.dog.dogVariant() != DogVariants.CHESTNUT.get()) {
            return false;
        }
        if (this.dog.getRandom().nextFloat() >= 0.01f) {
            return false;
        }
        LivingEntity owner = this.dog.getOwner();
        if (owner == null) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (this.phase == Phase.GO_TO_OWNER) {
            return this.goToOwnerTimeout > 0;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.PLAY_WITH_MEH) {
            return false;
        }
        if (this.dog.distanceToSqr((Entity)this.owner) > 16.0) {
            return false;
        }
        return this.dog.tickCount < this.stopTick;
    }

    public void start() {
        this.phase = Phase.GO_TO_OWNER;
        this.goToOwnerTimeout = 200;
        this.whinedToAttention = false;
    }

    public void tick() {
        if (this.phase == Phase.GO_TO_OWNER) {
            this.tickGoToOwner();
        } else {
            this.tickBegForAttention();
        }
    }

    private void tickGoToOwner() {
        boolean closeEnough;
        this.dog.getLookControl().setLookAt((Entity)this.owner);
        if (--this.goToOwnerTimeout <= 0) {
            this.goToOwnerTimeout = 0;
            return;
        }
        double d0 = this.dog.distanceToSqr((Entity)this.owner);
        boolean bl = closeEnough = d0 < 6.0;
        if (--this.tickTillPathRecalc <= 0) {
            if (!closeEnough) {
                this.dog.getNavigation().moveTo((Entity)this.owner, 1.0);
            }
            this.tickTillPathRecalc = 20;
        }
        if (closeEnough) {
            if (!this.dog.getNavigation().isDone()) {
                this.dog.getNavigation().stop();
            }
            if (!this.whinedToAttention) {
                this.whinedToAttention = true;
                this.dog.playSound(DogSounds.CLASSIC_WHINE.get(), this.dog.getSoundVolume(), this.dog.getVoicePitch());
            }
            this.checkAndSwitchToAttention();
        }
    }

    private void checkAndSwitchToAttention() {
        if (!DogUtil.checkIfOwnerIsLooking(this.dog, this.owner)) {
            return;
        }
        this.phase = Phase.BEG_FOR_ATTENTION;
        this.tickAnim = 0;
        this.stopTick = this.dog.tickCount + DogAnimation.PLAY_WITH_MEH.getLengthTicks();
        this.dog.setAnim(DogAnimation.PLAY_WITH_MEH);
    }

    private void tickBegForAttention() {
        this.dog.getLookControl().setLookAt((Entity)this.owner);
    }

    public void stop() {
        this.owner = null;
        this.lastStopTick = this.dog.tickCount;
        this.cooldownTime = 20 * (1 + this.dog.getRandom().nextInt(3));
        if (this.dog.getAnim() == DogAnimation.PLAY_WITH_MEH) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    private static enum Phase {
        GO_TO_OWNER,
        BEG_FOR_ATTENTION;

    }
}

