/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.common.Screens;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.OpenDogScreenData;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.EntityUtil;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class OpenDogScreenPacket
implements IPacket<OpenDogScreenData> {
    @Override
    public OpenDogScreenData decode(FriendlyByteBuf buf) {
        OpenDogScreenData.ScreenType type = OpenDogScreenData.ScreenType.byId(buf.readInt());
        int dogId = buf.readInt();
        return new OpenDogScreenData(type, dogId);
    }

    @Override
    public void encode(OpenDogScreenData data, FriendlyByteBuf buf) {
        buf.writeInt(data.type.getId());
        buf.writeInt(data.dogId);
    }

    @Override
    public void handle(OpenDogScreenData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                ServerPlayer player = ((DTNNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                this.selectAndOpenDogScreen(data, player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public void selectAndOpenDogScreen(OpenDogScreenData data, ServerPlayer player) {
        switch (data.type) {
            case TOOL: {
                Entity e = player.level().getEntity(data.dogId);
                if (!(e instanceof Dog)) break;
                Dog dog2 = (Dog)e;
                Screens.openDoggyToolsScreen(player, dog2);
                break;
            }
            case ARMOR: {
                Entity e = player.level().getEntity(data.dogId);
                if (!(e instanceof Dog)) break;
                Dog dog3 = (Dog)e;
                Screens.openArmorScreen(player, dog3);
                break;
            }
            case INVENTORY_SINGLE: {
                Entity e = player.level().getEntity(data.dogId);
                if (!(e instanceof Dog)) break;
                Dog dog4 = (Dog)e;
                Screens.openPackPuppyScreen(player, dog4);
                break;
            }
            default: {
                List<Dog> dogs = player.level().getEntitiesOfClass(Dog.class, player.getBoundingBox().inflate(12.0, 12.0, 12.0), dog -> dog.canInteract((LivingEntity)player) && PackPuppyTalent.hasInventory(dog));
                Collections.sort(dogs, new EntityUtil.Sorter(player.position()));
                if (dogs.size() > 8) {
                    dogs = dogs.subList(0, 8);
                }
                if (dogs.isEmpty()) break;
                Screens.openDogInventoriesScreen(player, dogs);
                break;
            }
        }
    }
}

