/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTags;
import doggytalents.TalentsOptions;
import doggytalents.api.backward_imitate.CompoundTag_1_21_5;
import doggytalents.api.backward_imitate.DogInteractionResult;
import doggytalents.api.backward_imitate.ItemUtil_1_21_5;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.Screens;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.DoggyToolsRangedAttack;
import doggytalents.common.talent.doggy_tools.ShootHandler;
import doggytalents.common.talent.doggy_tools.ToolActionEntries;
import doggytalents.common.talent.doggy_tools.tool_actions.ToolAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class DoggyToolsTalent
extends TalentInstance {
    private DoggyToolsItemHandler tools = new DoggyToolsItemHandler();
    private Map<Item, ToolAction> TOOL_ACTION_MAP;
    private boolean alwaysPickSlot0;

    public DoggyToolsTalent(Talent talentIn, int level) {
        super(talentIn, level);
    }

    public static int getSize(int level) {
        return Mth.clamp((int)level, (int)0, (int)5);
    }

    @Override
    public void init(AbstractDog dog) {
        this.TOOL_ACTION_MAP = ToolActionEntries.getToolActionMapFor((Dog)dog, this);
    }

    @Override
    public boolean hasRenderer() {
        return true;
    }

    @Override
    public void remove(AbstractDog dog) {
        if (dog.level().isClientSide) {
            return;
        }
        dog.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
    }

    @Override
    public void set(AbstractDog dog, int levelBefore) {
        if (dog.level().isClientSide) {
            return;
        }
        if (levelBefore > 0 && this.level() <= 0) {
            this.dropAllToolbar(dog);
        }
    }

    private void dropAllToolbar(AbstractDog dog) {
        for (int i = 0; i < this.tools.getSlots(); ++i) {
            Containers.dropItemStack((Level)dog.level(), (double)dog.getX(), (double)dog.getY(), (double)dog.getZ(), (ItemStack)this.tools.getStackInSlot(i));
            this.tools.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    @Override
    public void tick(AbstractDog d) {
        if (d.level().isClientSide) {
            return;
        }
        this.validateAndSync(d);
        if (!(d instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)d;
        this.updateMainHandItem(dog);
    }

    private void updateMainHandItem(Dog dog) {
        LivingEntity owner;
        ItemStack mainHandItem;
        ItemStack firstTool;
        if (this.alwaysPickSlot0 && !(firstTool = this.tools.getStackInSlot(0)).isEmpty()) {
            if (dog.getMainHandItem() != firstTool && !this.isItemBlacklisted(firstTool)) {
                dog.setItemInHand(InteractionHand.MAIN_HAND, firstTool);
            }
            return;
        }
        if (dog.isOrderedToSit() || !dog.isDoingFine()) {
            mainHandItem = dog.getMainHandItem();
            if (mainHandItem != null && !mainHandItem.isEmpty()) {
                dog.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
            return;
        }
        mainHandItem = dog.getMainHandItem();
        if (dog.isBusy() || dog.getTarget() != null) {
            return;
        }
        if (mainHandItem != null && !mainHandItem.isEmpty()) {
            dog.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        if ((owner = dog.getOwner()) == null || dog.distanceToSqr((Entity)owner) > (double)this.getMaxOwnerDistSqr()) {
            return;
        }
        this.pickActionTool(dog);
    }

    private void validateAndSync(AbstractDog d) {
        ItemStack stack = d.getMainHandItem();
        if (!this.tools.hasStackRef(stack)) {
            d.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    private void pickTargetTool(Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(this.level()); ++i) {
            boolean creeper_avoid;
            ItemStack stack = this.tools.getStackInSlot(i);
            if (stack.isEmpty() || this.isItemBlacklisted(stack)) continue;
            Item item = stack.getItem();
            if (ItemUtil_1_21_5.isMeleeWeapon(stack)) {
                dog.setItemSlot(EquipmentSlot.MAINHAND, stack);
                break;
            }
            if (item instanceof AxeItem) {
                dog.setItemSlot(EquipmentSlot.MAINHAND, stack);
                break;
            }
            if (stack.is(Items.TRIDENT)) {
                dog.setItemSlot(EquipmentSlot.MAINHAND, stack);
                break;
            }
            ShootHandler shoot_handler = DoggyToolsRangedAttack.getShootHandler(stack, dog);
            boolean bl = creeper_avoid = dog.getTarget() instanceof Creeper && shoot_handler != ShootHandler.TRIDENT && (shoot_handler != ShootHandler.BOW || (Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_BOW_VANILLA_PROJ.get() != false);
            if (creeper_avoid) {
                shoot_handler = ShootHandler.NONE;
            }
            if (shoot_handler == ShootHandler.NONE) continue;
            dog.setItemSlot(EquipmentSlot.MAINHAND, stack);
            break;
        }
    }

    private void pickActionTool(Dog dog) {
        for (int i = 0; i < DoggyToolsTalent.getSize(this.level()); ++i) {
            ItemStack stack = this.tools.getStackInSlot(i);
            if (stack.isEmpty() || this.isItemBlacklisted(stack)) continue;
            TriggerableAction found_action = null;
            for (Map.Entry<Item, ToolAction> entry : this.TOOL_ACTION_MAP.entrySet()) {
                if (!entry.getValue().shouldUse(stack)) continue;
                found_action = entry.getValue();
                break;
            }
            if (found_action == null) continue;
            dog.setItemSlot(EquipmentSlot.MAINHAND, stack);
            dog.triggerAction(found_action);
            break;
        }
    }

    public DoggyToolsItemHandler getTools() {
        return this.tools;
    }

    @Override
    public DogInteractionResult processInteract(AbstractDog d, Level levek, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!ItemUtil_1_21_5.isPickaxeExact(stack)) {
            return DogInteractionResult.PASS;
        }
        if (!(d instanceof Dog)) {
            return DogInteractionResult.PASS;
        }
        Dog dog = (Dog)d;
        if (!dog.level().isClientSide && player instanceof ServerPlayer) {
            ServerPlayer sP = (ServerPlayer)player;
            Screens.openDoggyToolsScreen(sP, dog);
        }
        return DogInteractionResult.SUCCESS;
    }

    @Override
    public void onDogSetTarget(AbstractDog dogIn, @Nullable LivingEntity newTarget, @Nullable LivingEntity oldTarget) {
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (dog.level().isClientSide) {
            return;
        }
        if (this.alwaysPickSlot0) {
            return;
        }
        if (newTarget == null) {
            ItemStack mainHandItem = dog.getMainHandItem();
            if (mainHandItem != null && !mainHandItem.isEmpty()) {
                dog.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
            }
        } else {
            this.pickTargetTool(dog);
        }
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanUseTools();
    }

    @Override
    public Optional<IDogRangedAttackManager> getRangedAttack() {
        return Optional.of(new DoggyToolsRangedAttack());
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        CompoundTag tag = new CompoundTag();
        tag.put("tool_inv", (Tag)this.tools.serializeNBT((HolderLookup.Provider)dogIn.registryAccess()));
        tag.putBoolean("pickFirstTool", this.alwaysPickSlot0);
        compound.put("doggy_tools", (Tag)tag);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag_1_21_5 compound) {
        super.readFromNBT(dogIn, compound);
        CompoundTag_1_21_5 tag = compound.getCompound("doggy_tools");
        if (tag == null) {
            return;
        }
        this.alwaysPickSlot0 = tag.getBoolean("pickFirstTool");
        CompoundTag_1_21_5 inv_tag = tag.getCompound("tool_inv");
        if (inv_tag != null) {
            this.tools.deserializeNBT((HolderLookup.Provider)dogIn.registryAccess(), inv_tag.wrapped());
        }
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, Entity target) {
        ItemStack stack = dogIn.getMainHandItem();
        Item item = stack.getItem();
        if (!(target instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)target;
        if (this.isItemBlacklisted(stack)) {
            return;
        }
        stack.hurtEnemy(living, (LivingEntity)dogIn);
        stack.postHurtEnemy(living, (LivingEntity)dogIn);
    }

    public int getMaxOwnerDistSqr() {
        return 256;
    }

    private boolean isItemBlacklisted(ItemStack stack) {
        return stack.is(DoggyTags.DOGGY_TOOLS_BLACKLIST);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.DOGGY_TOOLS_EXC.get()) {
            return this.alwaysPickSlot0;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.DOGGY_TOOLS_EXC.get()) {
            this.alwaysPickSlot0 = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.DOGGY_TOOLS_EXC.get());
    }

    public boolean pickFirstTool() {
        return this.alwaysPickSlot0;
    }

    public void setPickFirstTool(boolean val) {
        this.alwaysPickSlot0 = val;
    }
}

