/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Math;

public class InventoryUtil {
    public static Pair<ItemStack, Integer> findStack(IItemHandler source, Predicate<ItemStack> searchCriteria) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.getStackInSlot(i);
            if (!searchCriteria.test(stack)) continue;
            return Pair.of((Object)stack.copy(), (Object)i);
        }
        return null;
    }

    public static void transferStacks(IItemHandlerModifiable source, IItemHandler target) {
        for (int i = 0; i < source.getSlots(); ++i) {
            ItemStack stack = source.getStackInSlot(i);
            source.setStackInSlot(i, InventoryUtil.addItem(target, stack));
        }
    }

    public static ItemStack addItem(IItemHandler target, ItemStack remaining) {
        int i;
        if (remaining.isEmpty()) {
            return remaining;
        }
        for (i = 0; i < target.getSlots(); ++i) {
            ItemStack stack = target.getStackInSlot(i);
            if (!stack.is(remaining.getItem())) continue;
            if (target.isItemValid(i, remaining)) {
                remaining = target.insertItem(i, remaining, false);
            }
            if (remaining.isEmpty()) break;
        }
        if (remaining.isEmpty()) {
            return remaining;
        }
        for (i = 0; i < target.getSlots(); ++i) {
            if (target.isItemValid(i, remaining)) {
                remaining = target.insertItem(i, remaining, false);
            }
            if (remaining.isEmpty()) break;
        }
        return remaining;
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        for (int j = 0; j < inv.getSlots(); ++j) {
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.isEmpty()) continue;
            f += (float)itemstack.getCount() / (float)Math.min((int)inv.getSlotLimit(j), (int)itemstack.getMaxStackSize());
            ++i;
        }
        return Mth.floor((float)((f /= (float)inv.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    @Nullable
    public static ItemStack findStackWithItemFromHands(Player player, Item item) {
        if (item == null) {
            return null;
        }
        if (player == null) {
            return null;
        }
        ItemStack stack0 = player.getMainHandItem();
        ItemStack stack1 = player.getOffhandItem();
        if (stack0 != null && stack0.getItem() == item) {
            return stack0;
        }
        if (stack1 != null && stack1.getItem() == item) {
            return stack1;
        }
        return null;
    }

    public static int maxStackSizeWithContainer(Container container, int slot, ItemStack stack) {
        int stack_maxSize = stack.getMaxStackSize();
        int container_maxSize = container.getMaxStackSize();
        return Math.min((int)stack_maxSize, (int)container_maxSize);
    }

    public static int maxStackSizeWithContainer(ItemStackHandler container, int slot, ItemStack stack) {
        int stack_maxSize = stack.getMaxStackSize();
        int container_maxSize = container.getSlotLimit(slot);
        return Math.min((int)stack_maxSize, (int)container_maxSize);
    }
}

