/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.PlayerUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class DogDistantTeleportToOwnerPromise
extends AbstractPromise {
    private static final int TIMEOUT = 200;
    private static final int SEARCH_INTERVAL = 10;
    private final BlockPos targetPos;
    private final BlockPos dogPos;
    private final UUID dogUUID;
    private final ServerLevel level;
    private int timeOutTick;
    private int tickTillSearch;
    private Dog teleportedDog;
    private final LivingEntity owner;

    public DogDistantTeleportToOwnerPromise(@Nonnull UUID dogUUID, @Nonnull LivingEntity owner, @Nonnull BlockPos dogPos) {
        ServerLevel sL;
        this.dogUUID = dogUUID;
        Level level = owner.level();
        this.level = level instanceof ServerLevel ? (sL = (ServerLevel)level) : null;
        this.targetPos = owner.blockPosition();
        this.dogPos = dogPos;
        this.owner = owner;
    }

    @Override
    public void tick() {
        Entity dog = null;
        if (--this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            dog = this.level.getEntity(this.dogUUID);
        }
        if (dog != null) {
            if (!(dog instanceof Dog)) {
                this.rejectedMsg = "WHAT?";
                this.setState(AbstractPromise.State.REJECTED);
                return;
            }
            boolean flag = DogUtil.dynamicSearchAndTeleportToBlockPos((Dog)dog, this.targetPos, 4);
            if (!flag) {
                this.rejectedMsg = "NOSAFEPOS";
                this.setState(AbstractPromise.State.REJECTED);
                return;
            }
            this.teleportedDog = (Dog)dog;
            this.setState(AbstractPromise.State.FULFILLED);
        } else if (--this.timeOutTick <= 0) {
            this.rejectedMsg = "TIMEOUT";
            this.setState(AbstractPromise.State.REJECTED);
        }
    }

    @Override
    public void onFulfilled() {
        if (this.teleportedDog == null || !this.teleportedDog.isAlive()) {
            return;
        }
        if (this.owner != null) {
            PlayerUtil.sendSystemMessage(this.owner, (Component)Component.translatable((String)"item.doggytalents.conducting_bone.fulfilled.tp_self", (Object[])new Object[]{this.teleportedDog.getName().getString()}));
        }
        this.level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.teleportedDog.getX(), this.teleportedDog.getY(), this.teleportedDog.getZ(), 30, (double)this.teleportedDog.getBbWidth(), (double)0.8f, (double)this.teleportedDog.getBbWidth(), 0.1);
    }

    @Override
    public void onRejected() {
        if (this.owner != null) {
            PlayerUtil.sendSystemMessage(this.owner, (Component)Component.translatable((String)"item.doggytalents.conducting_bone.rejected", (Object[])new Object[]{Component.literal((String)this.rejectedMsg).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED))}));
        }
    }

    @Override
    public void start() {
        if (this.level == null) {
            this.rejectedMsg = "CLIENTLEVEL";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        DogLocationStorage storage = DogLocationStorage.get((Level)this.level);
        DogLocationData data = storage.getData(this.dogUUID);
        if (data == null) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        ResourceKey<Level> dogDimKey = data.getDimension();
        ResourceKey ownerDimKey = this.owner.level().dimension();
        if (ownerDimKey == null || dogDimKey == null) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (!dogDimKey.equals((Object)ownerDimKey)) {
            this.rejectedMsg = "DIFFERENTDIM";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.timeOutTick = 200;
        ChunkPos chunkpos = new ChunkPos(this.dogPos);
        if (this.level.hasChunk(chunkpos.x, chunkpos.z)) {
            this.rejectedMsg = "ALREADYREQUESTORLOADED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.accquireChunk(this.level, chunkpos);
    }
}

