/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.mojang.blaze3d.systems.RenderSystem;
import doggytalents.DoggyEntityTypes;
import doggytalents.client.entity.render.DogScreenOverlays;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class DTNWolfMountCustomGuiOverlay {
    public static boolean onRenderVehicleHealth(GuiGraphics graphics, Gui gui) {
        if (!DTNWolfMountCustomGuiOverlay.isApplicable()) {
            return false;
        }
        Optional<Entity> vehicle_optional = DTNWolfMountCustomGuiOverlay.getPlayerVehicle();
        if (!vehicle_optional.isPresent()) {
            return false;
        }
        Entity vehicle = vehicle_optional.get();
        if (!DTNWolfMountCustomGuiOverlay.isTargetVehicle(vehicle)) {
            return false;
        }
        if (!(vehicle instanceof Dog)) {
            return false;
        }
        Dog dog = (Dog)vehicle;
        int draw_x = graphics.guiWidth() / 2 + 91 - 80;
        int draw_y = graphics.guiHeight() - gui.rightHeight;
        RenderSystem.enableBlend();
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        MutableComponent health_level_str = DTNWolfMountCustomGuiOverlay.getNumberComponent(dog.getHealth(), dog.getMaxHealth());
        MutableComponent food_level_str = DTNWolfMountCustomGuiOverlay.getNumberComponent(dog.getDogHunger(), dog.getMaxHunger());
        Optional<Object> air_level_str = Optional.empty();
        boolean render_air = !dog.canBreatheUnderwater() && (dog.isEyeInFluid(FluidTags.WATER) || dog.getAirSupply() < dog.getMaxAirSupply());
        boolean is_low_air = false;
        if (render_air) {
            float dog_air = dog.getAirSupply();
            int dog_air_percent = Mth.ceil((float)(dog_air / (float)dog.getMaxAirSupply() * 100.0f));
            dog_air_percent = Mth.clamp((int)dog_air_percent, (int)0, (int)100);
            air_level_str = Optional.of(Component.literal((String)(Integer.toString(dog_air_percent) + "%")));
            boolean bl = is_low_air = dog_air_percent <= 30;
        }
        if (dog.getHealth() <= 10.0f) {
            health_level_str = health_level_str.withStyle(ChatFormatting.RED);
        }
        if (dog.getDogHunger() <= 20.0f) {
            food_level_str = food_level_str.withStyle(ChatFormatting.RED);
        }
        if (render_air && is_low_air) {
            air_level_str.map(x -> x.withStyle(ChatFormatting.RED));
        }
        int unit_str_offset = 24;
        int unit_str_yoffset = 1;
        int pX = draw_x;
        int pY = draw_y;
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 16, 0, 9, 9);
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 52, 0, 9, 9);
        graphics.drawString(font, (Component)health_level_str, (pX += 11) + unit_str_offset - font.width((FormattedText)health_level_str), pY + unit_str_yoffset, -1);
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, pX += 32, pY, 16, 27, 9, 9);
        graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 52, 27, 9, 9);
        graphics.drawString(font, (Component)food_level_str, (pX += 11) + unit_str_offset - font.width((FormattedText)food_level_str), pY + unit_str_yoffset, -1);
        String dog_name_str_0 = dog.getName().getString();
        String dog_name_str = font.width(dog_name_str_0) > (render_air ? 40 : 67) ? font.plainSubstrByWidth(dog_name_str_0, render_air ? 36 : 63) + ".." : dog_name_str_0 + ":";
        pX = draw_x;
        graphics.drawString(font, dog_name_str, pX, (pY -= 10) + unit_str_yoffset, -1);
        if (air_level_str.isPresent()) {
            pX = draw_x + 43;
            graphics.blit(DogScreenOverlays.GUI_ICONS_LOCATION, pX, pY, 16, 18, 9, 9);
            graphics.drawString(font, (Component)air_level_str.get(), (pX += 11) + unit_str_offset - font.width((FormattedText)air_level_str.get()), pY + unit_str_yoffset, -1);
        }
        gui.rightHeight += 20;
        RenderSystem.disableBlend();
        return true;
    }

    private static MutableComponent getNumberComponent(float val, float max_val) {
        MutableComponent val_str;
        int val_i = Mth.ceil((float)val);
        if (val_i > 999 || ((Boolean)ConfigHandler.CLIENT.DTN_WOLF_MOUNT_OVERLAY_PERCENT.get()).booleanValue()) {
            int percent = Mth.ceil((float)(val / max_val * 100.0f));
            percent = Mth.clamp((int)percent, (int)0, (int)100);
            val_str = Component.literal((String)(Integer.toString(percent) + "%"));
        } else {
            val_str = Component.literal((String)Integer.toString(val_i));
        }
        return val_str;
    }

    public static Optional<Integer> onGetVehicleMaxHearts(LivingEntity vehicle) {
        if (!DTNWolfMountCustomGuiOverlay.isApplicable()) {
            return Optional.empty();
        }
        if (!DTNWolfMountCustomGuiOverlay.isTargetVehicle((Entity)vehicle)) {
            return Optional.empty();
        }
        return Optional.of(20);
    }

    private static Optional<Entity> getPlayerVehicle() {
        Minecraft mc = Minecraft.getInstance();
        Entity camera_entity = mc.getCameraEntity();
        if (camera_entity == null) {
            return Optional.empty();
        }
        if (camera_entity.getType() != EntityType.PLAYER) {
            return Optional.empty();
        }
        Entity vehicle = camera_entity.getVehicle();
        if (vehicle == null) {
            return Optional.empty();
        }
        return Optional.of(vehicle);
    }

    private static boolean isTargetVehicle(Entity vehicle) {
        if (vehicle == null) {
            return false;
        }
        if (vehicle.getType() != DoggyEntityTypes.DOG.get()) {
            return false;
        }
        return vehicle.showVehicleHealth();
    }

    public static boolean isApplicable() {
        return (Boolean)ConfigHandler.CLIENT.DTN_WOLF_MOUNT_OVERLAY.get();
    }
}

