/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import doggytalents.client.entity.model.SyncedAccessoryModel;
import doggytalents.client.entity.model.dog.DogModel;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import org.joml.Vector3f;

public class SyncedRenderFunctionWithHeadModel
extends SyncedAccessoryModel {
    private Vector3f pivot = DogModel.DEFAULT_ROOT_PIVOT;

    public SyncedRenderFunctionWithHeadModel(ModelPart root) {
        super(root);
    }

    @Override
    public void sync(DogModel dogModel) {
        this.root.copyFrom(dogModel.root);
        this.syncPart(this.head, dogModel.head);
        this.syncPart(this.realHead, dogModel.realHead);
        this.pivot = DogModel.DEFAULT_ROOT_PIVOT;
        Vector3f custom_pivot = dogModel.getCustomRootPivotPoint();
        if (custom_pivot != null) {
            this.pivot = custom_pivot;
        }
    }

    private void syncPart(Optional<ModelPart> part, ModelPart dogPart) {
        part.ifPresent(p -> p.copyFrom(dogPart));
    }

    @Override
    protected void populatePart(ModelPart box) {
        this.head = Optional.of(box.getChild("head"));
        this.realHead = Optional.of(((ModelPart)this.head.get()).getChild("real_head"));
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)13.5f, (float)-7.0f));
        PartDefinition real_head = head.addOrReplaceChild("real_head", CubeListBuilder.create(), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    @Override
    public void renderToBuffer(PoseStack stack, VertexConsumer p_103014_, int p_103015_, int p_103016_, int unused) {
    }

    public void startRenderFromRoot(PoseStack stack, Renderer actualRendering) {
        DogModel.renderDogModelFromRootWithPivot(stack, this.createDogRenderContext(actualRendering));
    }

    public DogModel.DogModelRenderContext createDogRenderContext(Renderer actualRendering) {
        DogModel.AddtionalHeadRenderer additional_head_renderer = (stack, part_ctx) -> this.startRenderItemFromHead(stack, actualRendering);
        return new DogModel.DogModelRenderContext(this.root, this.pivot, SyncedAccessoryModel.getDogModelBabyHead(this.head, this.young), Optional.empty(), Optional.of(additional_head_renderer));
    }

    public void startRenderItemFromHead(PoseStack matrixStack, Renderer renderer) {
        matrixStack.pushPose();
        ((ModelPart)this.head.get()).translateAndRotate(matrixStack);
        matrixStack.pushPose();
        ((ModelPart)this.realHead.get()).translateAndRotate(matrixStack);
        renderer.doRender(matrixStack);
        matrixStack.popPose();
        matrixStack.popPose();
    }

    public static interface Renderer {
        public void doRender(PoseStack var1);
    }
}

