/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.SyncedRenderFunctionWithHeadModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Optional;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;

public class DogMouthItemRenderer
extends RenderLayer<Dog, DogModel> {
    private ItemInHandRenderer itemInHandRenderer;
    private SyncedRenderFunctionWithHeadModel itemSyncer;

    public DogMouthItemRenderer(RenderLayerParent dogRendererIn, EntityRendererProvider.Context ctx) {
        super(dogRendererIn);
        this.itemInHandRenderer = ctx.getItemInHandRenderer();
        this.itemSyncer = new SyncedRenderFunctionWithHeadModel(ctx.bakeLayer(ClientSetup.DOG_SYNCED_FUNCTION_WITH_HEAD));
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferSource, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        DogSkin skin;
        if (!((Boolean)ConfigHandler.CLIENT.MOUTH_ITEM_FORCE_RENDER.get()).booleanValue() && (skin = dog.getClientSkin()).useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        Optional<ItemStack> stackOptional = dog.getMouthItemForRender();
        if (!stackOptional.isPresent()) {
            return;
        }
        ItemStack stack = stackOptional.get();
        DogModel model2 = (DogModel)this.getParentModel();
        model2.copyPropertiesTo(this.itemSyncer);
        this.itemSyncer.sync(model2);
        this.itemSyncer.startRenderFromRoot(matrixStack, matrixStack1 -> this.renderItem(matrixStack1, bufferSource, packedLight, dog, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, stack));
    }

    public void renderItem(PoseStack stack, MultiBufferSource bufferSource, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, ItemStack itemStack) {
        stack.pushPose();
        stack.translate(-0.025f, 0.125f, -0.32f);
        Item item = itemStack.getItem();
        if (item instanceof SwordItem || item instanceof DiggerItem || itemStack.is(Items.TRIDENT)) {
            stack.translate(0.25, 0.0, 0.0);
        }
        if (item instanceof BowItem || item instanceof CrossbowItem) {
            stack.scale(1.0f, -1.0f, -1.0f);
            stack.translate(0.0, 0.0, -0.1);
        }
        if (item instanceof BlockItem) {
            stack.scale(0.5f, -0.5f, -0.5f);
            stack.translate(0.2f, -0.31f, 0.07f);
            stack.mulPose(Axis.YP.rotationDegrees(60.0f));
        } else {
            stack.mulPose(Axis.YP.rotationDegrees(45.0f));
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        this.itemInHandRenderer.renderItem((LivingEntity)dog, itemStack, ItemDisplayContext.GROUND, false, stack, bufferSource, packedLight);
        stack.popPose();
    }
}

