/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.AmnesiaBoneScreen.element.view.GeneralView;

import doggytalents.DoggyItems;
import doggytalents.client.screen.AmnesiaBoneScreen.element.view.GeneralView.DogStatusViewBoxElement;
import doggytalents.client.screen.AmnesiaBoneScreen.screen.DogMigrateOwnerScreen;
import doggytalents.client.screen.AmnesiaBoneScreen.screen.DogUntameConfirmScreen;
import doggytalents.client.screen.AmnesiaBoneScreen.screen.KillStatsClearConfirmScreen;
import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.element.ElementPosition;
import doggytalents.client.screen.framework.types.TextType;
import doggytalents.client.screen.framework.widget.MultiLineFlatButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.ItemUtil;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class GeneralView
extends AbstractElement {
    Dog dog;
    Font font;

    public GeneralView(AbstractElement parent, Screen screen, Dog dog) {
        super(parent, screen);
        this.dog = dog;
        this.font = Minecraft.getInstance().font;
    }

    @Override
    public AbstractElement init() {
        this.setupMainView();
        return this;
    }

    private void setupMainView() {
        int mX = this.getScreen().width / 2;
        int mY = this.getScreen().height / 2;
        this.addChildren((GuiEventListener)new DogStatusViewBoxElement(this, this.getScreen(), this.dog).setPosition(ElementPosition.PosType.FIXED, mX - 105 - 10, mY - 52).setSize(105));
        this.addChildren((GuiEventListener)new MultiLineFlatButton(mX + 20, mY - 40, 80, 30, 28, (Component)Component.translatable((String)"amnesia_bone_gui.general.owner_change"), b -> this.openChangeOwnerScreen()){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.renderWidget(graphics, mouseX, mouseY, partialTicks);
                int tX = this.getX() + this.width - 10;
                int n = this.getY() + this.height / 2;
                Objects.requireNonNull(GeneralView.this.font);
                int tY = n - 9 / 2;
                graphics.drawString(GeneralView.this.font, ">", tX, tY, -1);
            }
        }.setTextAlign(TextType.Align.LEFT));
        this.addChildren((GuiEventListener)new MultiLineFlatButton(mX + 20, mY + 10, 80, 20, 28, (Component)Component.translatable((String)"amnesia_bone_gui.general.untame"), b -> DogUntameConfirmScreen.open(this.dog)){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.renderWidget(graphics, mouseX, mouseY, partialTicks);
                int tX = this.getX() + this.width - 10;
                int n = this.getY() + this.height / 2;
                Objects.requireNonNull(GeneralView.this.font);
                int tY = n - 9 / 2;
                graphics.drawString(GeneralView.this.font, ">", tX, tY, -1);
            }
        }.setTextAlign(TextType.Align.LEFT));
        KillStatsClearConfirmScreen.addClearKillStatsButton(this.dog, this.font, mX, mY + 60, b -> this.addChildren((GuiEventListener)b));
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    private void openChangeOwnerScreen() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack.getItem() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        UUID migrate_uuid = null;
        String migrate_str = "";
        if (tag != null && tag.hasUUID("request_uuid")) {
            migrate_uuid = tag.getUUID("request_uuid");
        }
        if (tag != null) {
            migrate_str = tag.getString("request_str");
        }
        DogMigrateOwnerScreen.open(this.dog, migrate_uuid, migrate_str);
    }
}

