/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.ConductingBoneData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.apache.commons.lang3.tuple.Pair;

public class ConductingBoneScreen
extends StringEntrySelectScreen {
    private Font font;
    private final ArrayList<String> dogNameList = new ArrayList();
    private final ArrayList<UUID> dogIdList = new ArrayList();
    private boolean showUuid = false;
    private boolean toBed = false;

    public ConductingBoneScreen() {
        super((Component)Component.translatable((String)"doggytalents.screen.conducting_bone"));
        this.font = Minecraft.getInstance().font;
    }

    public static void open() {
        Minecraft mc = Minecraft.getInstance();
        ConductingBoneScreen screen = new ConductingBoneScreen();
        if (mc.player != null && mc.player.isShiftKeyDown()) {
            screen.toBed = true;
        }
        mc.setScreen((Screen)screen);
        screen.requestDogs();
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(0, pY, 60, 20, (Component)Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.setMessage((Component)Component.translatable((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        showUuid.setX(mX - 100 - showUuid.getWidth() - 2);
        FlatButton toBedButton = new FlatButton(0, pY += showUuid.getHeight() + 2, 60, 20, (Component)Component.literal((String)(this.toBed ? "To Bed" : "To Self")), b -> {
            if (this.toBed) {
                this.toBed = false;
                b.setMessage((Component)Component.literal((String)"To Self"));
            } else {
                this.toBed = true;
                b.setMessage((Component)Component.literal((String)"To Bed"));
            }
        });
        toBedButton.setX(mX - 100 - toBedButton.getWidth() - 2);
        FlatButton help = new FlatButton(0, pY += toBedButton.getHeight() + 2, 20, 20, (Component)Component.literal((String)"?"), b -> {}){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.translatable((String)"doggytalents.screen.conducting_bone.help_title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                String str = I18n.get((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, ConductingBoneScreen.this.font));
                graphics.renderComponentTooltip(ConductingBoneScreen.this.font, list, mouseX, mouseY);
            }
        };
        help.setX(mX - 100 - help.getWidth() - 2);
        pY += help.getHeight() + 2;
        this.addRenderableWidget((GuiEventListener)showUuid);
        this.addRenderableWidget((GuiEventListener)help);
        this.addRenderableWidget((GuiEventListener)toBedButton);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        UUID uuid = this.dogIdList.get(entry_id);
        MutableComponent uuid_c1 = Component.literal((String)uuid.toString()).withStyle(ChatFormatting.GRAY);
        if (this.height >= 273) {
            int mX = this.width / 2;
            int mY = this.height / 2;
            int uuid_width = this.font.width((FormattedText)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.drawString(this.font, (Component)uuid_c1, tX, tY, -1);
        } else {
            graphics.renderComponentTooltip(this.font, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.drawString(this.font, I18n.get((String)"doggytalents.screen.conducting_bone.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestDistantTeleport(this.dogIdList.get(id));
        Minecraft.getInstance().setScreen(null);
    }

    private void requestDogs() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ConductingBoneData.RequestDogsData());
    }

    public void assignResponse(List<Pair<UUID, String>> dogLs) {
        this.dogNameList.clear();
        this.dogIdList.clear();
        for (Pair<UUID, String> entry : dogLs) {
            this.dogNameList.add((String)entry.getRight());
            this.dogIdList.add((UUID)entry.getLeft());
        }
        this.updateEntries(this.dogNameList);
    }

    private void requestDistantTeleport(UUID dogUuid) {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new ConductingBoneData.RequestDistantTeleportDogData(dogUuid, this.toBed));
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }
}

