/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.DoggyItems;
import doggytalents.api.anim.DogAnimation;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.item.DogAnimDebugItem;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.DogAnimDebugData;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class DogAnimDebugScreen
extends StringEntrySelectScreen {
    private Font font;
    private List<DogAnimation> animList;
    private DogAnimDebugItem.ItemMode selectMode = DogAnimDebugItem.ItemMode.ANIM;
    private DogAnimation selectAnim = DogAnimation.NONE;

    public DogAnimDebugScreen(Player player) {
        super((Component)Component.empty());
        this.font = Minecraft.getInstance().font;
        this.animList = Arrays.stream(DogAnimation.values()).collect(Collectors.toList());
        this.getSelectModeFromPlayer(player);
        this.getSelectAnimFromPlayer(player);
    }

    private void getSelectModeFromPlayer(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        this.selectMode = DogAnimDebugItem.getItemMode(stack);
    }

    private void getSelectAnimFromPlayer(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() != DoggyItems.DOG_ANIM_DEBUG.get()) {
            return;
        }
        this.selectAnim = DogAnimDebugItem.getSelectedAnimation(stack);
    }

    public static void open(Player player) {
        Minecraft mc = Minecraft.getInstance();
        mc.setScreen((Screen)new DogAnimDebugScreen(player));
    }

    @Override
    public void init() {
        super.init();
        this.initEntries();
        this.addModeButton();
    }

    @Override
    protected void onEntrySelected(int id) {
        DogAnimation anim_selected = this.animList.get(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogAnimDebugData.UpdateItemSettingsData(anim_selected, this.selectMode));
        this.minecraft.setScreen(null);
    }

    private void addModeButton() {
        int mx = this.width / 2;
        int my = this.height / 2;
        int modeButton_width = 70;
        int modeButton_height = 20;
        boolean help_render_below_view = this.shouldRenderHelpBelow();
        FlatButton modeButton = new FlatButton(mx - this.getSelectAreaSize() / 2 - 70 - 2, my - this.getSelectAreaSize() / 2, 70, 20, this.getModeTitle(this.selectMode), b -> {
            DogAnimDebugItem.ItemMode new_mode;
            this.selectMode = new_mode = this.selectMode.cycleMode();
            b.setMessage(this.getModeTitle(this.selectMode));
            this.sendItemChangeRequest();
            if (!help_render_below_view) {
                b.setTooltip(Tooltip.create((Component)this.getModeHelp(this.selectMode)));
            }
        });
        if (!help_render_below_view) {
            modeButton.setTooltip(Tooltip.create((Component)this.getModeHelp(this.selectMode)));
        }
        this.addRenderableWidget((GuiEventListener)modeButton);
    }

    private void sendItemChangeRequest() {
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new DogAnimDebugData.UpdateItemSettingsData(this.selectAnim, this.selectMode));
    }

    private Component getModeTitle(DogAnimDebugItem.ItemMode mode) {
        return Component.translatable((String)("item.doggytalents.dog_anim_debug_stick.mode." + mode.getId()));
    }

    private Component getModeHelp(DogAnimDebugItem.ItemMode mode) {
        return Component.translatable((String)("item.doggytalents.dog_anim_debug_stick.mode." + mode.getId() + ".help"));
    }

    private void initEntries() {
        this.updateEntries(this.getAnimNameList());
    }

    private List<String> getAnimNameList() {
        return this.animList.stream().map(x -> x.toString()).collect(Collectors.toList());
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderHelp(graphics, this.selectMode);
    }

    private boolean shouldRenderHelpBelow() {
        return this.height > 353;
    }

    private void renderHelp(GuiGraphics graphics, DogAnimDebugItem.ItemMode mode) {
        if (!this.shouldRenderHelpBelow()) {
            return;
        }
        int mX = this.width / 2;
        Component desc = this.getModeHelp(mode);
        int max_width = Math.min(360, this.width - 10);
        List desc_lines = this.font.split((FormattedText)desc, max_width);
        int tX = mX - this.font.width((FormattedText)this.title) / 2;
        int tY = this.height / 2 + this.getSelectAreaSize() / 2 + 20;
        for (FormattedCharSequence line : desc_lines) {
            tX = mX - this.font.width(line) / 2;
            graphics.drawString(this.font, line, tX, tY, -1);
            Objects.requireNonNull(this.font);
            tY += 9 + 2;
        }
    }

    @Override
    protected boolean matchIgnoreCaseSearch() {
        return true;
    }
}

