/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen.DogNewInfoScreen.element.view.StatsView.view;

import doggytalents.client.screen.framework.element.AbstractElement;
import doggytalents.client.screen.framework.widget.TextOnlyButton;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.stats.StatsTracker;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;

public class MobKillsView
extends AbstractElement {
    static final int PADDING_LEFT = 5;
    static final int PADDING_RIGHT = 30;
    static final int PADDING_TOP = 5;
    static final int LINE_SPACING = 3;
    private StatsTracker stats;
    private Font font;
    private Dog dog;
    private int maxEntryFit;
    private int maxPageNum;
    private int startIndex = 0;
    private int pageIndex = 0;
    private TextOnlyButton lastPage;
    private TextOnlyButton nextPage;
    private boolean disabledKillStat = false;

    public MobKillsView(AbstractElement parent, Screen screen, Dog dog, StatsTracker stats, Font font) {
        super(parent, screen);
        this.stats = stats;
        this.font = font;
        this.dog = dog;
    }

    @Override
    public AbstractElement init() {
        this.maxEntryFit = this.getNumOfFitEntries(this.getSizeY());
        this.maxPageNum = this.calculatePagesNum(this.getSizeY(), this.stats.getAllKillCount().size());
        int mX = this.getSizeX() / 2;
        this.lastPage = new TextOnlyButton(this.getRealX() + mX - 30 - 20, this.getRealY() + this.getSizeY() - 20 - 5, 20, 20, (Component)Component.literal((String)"<"), b -> {
            this.startIndex -= this.maxEntryFit;
            --this.pageIndex;
            if (this.pageIndex < 0) {
                this.pageIndex = 0;
            }
        }, this.font);
        this.addChildren((GuiEventListener)this.lastPage);
        this.nextPage = new TextOnlyButton(this.getRealX() + mX + 30, this.getRealY() + this.getSizeY() - 20 - 5, 20, 20, (Component)Component.literal((String)">"), b -> {
            this.startIndex += this.maxEntryFit;
            ++this.pageIndex;
            if (this.pageIndex > this.maxPageNum) {
                this.pageIndex = this.maxPageNum;
            }
        }, this.font);
        this.addChildren((GuiEventListener)this.nextPage);
        this.disabledKillStat = (Boolean)ConfigHandler.SERVER.DISABLE_KILL_STATS.get();
        return this;
    }

    @Override
    public void renderElement(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Map<EntityType<?>, Integer> mobKillMap = this.stats.getAllKillCount();
        int startX = this.getRealX() + 5;
        int pY = this.getRealY() + 5;
        if (this.disabledKillStat) {
            String str = I18n.get((String)"doggui.stats.mob_kills.disabled", (Object[])new Object[]{this.dog.getName().getString()});
            graphics.drawString(this.font, str, startX, pY, -1);
            this.lastPage.active = false;
            this.nextPage.active = false;
            return;
        }
        if (mobKillMap.isEmpty()) {
            String str = I18n.get((String)"doggui.stats.mob_kills.no_kills", (Object[])new Object[]{this.dog.getName().getString()});
            graphics.drawString(this.font, str, startX, pY, -1);
            this.lastPage.active = false;
            this.nextPage.active = false;
            return;
        }
        this.lastPage.active = this.startIndex > 0;
        this.nextPage.active = false;
        int tillStart = this.startIndex = Math.max(0, this.startIndex);
        int entryDrawm = 0;
        for (Map.Entry<EntityType<?>, Integer> entry : mobKillMap.entrySet()) {
            if (--tillStart >= 0) continue;
            if (entryDrawm >= this.maxEntryFit) {
                this.nextPage.active = true;
                break;
            }
            MutableComponent mobName = entry.getKey().getDescription().copy();
            mobName.withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)));
            Integer kills = entry.getValue();
            graphics.drawString(this.font, (Component)mobName, startX, pY, -1);
            Objects.requireNonNull(this.font);
            String killSentence = this.dog.getName().getString() + " has killed " + kills + " " + mobName.getString();
            graphics.drawString(this.font, killSentence, startX, pY += 9 + 3, -1);
            Objects.requireNonNull(this.font);
            pY += 9 + 3;
            ++entryDrawm;
        }
        if (entryDrawm <= 0 && this.startIndex > 0) {
            this.startIndex = 0;
        }
        int mX = this.getSizeX() / 2;
        String txt = this.pageIndex + 1 + "/" + this.maxPageNum;
        int tX = this.getRealX() + mX - this.font.width(txt) / 2;
        int tY = this.getRealY() + this.getSizeY() - 19;
        graphics.drawString(this.font, txt, tX, tY, -1);
    }

    private int getOneEntrySize() {
        Objects.requireNonNull(this.font);
        return 9 * 2 + 6;
    }

    private int getNumOfFitEntries(int sizeY) {
        return sizeY / this.getOneEntrySize() - 1;
    }

    private int calculatePagesNum(int sizeY, int entriesNum) {
        return Mth.ceil((float)((float)entriesNum / (float)this.getNumOfFitEntries(sizeY)));
    }
}

