/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.screen;

import doggytalents.client.screen.ScreenUtil;
import doggytalents.client.screen.StringEntrySelectScreen;
import doggytalents.client.screen.framework.widget.FlatButton;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.WhistleItem;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByNameData;
import doggytalents.common.util.ItemUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class HeelByNameScreen
extends StringEntrySelectScreen {
    private final Player player;
    private final List<String> dogNameList = new ArrayList<String>();
    private final List<Integer> dogIdList = new ArrayList<Integer>();
    private boolean showUuid = false;
    private boolean heelAndSit = false;
    private boolean softHeel = false;
    private final int HLC_HEEL_AND_SIT = 0xFF6F00;

    public HeelByNameScreen(Player player, boolean softHeel) {
        super((Component)Component.translatable((String)"doggytalents.screen.whistler.heel_by_name"));
        this.player = player;
        this.softHeel = softHeel;
        List<Dog> dogsList = Minecraft.getInstance().level.getEntitiesOfClass(Dog.class, this.player.getBoundingBox().inflate(100.0, 50.0, 100.0), d -> d.isOwnedBy((LivingEntity)player));
        dogsList = FrequentHeelStore.get(this).sortDogList(dogsList);
        for (Dog d2 : dogsList) {
            this.dogNameList.add(d2.getName().getString());
            this.dogIdList.add(d2.getId());
        }
        this.updateEntries(this.dogNameList);
    }

    public static void open() {
        HeelByNameScreen.open(0);
    }

    public static void open(int blockCharInputMillis) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack stack = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (stack == null) {
            return;
        }
        if (!(stack.getItem() instanceof WhistleItem)) {
            return;
        }
        boolean softHeel = false;
        if (ItemUtil.hasTag(stack)) {
            softHeel = ItemUtil.getTag(stack).getBoolean("soft_heel");
        }
        HeelByNameScreen screen = new HeelByNameScreen((Player)mc.player, softHeel);
        screen.setBlockCharInputTime(blockCharInputMillis);
        mc.setScreen((Screen)screen);
    }

    @Override
    protected void addUtilitiesButton() {
        int mX = this.width / 2;
        int mY = this.height / 2;
        int pY = mY - 100;
        FlatButton showUuid = new FlatButton(0, pY, 60, 20, (Component)Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.show_uuid"), btn -> {
            btn.setMessage((Component)Component.translatable((String)("doggytalents.screen.whistler.heel_by_name." + (this.showUuid ? "show" : "hide") + "_uuid")));
            this.showUuid = !this.showUuid;
        });
        showUuid.setX(mX - 100 - showUuid.getWidth() - 2);
        String soft_heel_title_id = "doggytalents.screen.whistler.heel_by_name.soft_heel";
        MutableComponent inital_softHeel_c1 = this.softHeel ? Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").withStyle(Style.EMPTY.withColor(this.getHightlightSelectedColor())) : Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.soft_heel");
        FlatButton softHeel = new FlatButton(0, pY += showUuid.getHeight() + 2, 60, 20, (Component)inital_softHeel_c1, b -> {
            boolean bl = this.softHeel = !this.softHeel;
            if (this.softHeel) {
                b.setMessage((Component)Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").withStyle(Style.EMPTY.withColor(this.getHightlightSelectedColor())));
            } else {
                b.setMessage((Component)Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.soft_heel"));
            }
        }){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.soft_heel").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                String str = I18n.get((String)"doggytalents.screen.whistler.heel_by_name.soft_heel.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(str, 150, HeelByNameScreen.this.font));
                graphics.renderComponentTooltip(HeelByNameScreen.this.font, list, mouseX, mouseY);
            }
        };
        softHeel.setX(mX - 100 - softHeel.getWidth() - 2);
        FlatButton help = new FlatButton(0, pY += softHeel.getHeight() + 2, 20, 20, (Component)Component.literal((String)"?"), b -> {}){

            @Override
            public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pTicks) {
                super.renderWidget(graphics, mouseX, mouseY, pTicks);
                if (!this.isHovered) {
                    return;
                }
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(Component.translatable((String)"doggytalents.screen.whistler.heel_by_name.help_title").withStyle(Style.EMPTY.withBold(Boolean.valueOf(true))));
                String base_help = I18n.get((String)"doggytalents.screen.general.entry_select.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(base_help, 150, HeelByNameScreen.this.font));
                String additional_help = I18n.get((String)"doggytalents.screen.whistler.heel_by_name.help", (Object[])new Object[0]);
                list.addAll(ScreenUtil.splitInto(additional_help, 150, HeelByNameScreen.this.font));
                graphics.renderComponentTooltip(HeelByNameScreen.this.font, list, mouseX, mouseY);
            }
        };
        help.setX(mX - 100 - help.getWidth() - 2);
        this.addRenderableWidget((GuiEventListener)showUuid);
        this.addRenderableWidget((GuiEventListener)help);
        this.addRenderableWidget((GuiEventListener)softHeel);
    }

    @Override
    protected void drawNoEntryMsg(GuiGraphics graphics, int x, int y) {
        graphics.drawString(this.font, I18n.get((String)"doggytalents.screen.whistler.heel_by_name.no_dog_found", (Object[])new Object[0]), x, y, 16058890);
    }

    @Override
    protected Component modifyEntryText(Component entryText, int entryId, boolean is_selected) {
        if (this.heelAndSit && is_selected) {
            entryText = entryText.copy().withStyle(Style.EMPTY.withColor(0xFF6F00));
        }
        return entryText;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.mayRenderShowUUID(graphics, mouseX, mouseY, partialTicks);
    }

    private void mayRenderShowUUID(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.showUuid) {
            return;
        }
        Optional<Integer> hover_entry_optional = this.getHoveredEntry(mouseX, mouseY);
        if (!hover_entry_optional.isPresent()) {
            return;
        }
        int entry_id = hover_entry_optional.get();
        Integer dog_id = this.dogIdList.get(entry_id);
        Entity dog = this.minecraft.level.getEntity(dog_id.intValue());
        if (dog == null) {
            return;
        }
        String uuid = dog.getStringUUID();
        if (uuid == null) {
            return;
        }
        MutableComponent uuid_c1 = Component.literal((String)uuid.toString()).withStyle(ChatFormatting.GRAY);
        if (this.height >= 273) {
            int mX = this.width / 2;
            int mY = this.height / 2;
            int uuid_width = this.font.width((FormattedText)uuid_c1);
            int tX = mX - uuid_width / 2;
            int tY = mY + this.getSelectAreaSize() / 2 + 23;
            graphics.drawString(this.font, (Component)uuid_c1, tX, tY, -1);
        } else {
            graphics.renderComponentTooltip(this.font, List.of(uuid_c1), mouseX, mouseY);
        }
    }

    @Override
    protected void onEntrySelected(int id) {
        this.requestHeel(this.dogIdList.get(id));
        Minecraft.getInstance().setScreen(null);
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.heelAndSit = false;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    private void requestHeel(int id) {
        FrequentHeelStore.get(this).pushDogToFrequentStack(id);
        PacketHandler.send(PacketDistributor.SERVER.noArg(), new HeelByNameData(id, this.heelAndSit, this.softHeel));
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    private static class FrequentHeelStore {
        private static FrequentHeelStore INSTANCE;
        private ArrayList<UUID> dogFrequentStack = new ArrayList();
        private Screen screen;
        private ToIntFunction<Dog> GET_FREQ_COUNT = d -> this.getFrequentWeightFor((Dog)d);
        private static final int STORE_CAP = 32;

        private FrequentHeelStore(Screen screen) {
            this.screen = screen;
        }

        public void pushDogToFrequentStack(int id) {
            Entity dog = this.screen.getMinecraft().level.getEntity(id);
            if (dog == null) {
                return;
            }
            String uuid_str = dog.getStringUUID();
            if (uuid_str == null) {
                return;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            if (indx > 0) {
                if (indx >= this.dogFrequentStack.size() - 1) {
                    return;
                }
                this.dogFrequentStack.remove(uuid);
            }
            this.dogFrequentStack.add(uuid);
            if (this.dogFrequentStack.size() > 32) {
                this.dogFrequentStack.remove(0);
            }
        }

        public int getFrequentWeightFor(Dog dog) {
            String uuid_str = dog.getStringUUID();
            if (uuid_str == null) {
                return 0;
            }
            UUID uuid = null;
            try {
                uuid = UUID.fromString(uuid_str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uuid == null) {
                return 0;
            }
            int indx = this.dogFrequentStack.indexOf(uuid);
            return Math.max(0, indx + 1);
        }

        public List<Dog> sortDogList(List<Dog> dogList) {
            return dogList.stream().sorted(Comparator.comparingInt(this.GET_FREQ_COUNT).reversed()).collect(Collectors.toList());
        }

        public static FrequentHeelStore get(Screen screen) {
            if (INSTANCE == null) {
                INSTANCE = new FrequentHeelStore(screen);
            }
            if (FrequentHeelStore.INSTANCE.screen != screen) {
                FrequentHeelStore.INSTANCE.screen = screen;
            }
            return INSTANCE;
        }
    }
}

