/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyAttributes;
import doggytalents.DoggyBlocks;
import doggytalents.DoggyEffects;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.DoggySerializers;
import doggytalents.DoggyTags;
import doggytalents.DoggyTalentsNext;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.enu.WetSource;
import doggytalents.api.feature.DogGender;
import doggytalents.api.feature.DogLevel;
import doggytalents.api.feature.DogMode;
import doggytalents.api.feature.DogSize;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogAlteration;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.api.inferface.InferTypeContext;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.AccessoryType;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.DTNClientPettingManager;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.entity.skin.DogSkinHolder;
import doggytalents.client.entity.versionfix.FixClientTeleportDesync_1_21;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.client.screen.DogNewInfoScreen.DogNewInfoScreen;
import doggytalents.client.screen.DogNewInfoScreen.screen.DogCannotInteractWithScreen;
import doggytalents.common.artifacts.DoggyArtifact;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.effects.NattoBiteEffect;
import doggytalents.common.entity.DogAllyCheck;
import doggytalents.common.entity.DogAttackManager;
import doggytalents.common.entity.DogAvoidGoingInFrontOfOwnerManager;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.entity.DogHungerManager;
import doggytalents.common.entity.DogIncapacitatedMananger;
import doggytalents.common.entity.DogMoodManager;
import doggytalents.common.entity.DogOwnerDistanceManager;
import doggytalents.common.entity.DogPettingManager;
import doggytalents.common.entity.DogPushAvoidManager;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.entity.DogSoundManager;
import doggytalents.common.entity.DogSwimmingManager;
import doggytalents.common.entity.DogTrackingTracker;
import doggytalents.common.entity.ai.DogAiManager;
import doggytalents.common.entity.ai.nav.DogBodyRotationControl;
import doggytalents.common.entity.ai.nav.DogJumpControl;
import doggytalents.common.entity.ai.nav.DogMoveControl;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import doggytalents.common.entity.ai.nav.IDogNavLock;
import doggytalents.common.entity.ai.triggerable.AnimationAction;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.entity.ai.triggerable.DogDrownAction;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.entity.anim.DogAnimationManager;
import doggytalents.common.entity.anim.DogPose;
import doggytalents.common.entity.datasync.DogDataSyncManager;
import doggytalents.common.entity.serializers.Dimension2BlockPosMap;
import doggytalents.common.entity.stats.StatsTracker;
import doggytalents.common.entity.texture.DogSkinData;
import doggytalents.common.event.EventHandler;
import doggytalents.common.inventory.DogArmorItemHandlerImpl;
import doggytalents.common.item.DoggyArtifactItem;
import doggytalents.common.network.PacketDistributor;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.ParticlePackets;
import doggytalents.common.network.packet.data.DogMountData;
import doggytalents.common.network.packet.data.DogShakingData;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.storage.OnlineDogLocationManager;
import doggytalents.common.util.Cache;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.NBTUtil;
import doggytalents.common.util.WorldUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.commons.lang3.ObjectUtils;

public class Dog
extends AbstractDog {
    private static final EntityDataAccessor<Optional<Component>> LAST_KNOWN_NAME = SynchedEntityData.defineId(Dog.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_COMPONENT);
    private static final EntityDataAccessor<Integer> DOG_FLAGS = SynchedEntityData.defineId(Dog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> HUNGER_INT = SynchedEntityData.defineId(Dog.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<ItemStack> BONE_VARIANT = SynchedEntityData.defineId(Dog.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> INCAP_VAL = SynchedEntityData.defineId(Dog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANIMATION = SynchedEntityData.defineId(Dog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ANIM_SYNC_TIME = SynchedEntityData.defineId(Dog.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<DogVariant> DOG_VARIANT = SynchedEntityData.defineId(Dog.class, DoggySerializers.DOG_VARIANT_SERIALIZER);
    private static final EntityDataAccessor<DogLevel> DOG_LEVEL = SynchedEntityData.defineId(Dog.class, DoggySerializers.DOG_LEVEL_SERIALIZER);
    private static final EntityDataAccessor<DogGender> GENDER = SynchedEntityData.defineId(Dog.class, DoggySerializers.GENDER_SERIALIZER);
    private static final EntityDataAccessor<DogMode> MODE = SynchedEntityData.defineId(Dog.class, DoggySerializers.MODE_SERIALIZER);
    private static final EntityDataAccessor<Dimension2BlockPosMap> DOG_BED_LOCATION = SynchedEntityData.defineId(Dog.class, DoggySerializers.DIM2BLOCKPOS_SERIALIZER);
    private static final EntityDataAccessor<Dimension2BlockPosMap> DOG_BOWL_LOCATION = SynchedEntityData.defineId(Dog.class, DoggySerializers.DIM2BLOCKPOS_SERIALIZER);
    private static final EntityDataAccessor<DogIncapacitatedMananger.IncapacitatedSyncState> DOG_INCAP_SYNC_STATE = SynchedEntityData.defineId(Dog.class, DoggySerializers.INCAP_SYNC_SERIALIZER);
    private static final EntityDataAccessor<List<DoggyArtifactItem>> ARTIFACTS = SynchedEntityData.defineId(Dog.class, DoggySerializers.ARTIFACTS_SERIALIZER);
    private static final EntityDataAccessor<DogSize> DOG_SIZE = SynchedEntityData.defineId(Dog.class, DoggySerializers.DOG_SIZE_SERIALIZER);
    private static final EntityDataAccessor<DogSkinData> CUSTOM_SKIN = SynchedEntityData.defineId(Dog.class, DoggySerializers.DOG_SKIN_DATA_SERIALIZER);
    private static final EntityDataAccessor<DogPettingManager.DogPettingState> DOG_PETTING_STATE = SynchedEntityData.defineId(Dog.class, DoggySerializers.DOG_PETTING_STATE);
    private static final EntityDataAccessor<DogAnimationManager.DogAnimDebugState> DOG_ANIM_DEBUG_STATE = SynchedEntityData.defineId(Dog.class, DoggySerializers.DOG_ANIM_DEBUG_STATE);
    private static final EntityDataAccessor<DogSleepOnManager.DogSleepOnState> DOG_SLEEP_ON_STATE = SynchedEntityData.defineId(Dog.class, DoggySerializers.DOG_SLEEP_ON_STATE);
    private final Cache<Integer> spendablePoints = Cache.make(this::getSpendablePointsInternal);
    private final List<IDogAlteration> alterations = new ArrayList<IDogAlteration>(4);
    private final List<IDogFoodHandler> foodHandlers = new ArrayList<IDogFoodHandler>(4);
    public final DogAnimationManager animationManager = new DogAnimationManager(this);
    private DogSkinHolder clientSkin = DogSkinHolder.getNone();
    private ArrayList<AccessoryInstance> clientAccessories = new ArrayList();
    private ResourceLocation missingDogVariant = null;
    public final StatsTracker statsTracker = new StatsTracker();
    public final DogDataSyncManager dogSyncedDataManager = new DogDataSyncManager(this);
    public final DogTrackingTracker dogTrackingTracker = new DogTrackingTracker();
    public final DogOwnerDistanceManager dogOwnerDistanceManager = new DogOwnerDistanceManager(this);
    public final DogAvoidGoingInFrontOfOwnerManager avoidGoInFrontOfOwnerManager = new DogAvoidGoingInFrontOfOwnerManager(this);
    public final DogGroupsManager dogGroupsManager = new DogGroupsManager();
    public final DogIncapacitatedMananger incapacitatedMananger = new DogIncapacitatedMananger(this);
    private final DogHungerManager hungerManager = new DogHungerManager(this);
    public final DogPettingManager pettingManager = new DogPettingManager(this);
    public final DogSleepOnManager.PerDog sleepOnManager = new DogSleepOnManager.PerDog(this);
    public final DogSwimmingManager dogSwimmingManager = new DogSwimmingManager(this);
    public final DogPushAvoidManager dogPushAvoidManager = new DogPushAvoidManager(this);
    public final DogAttackManager dogAttackManager = new DogAttackManager(this);
    public final DogAiManager dogAi;
    public final DogMoodManager dogMood = new DogMoodManager(this);
    public final DogSoundManager dogSoundManager = new DogSoundManager(this);
    private DogAlterationProps alterationProps = new DogAlterationProps();
    private IDogRangedAttackManager dogRangedAttackManager = IDogRangedAttackManager.NONE;
    private final DogArmorItemHandlerImpl dogArmors = new DogArmorItemHandlerImpl(this);
    private ItemStack mouthStack = ItemStack.EMPTY;
    private ItemStack wolfArmorStack = ItemStack.EMPTY;
    protected final DogPathNavigation defaultNavigation;
    protected final DogMoveControl defaultMoveControl;
    @Nullable
    protected IDogNavLock navigationLock;
    protected PathNavigation currentNavigation;
    protected int switchNavCooldown = 0;
    private Optional<BlockPos> lastSitPos = Optional.empty();
    private int lastSitPosSaveTimestamp = 0;
    private int healingTick;
    private int drunkTickLeft = 0;
    private int silentTickLeft = 0;
    private float headRotationCourse;
    private float headRotationCourseOld;
    @Nonnull
    private WetSource wetSource = WetSource.NONE;
    private boolean isShaking;
    private float timeWolfIsShaking;
    private float prevTimeWolfIsShaking;
    private int tickUntilRest;
    private int onFireSmokeTick;
    private boolean shakeFire = false;
    private float percentDecreasePerHealthLost;
    private float maxHealth0;
    protected boolean dogJumping;
    protected float jumpPower;
    protected boolean isDogSwimming;
    public int lastOrderedToSitTick;
    public int randomStrollCooldown;
    private int tickChopinTail;
    private boolean dogAnimHurtImpules = false;
    private int idleAnimHurtCooldown = 0;
    private EntityDimensions visualDimension = null;
    private boolean isProtesting = false;
    private boolean ridingAuthorized = false;
    private boolean authorizedChangingOwner = false;
    private boolean authorizedChangingName = false;
    public static int MAX_NAME_LEN = 32;
    private boolean changeDimensionAuthorized = false;
    private boolean DTN_dogChangingDim = false;
    public OnlineDogLocationManager.RemoveState locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.NONE;
    private Optional<DamageSource> dogDeathCause = Optional.empty();
    private final DogDuplicationDetection dogDuplicateDetection = new DogDuplicationDetection(this);
    private DogAnimation sitAnim = DogAnimation.SIT_DOWN;
    private DogAnimation standAnim = DogAnimation.STAND_QUICK;
    private boolean isDogFollowingSomeone;
    private boolean isDogResistingPush;
    private boolean isDogCurious;
    private AnimationAction animAction;
    private DogPose activePose = DogPose.STAND;

    public Dog(EntityType<? extends Dog> type, Level worldIn) {
        super(type, worldIn);
        this.setTame(false, true);
        this.setGender(DogGender.random(this.getRandom()));
        this.setLowHealthStrategy(LowHealthStrategy.STICK_TO_OWNER);
        this.authorizedChangingOwner = true;
        this.setOwnerUUID(null);
        this.authorizedChangingOwner = false;
        this.resetTickTillRest();
        this.moveControl = new DogMoveControl(this);
        this.jumpControl = new DogJumpControl(this);
        this.defaultNavigation = (DogPathNavigation)this.navigation;
        this.defaultMoveControl = (DogMoveControl)this.moveControl;
        this.dogAi = new DogAiManager(this, this.level().getProfilerSupplier());
        this.dogAi.init();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DOG_VARIANT, (Object)DogVariantUtil.getDefault());
        builder.define(LAST_KNOWN_NAME, Optional.empty());
        builder.define(DOG_FLAGS, (Object)0);
        builder.define(GENDER, (Object)DogGender.UNISEX);
        builder.define(MODE, (Object)DogMode.DOCILE);
        builder.define(HUNGER_INT, (Object)Float.valueOf(60.0f));
        builder.define(CUSTOM_SKIN, (Object)DogSkinData.NULL);
        builder.define(DOG_LEVEL, (Object)new DogLevel(0, 0));
        builder.define(DOG_INCAP_SYNC_STATE, (Object)DogIncapacitatedMananger.IncapacitatedSyncState.NONE);
        builder.define(DOG_SIZE, (Object)DogSize.MODERATO);
        builder.define(BONE_VARIANT, (Object)ItemStack.EMPTY);
        builder.define(ARTIFACTS, new ArrayList(3));
        builder.define(DOG_BED_LOCATION, (Object)new Dimension2BlockPosMap());
        builder.define(DOG_BOWL_LOCATION, (Object)new Dimension2BlockPosMap());
        builder.define(INCAP_VAL, (Object)0);
        builder.define(ANIMATION, (Object)0);
        builder.define(ANIM_SYNC_TIME, (Object)0);
        builder.define(DOG_ANIM_DEBUG_STATE, (Object)DogAnimationManager.DogAnimDebugState.NONE);
        builder.define(DOG_PETTING_STATE, (Object)DogPettingManager.DogPettingState.NULL);
        builder.define(DOG_SLEEP_ON_STATE, (Object)DogSleepOnManager.DogSleepOnState.NULL);
    }

    protected final void registerGoals() {
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        float vol = this.isDogSilent() ? 0.01f : 0.15f;
        this.playSound(SoundEvents.WOLF_STEP, vol, 1.0f);
    }

    protected SoundEvent getAmbientSound() {
        boolean whine_health;
        if (this.dogSoundManager.isAmbientLocked()) {
            return null;
        }
        if (this.isDefeated()) {
            if (this.getDogIncapValue() > 20) {
                int chance_window = this.incapacitatedMananger.canMove() ? 5 : 8;
                return this.random.nextInt(chance_window) == 0 ? this.dogMood.getInjuredAmbient() : null;
            }
            return SoundEvents.WOLF_PANT;
        }
        if (this.pettingManager.isPetting() || this.isDogSilent()) {
            return null;
        }
        boolean bl = whine_health = this.isTame() && this.getHealth() < 10.0f && this.random.nextInt(3) == 0;
        if (whine_health) {
            return this.dogMood.getLowHealthWhine();
        }
        return this.dogMood.getAmbientSound();
    }

    public void playSound(SoundEvent sound, float vol, float pitch) {
        if (this.dogMood.isForceInteruptibleSound(sound)) {
            this.dogSoundManager.playInterruptible(sound, vol, pitch);
            return;
        }
        super.playSound(sound, vol, pitch);
    }

    @Override
    public float getSoundVolume() {
        float default_val = 0.4f;
        if (this.isDefeated() && this.getDogIncapValue() > 20) {
            default_val = this.incapacitatedMananger.canMove() ? 0.2f : 0.05f;
        }
        return default_val;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        if (this.canWolfArmorAbsorb(damageSourceIn)) {
            return SoundEvents.WOLF_ARMOR_DAMAGE;
        }
        return this.dogMood.getHurtSound(damageSourceIn);
    }

    protected void playHurtSound(DamageSource source) {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.dogSoundManager.playNonInterruptible(this.getHurtSound(source), this.getSoundVolume(), this.getVoicePitch());
    }

    protected SoundEvent getDeathSound() {
        return this.dogMood.getDeathSound();
    }

    protected SoundEvent getHowlSound() {
        return SoundEvents.WOLF_HOWL;
    }

    public void howl() {
        this.playSound(this.getHowlSound(), 1.0f, this.getVoicePitch());
    }

    public boolean isDogSoaked() {
        return this.wetSource.soaked();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShadingWhileWet(float partialTicks) {
        return Math.min(0.5f + Mth.lerp((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) / 2.0f * 0.5f, 1.0f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getShakeAngle(float partialTicks, float offset) {
        float f = (Mth.lerp((float)partialTicks, (float)this.prevTimeWolfIsShaking, (float)this.timeWolfIsShaking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.sin((float)(f * (float)Math.PI)) * Mth.sin((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getInterestedAngle(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.headRotationCourseOld, (float)this.headRotationCourse) * 0.15f * (float)Math.PI;
    }

    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
    }

    public void handleDogShakingUpdate(DogShakingData.State state) {
        switch (state) {
            case SHAKE_WATER: {
                this.startShaking();
                break;
            }
            case SHAKE_LAVA: {
                this.startShakingLava();
                break;
            }
            case STOP: {
                this.finishShaking();
                break;
            }
            default: {
                this.finishShaking();
            }
        }
        if (this.level().isClientSide) {
            this.dogSoundManager.interuptPlaying();
        }
    }

    public float getTailRotation() {
        if (!this.isTame()) {
            return 0.62831855f;
        }
        float full_health_angle = 1.73f;
        float lost_health = this.getMaxHealth() - this.getHealth();
        float lost_health_percent = lost_health * this.percentDecreasePerHealthLost;
        float lost_rad_percent = lost_health_percent * lost_health_percent;
        float lost_rad = 1.5707964f * lost_rad_percent;
        lost_rad = Mth.clamp((float)lost_rad, (float)0.0f, (float)1.5707964f);
        return 1.73f - lost_rad;
    }

    @Override
    public float getWagAngle(float limbSwing, float limbSwingAmount, float partialTickTime) {
        return Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.6f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    public int getMaxHeadXRot() {
        return this.isInSittingPose() ? 20 : super.getMaxHeadXRot();
    }

    protected void addPassenger(Entity passanger) {
        super.addPassenger(passanger);
        this.refreshDimensions();
    }

    protected void removePassenger(Entity passanger) {
        super.removePassenger(passanger);
        this.refreshDimensions();
    }

    public EntityDimensions getDimensions(Pose pose) {
        boolean collide_passeneger;
        EntityDimensions self_dim = super.getDimensions(pose);
        this.visualDimension = null;
        if (self_dim.width() >= 1.0f) {
            self_dim = new EntityDimensions(1.0f, self_dim.height(), self_dim.eyeHeight(), self_dim.attachments(), self_dim.fixed());
        }
        if (!(collide_passeneger = ((Boolean)ConfigHandler.SERVER.WOLF_MOUNT_PASSENGER_COLLISION.get()).booleanValue())) {
            return self_dim;
        }
        if (this.isVehicle() && !this.getPassengers().isEmpty()) {
            this.visualDimension = self_dim;
            self_dim = this.computeRidingDimension(self_dim);
        }
        return self_dim;
    }

    public double getPassengersRidingOffset(EntityDimensions self_dim) {
        return (double)self_dim.height() * 0.75;
    }

    public EntityDimensions getRealDimensions() {
        return super.getDimensions(this.getPose());
    }

    @Override
    public float getDogVisualBbHeight() {
        if (this.visualDimension != null) {
            return this.visualDimension.height();
        }
        return this.getBbHeight();
    }

    @Override
    public float getDogVisualBbWidth() {
        if (this.visualDimension != null) {
            return this.visualDimension.width();
        }
        return this.getBbWidth();
    }

    private EntityDimensions computeRidingDimension(EntityDimensions self_dim) {
        float total_width = self_dim.width();
        Entity passenger = (Entity)this.getPassengers().get(0);
        float total_height = self_dim.height();
        total_width = Math.max(total_width, passenger.getBbWidth());
        total_height = (float)((double)total_height + ((double)passenger.getBbHeight() - passenger.getVehicleAttachmentPoint((Entity)this).y));
        if (total_width >= 1.0f) {
            total_width = 1.0f;
        }
        return new EntityDimensions(total_width, total_height, self_dim.eyeHeight(), self_dim.attachments(), self_dim.fixed());
    }

    public void tick() {
        LivingEntity owner;
        super.tick();
        this.updateClassicalAnim();
        if (this.isAlive()) {
            this.updateDogPose();
        }
        this.alterations.forEach(alter -> alter.tick(this));
        if (this.isAlive() && this.getMaxHealth() != this.maxHealth0) {
            this.maxHealth0 = this.getMaxHealth();
            this.percentDecreasePerHealthLost = 1.0f / this.maxHealth0;
        }
        if (this.isAlive() && !this.level().isClientSide && this.tickCount % 40 == 0 && (owner = this.getOwner()) != null) {
            this.setOwnersName(owner.getName());
        }
        if (this.isAlive()) {
            this.animationManager.tick();
            if (!this.level().isClientSide) {
                this.tickAnimAction();
            }
        }
        this.pettingManager.tick();
        this.sleepOnManager.tick();
        this.dogSoundManager.tick();
        if (this.level().isClientSide) {
            // empty if block
        }
        if (this.level().isClientSide && ((Boolean)ConfigHandler.CLIENT.DISPLAY_SMOKE_WHEN_ON_FIRE.get()).booleanValue()) {
            this.addAdditionalOnFireEffect();
        }
        if (!this.level().isClientSide) {
            this.dogSyncedDataManager.tick();
        }
    }

    private void addAdditionalOnFireEffect() {
        if (this.isOnFire()) {
            if (this.getRandom().nextInt(3) == 0) {
                float f1 = (this.getRandom().nextFloat() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.getRandom().nextFloat() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + (double)f1, this.getY() + (double)this.getEyeHeight(), this.getZ() + (double)f2, 0.0, 0.05, 0.0);
            }
            if (this.onFireSmokeTick <= 300) {
                ++this.onFireSmokeTick;
            } else if (this.onFireSmokeTick <= 600 && this.tickCount % 4 == 0) {
                ++this.onFireSmokeTick;
            }
            this.onFireSmokeTick = Mth.clamp((int)this.onFireSmokeTick, (int)20, (int)300);
        } else if (this.onFireSmokeTick > 0) {
            --this.onFireSmokeTick;
            if (this.getRandom().nextInt(3) == 0) {
                float f1 = (this.getRandom().nextFloat() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.getRandom().nextFloat() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX() + (double)f1, this.getY() + (double)this.getEyeHeight(), this.getZ() + (double)f2, 0.0, 0.05, 0.0);
            }
        }
    }

    private void updateClassicalAnim() {
        if (!this.isAlive()) {
            return;
        }
        this.updateClassicalBegAnim();
        boolean val = this.checkDogInWetSourceAndWetTheDog();
        this.updateClassicalShakeAnim(val);
    }

    private void updateClassicalBegAnim() {
        if (!this.canDogDoBegAnim()) {
            this.headRotationCourse = 0.0f;
            this.headRotationCourseOld = 0.0f;
            return;
        }
        this.headRotationCourseOld = this.headRotationCourse;
        this.headRotationCourse = this.isBegging() ? (this.headRotationCourse += (1.0f - this.headRotationCourse) * 0.4f) : (this.headRotationCourse += (0.0f - this.headRotationCourse) * 0.4f);
    }

    private boolean checkDogInWetSourceAndWetTheDog() {
        if (this.isInLava()) {
            this.wetSource = WetSource.LAVA;
            return true;
        }
        if (this.isInWater()) {
            this.wetSource = WetSource.WATER;
            return true;
        }
        if (this.isInWaterOrRain()) {
            this.wetSource = WetSource.RAIN;
            return true;
        }
        if (this.isInWaterOrBubble()) {
            this.wetSource = WetSource.BUBBLE_COLUMN;
            return true;
        }
        return false;
    }

    private void updateClassicalShakeAnim(boolean currentlyInWater) {
        if (!this.level().isClientSide && this.isShaking && (!this.canDogDoShakeAnim() || currentlyInWater)) {
            this.finishShaking();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.STOP);
            return;
        }
        if (!this.isShaking) {
            return;
        }
        if (this.timeWolfIsShaking == 0.0f && this.level().isClientSide && !this.shakeFire) {
            this.dogSoundManager.playInterruptible(SoundEvents.WOLF_SHAKE, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
        this.prevTimeWolfIsShaking = this.timeWolfIsShaking;
        this.timeWolfIsShaking += 0.05f;
        if (this.prevTimeWolfIsShaking >= 2.0f) {
            for (IDogAlteration alter : this.alterations) {
                alter.onShakingDry(this, this.wetSource);
            }
            this.wetSource = WetSource.NONE;
            this.finishShaking();
        }
        if (this.timeWolfIsShaking > 0.4f) {
            float f = (float)this.getY();
            int i = (int)(Mth.sin((float)((this.timeWolfIsShaking - 0.4f) * (float)Math.PI)) * 7.0f);
            Vec3 vec3d = this.getDeltaMovement();
            for (int j = 0; j < i; ++j) {
                float f1 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                float f2 = (this.random.nextFloat() * 2.0f - 1.0f) * this.getDogVisualBbWidth() * 0.5f;
                if (this.shakeFire) {
                    float r = this.getRandom().nextFloat();
                    SimpleParticleType type = ParticleTypes.SMOKE;
                    if (r <= 0.15f) {
                        type = ParticleTypes.LANDING_LAVA;
                    } else if (r <= 0.6f) {
                        type = ParticleTypes.LAVA;
                    }
                    this.level().addParticle((ParticleOptions)type, this.getX() + (double)f1, (double)(f + 0.8f), this.getZ() + (double)f2, vec3d.x, vec3d.y, vec3d.z);
                    continue;
                }
                this.level().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() + (double)f1, (double)(f + 0.8f), this.getZ() + (double)f2, vec3d.x, vec3d.y, vec3d.z);
            }
        }
        if ((double)this.timeWolfIsShaking > 0.5 && this.shakeFire && this.random.nextInt(6) == 0) {
            this.playSound(SoundEvents.FIRE_EXTINGUISH, this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    public boolean canDoIdileAnim() {
        if (!this.isAlive()) {
            return false;
        }
        if (this.isPassenger() || this.isVehicle()) {
            return false;
        }
        if (this.idleAnimHurtCooldown > 0) {
            return false;
        }
        return !this.isShaking && !this.getAnim().interupting();
    }

    public boolean canContinueDoIdileAnim() {
        if (this.dogAnimHurtImpules) {
            this.dogAnimHurtImpules = false;
            this.idleAnimHurtCooldown = 20;
            return false;
        }
        if (this.isPassenger() || this.isVehicle()) {
            return false;
        }
        return this.isAlive() && !this.isShaking;
    }

    public void setAnimForIdle(DogAnimation anim) {
        this.setAnim(anim);
        this.dogAnimHurtImpules = false;
    }

    public boolean canDogDoBegAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canBeg) {
            return false;
        }
        return !this.animationManager.started() || this.getAnim().freeHead();
    }

    public boolean canDogDoShakeAnim() {
        DogPose pose = this.getDogPose();
        if (!pose.canShake) {
            return false;
        }
        return !this.animationManager.started();
    }

    public void aiStep() {
        if (this.navigation != this.currentNavigation) {
            this.navigation = this.currentNavigation;
        }
        if (this.navigationLock != null) {
            this.navigationLock.unlockDogNavigation();
        }
        this.validateGoalsAndTickNonRunningIfNeeded();
        if (!this.level().isClientSide) {
            this.getSensing().tick();
            this.lerpSteps = 0;
            this.lerpHeadSteps = 0;
            this.dogAi.tickServer();
            this.dogSwimmingManager.tickServer();
        }
        super.aiStep();
        this.updateDogBeginShake();
        if (!this.level().isClientSide && !this.isDefeated()) {
            this.hungerManager.tick();
            this.tickDogHealing();
            this.dogOwnerDistanceManager.tick();
            this.avoidGoInFrontOfOwnerManager.tick();
        }
        if (!this.level().isClientSide) {
            this.dogMood.tickServer();
            this.dogPushAvoidManager.tickServer();
            this.dogAttackManager.tickServer();
        }
        if (this.level().isClientSide && this.getDogLevel().isFullKami() && ((Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.KAMI_PARTICLES)).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        if (this.level().isClientSide && this.isInDrunkPose() && this.tickCount % 16 == 0) {
            int color = 10101987;
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)color), this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), 1.0, 1.0, 1.0);
        }
        if (this.tickCount % 50 == 0) {
            ResourceKey dimKey = this.level().dimension();
            Optional<BlockPos> bowlPos = this.getBowlPos((ResourceKey<Level>)dimKey);
            if (bowlPos.isPresent() && this.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)((Vec3i)bowlPos.get()))) >= 64.0) {
                this.setBowlPos((ResourceKey<Level>)dimKey, Optional.empty());
            }
            if (bowlPos.isPresent() && this.level().hasChunkAt(bowlPos.get()) && !this.level().getBlockState(bowlPos.get()).is((Block)DoggyBlocks.FOOD_BOWL.get())) {
                this.setBowlPos((ResourceKey<Level>)dimKey, Optional.empty());
            }
        }
        this.alterations.forEach(alter -> alter.livingTick(this));
        if (this.isDefeated()) {
            this.incapacitatedMananger.tick();
        }
        if (this.tickChopinTail > 0) {
            --this.tickChopinTail;
        }
        if (this.randomStrollCooldown > 0) {
            --this.randomStrollCooldown;
        }
        if (this.switchNavCooldown > 0) {
            --this.switchNavCooldown;
        }
        if (this.idleAnimHurtCooldown > 0) {
            --this.idleAnimHurtCooldown;
        }
        if (this.drunkTickLeft > 0) {
            --this.drunkTickLeft;
        }
        if (this.silentTickLeft > 0) {
            --this.silentTickLeft;
        }
        if (!this.level().isClientSide && this.isInSittingPose() && !this.isDogResting() && this.tickUntilRest > 0) {
            --this.tickUntilRest;
        }
        if (!this.level().isClientSide && this.fireImmune()) {
            this.mayFloatDogInLava();
        }
        if (this.navigationLock != null) {
            this.navigationLock.lockDogNavigation();
        }
    }

    private void tickDogHealing() {
        int healingTick_add = 8;
        if (this.isInSittingPose()) {
            healingTick_add += 4;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.healingTick(this, healingTick_add);
            if (!result.getResult().shouldSwing()) continue;
            healingTick_add = (Integer)result.getObject();
        }
        if (healingTick_add < 0) {
            healingTick_add = 0;
        }
        this.healingTick += healingTick_add;
        if (this.healingTick >= 6000) {
            if (this.getHealth() < this.getMaxHealth()) {
                this.heal(2.0f);
            }
            this.healingTick = 0;
        }
    }

    private void updateDogBeginShake() {
        if (this.level().isClientSide) {
            return;
        }
        if (this.isShaking) {
            return;
        }
        if (this.isPathFinding()) {
            return;
        }
        if (!this.onGround()) {
            return;
        }
        if (!this.canDogDoShakeAnim()) {
            return;
        }
        if (this.wetSource.isNone()) {
            return;
        }
        if (this.checkDogInWetSourceAndWetTheDog()) {
            return;
        }
        if (this.wetSource.flame() && this.isOnFire()) {
            return;
        }
        this.startShakingAndBroadcast(this.wetSource.flame());
    }

    private void validateGoalsAndTickNonRunningIfNeeded() {
        if (this.level().isClientSide) {
            return;
        }
        Set availableGoals = this.goalSelector.getAvailableGoals();
        if (!availableGoals.isEmpty()) {
            availableGoals.clear();
        }
    }

    public boolean triggerAction(TriggerableAction action) {
        return this.dogAi.triggerAction(action);
    }

    public boolean isBusy() {
        if (!this.isDoingFine()) {
            return true;
        }
        if (this.isInSittingPose() && this.forceSit()) {
            return true;
        }
        if (this.dogAi.isBusy()) {
            return true;
        }
        return this.hasControllingPassenger();
    }

    public boolean readyForNonTrivialAction() {
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.isInSittingPose() && this.forceSit()) {
            return false;
        }
        if (!this.dogAi.readyForNonTrivivalAction()) {
            return false;
        }
        return !this.hasControllingPassenger();
    }

    public void clearTriggerableAction() {
        this.dogAi.clearTriggerableAction();
    }

    public boolean triggerActionDelayed(int delay, TriggerableAction action) {
        return this.dogAi.triggerActionDelayed(action, delay);
    }

    public boolean isOnSwitchNavCooldown() {
        return this.switchNavCooldown > 0;
    }

    public boolean canUpdateDogAi() {
        return !this.isImmobile() && this.isEffectiveAi() && !this.isDogInAnimDebug();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.isDefeated()) {
            return this.incapacitatedMananger.interact(stack, player, hand);
        }
        if (this.handleOpenDogScreenDedicated(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleTameDogIfNotTamed(player, stack, hand).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.dogCheckAndRidePlayer(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleSetWolfArmor(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleRepairWolfArmor(player, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleUnsetWolfArmor(player, stack, hand).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        Optional<InteractionResult> otherHandlerResult = this.handleAlterationsAndOtherHandlers(player, stack, hand);
        if (otherHandlerResult.isPresent()) {
            return otherHandlerResult.get();
        }
        if (this.handleBreeding(player, hand, stack).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleOpenDogScreen(player).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.handleDogSitStand(player).shouldSwing()) {
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide) {
            this.displayToastIfNoPermission(player);
        }
        return InteractionResult.PASS;
    }

    private InteractionResult handleDogSitStand(Player player) {
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.FAIL;
        }
        if (this.isProtesting()) {
            return InteractionResult.FAIL;
        }
        if (!this.level().isClientSide) {
            this.checkAndDoBackFlip();
        }
        if (!this.level().isClientSide && !this.isOrderedToSit()) {
            this.lastOrderedToSitTick = this.tickCount;
        }
        this.setOrderedToSit(!this.isOrderedToSit());
        this.jumping = false;
        this.navigation.stop();
        this.setTarget(null);
        return InteractionResult.SUCCESS;
    }

    private void checkAndDoBackFlip() {
        if (!this.isOrderedToSit()) {
            return;
        }
        if (!this.isInSittingPose()) {
            return;
        }
        int sit_interval = this.tickCount - this.lastOrderedToSitTick;
        float r = this.getRandom().nextFloat();
        if (!this.checkDogBackflipRandom(r, sit_interval)) {
            return;
        }
        if (!this.checkDogBackflipAreaAbove()) {
            return;
        }
        this.setStandAnim(DogAnimation.NONE);
        this.setInSittingPose(false);
        this.triggerAnimationAction(new DogBackFlipAction(this));
    }

    private boolean checkDogBackflipRandom(float r, int sit_interval) {
        if (sit_interval <= 30) {
            return false;
        }
        if (sit_interval >= 1200) {
            return r <= 0.7f;
        }
        return r <= 0.3f;
    }

    private boolean checkDogBackflipAreaAbove() {
        return this.level().getBlockState(this.blockPosition().above()).isAir();
    }

    private InteractionResult handleOpenDogScreen(Player player) {
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            DogNewInfoScreen.open(this);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleOpenDogScreenDedicated(Player player, ItemStack stack) {
        if (stack.getItem() != Items.STICK) {
            return InteractionResult.FAIL;
        }
        if (!this.isTame()) {
            return InteractionResult.FAIL;
        }
        if (!this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (this.canInteract((LivingEntity)player)) {
            DogNewInfoScreen.open(this);
        } else {
            DogCannotInteractWithScreen.open(this);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult dogCheckAndRidePlayer(Player player, ItemStack stack) {
        if (player.hasPassenger((Entity)this)) {
            if (!this.level().isClientSide) {
                this.unRide();
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() != Items.BONE) {
            return InteractionResult.PASS;
        }
        if (!player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (this.isVehicle()) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (!this.level().isClientSide && this.startRiding((Entity)player)) {
            player.displayClientMessage((Component)Component.translatable((String)"talent.doggytalents.bed_finder.dog_mount", (Object[])new Object[]{this.getGenderPronoun()}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleSetWolfArmor(Player player, ItemStack stack) {
        if (!stack.is(Items.WOLF_ARMOR)) {
            return InteractionResult.PASS;
        }
        if (this.hasWolfArmor()) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.setWolfArmor(stack.copyWithCount(1));
        stack.consume(1, (LivingEntity)player);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleRepairWolfArmor(Player player, ItemStack stack) {
        if (!DogUtil.isScute(stack)) {
            return InteractionResult.PASS;
        }
        if (!this.hasWolfArmor()) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        ItemStack wolf_armor = this.wolfArmor();
        if (!wolf_armor.isDamaged()) {
            return InteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        stack.shrink(1);
        this.playSound(SoundEvents.WOLF_ARMOR_REPAIR);
        int repair_val = DogUtil.getWolfArmorRepairVal(wolf_armor);
        int new_damage_val = wolf_armor.getDamageValue() - repair_val;
        if (new_damage_val < 0) {
            new_damage_val = 0;
        }
        wolf_armor.setDamageValue(new_damage_val);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleUnsetWolfArmor(Player player, ItemStack stack, InteractionHand hand) {
        if (!stack.is(Items.SHEARS)) {
            return InteractionResult.PASS;
        }
        if (!this.hasWolfArmor()) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        stack.hurtAndBreak(1, (LivingEntity)player, Dog.getSlotForHand((InteractionHand)hand));
        this.playSound(SoundEvents.ARMOR_UNEQUIP_WOLF);
        ItemStack wolf_armor0 = this.wolfArmor();
        this.setWolfArmor(ItemStack.EMPTY);
        this.spawnAtLocation(wolf_armor0);
        return InteractionResult.SUCCESS;
    }

    private Optional<InteractionResult> handleAlterationsAndOtherHandlers(Player player, ItemStack stack, InteractionHand hand) {
        Optional<IDogFoodHandler> foodHandler = FoodHandler.getMatch(this, stack, (Entity)player);
        if (foodHandler.isPresent()) {
            return Optional.of(foodHandler.get().consume(this, stack, (Entity)player));
        }
        InteractionResult dog_item_result = IDogItem.getMatch(this, stack, player, hand);
        if (dog_item_result != InteractionResult.PASS) {
            return Optional.of(dog_item_result);
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.processInteract(this, this.level(), player, hand);
            if (result == InteractionResult.PASS) continue;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private InteractionResult handleBreeding(Player player, InteractionHand hand, ItemStack stack) {
        if (!stack.is(DoggyItems.BREEDING_BONE.get())) {
            return InteractionResult.PASS;
        }
        if (!this.canInteract((LivingEntity)player)) {
            return InteractionResult.PASS;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int age = this.getAge();
        if (age == 0 && this.canFallInLove()) {
            this.usePlayerItem(player, hand, stack);
            this.setInLove(player);
        } else if (this.isBaby()) {
            this.usePlayerItem(player, hand, stack);
            this.ageUp(Dog.getSpeedUpSecondsWhenFeeding((int)(-age)), true);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult handleTameDogIfNotTamed(Player player, ItemStack stack, InteractionHand hand) {
        boolean alwaysTame;
        if (this.isTame()) {
            return InteractionResult.FAIL;
        }
        if (!this.isDogTameItem(stack)) {
            return InteractionResult.FAIL;
        }
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.usePlayerItem(player, hand, stack);
        boolean bl = alwaysTame = stack.getItem() == DoggyItems.TRAINING_TREAT.get();
        if (alwaysTame || this.random.nextInt(3) == 0) {
            this.tame(player);
            this.navigation.stop();
            this.setTarget(null);
            this.setOrderedToSit(true);
            this.maxHealth();
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean isDogTameItem(ItemStack stack) {
        return stack.is(Items.BONE) || stack.is(DoggyItems.TRAINING_TREAT.get());
    }

    @Override
    public boolean canStillEat() {
        if (this.level().isClientSide) {
            return false;
        }
        if (((Boolean)ConfigHandler.SERVER.DISABLE_HUNGER.get()).booleanValue() && this.getHealth() < this.getMaxHealth() && this.hungerManager.saturation() <= 0) {
            return true;
        }
        return this.getDogHunger() < this.getMaxHunger();
    }

    public boolean isProtesting() {
        return this.isProtesting;
    }

    public void setProtesting(boolean p) {
        this.isProtesting = p;
    }

    private void displayToastIfNoPermission(Player player) {
        if (this.canInteract((LivingEntity)player)) {
            return;
        }
        player.displayClientMessage((Component)Component.translatable((String)"doggui.invalid_dog.no_permission.title", (Object[])new Object[]{this.getGenderPronoun()}).withStyle(ChatFormatting.RED), true);
    }

    public boolean dismountsUnderwater() {
        if (this.canSwimUnderwater() && this.alterationProps.canBreatheUnderwater()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBeRiddenInWater(this);
            if (result.shouldSwing()) {
                return false;
            }
            if (result != InteractionResult.FAIL) continue;
            return true;
        }
        return super.dismountsUnderwater();
    }

    public void stopRiding() {
        if (!this.level().isClientSide) {
            Entity e0 = this.getVehicle();
            super.stopRiding();
            Entity e1 = this.getVehicle();
            if (e0 != e1 && e0 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)e0;
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.getId(), false));
            }
        } else {
            super.stopRiding();
        }
    }

    public boolean startRiding(Entity entity, boolean force_ride) {
        boolean not_authorized;
        boolean result = false;
        boolean bl = not_authorized = this.requireRidingAuthorization(entity) && !this.isRidingAuthorized();
        if (!not_authorized) {
            result = super.startRiding(entity, force_ride);
        }
        this.ridingAuthorized = false;
        if (!this.level().isClientSide && result && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketHandler.send(PacketDistributor.PLAYER.with(() -> player), new DogMountData(this.getId(), true));
        }
        return result;
    }

    public boolean isRidingAuthorized() {
        return this.ridingAuthorized;
    }

    public void authorizeRiding() {
        this.ridingAuthorized = true;
    }

    public boolean requireRidingAuthorization(Entity entity) {
        Dog otherDog;
        if (this.dogAutoMount()) {
            return false;
        }
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID == null) {
            return false;
        }
        if (!ObjectUtils.notEqual((Object)ownerUUID, (Object)entity.getUUID())) {
            return false;
        }
        return !(entity instanceof Dog) || ObjectUtils.notEqual((Object)ownerUUID, (Object)(otherDog = (Dog)entity).getOwnerUUID());
    }

    public boolean showVehicleHealth() {
        if (this.level().isClientSide) {
            return ClientEventHandler.showWolfMountHealth();
        }
        return super.showVehicleHealth();
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_332775_, DifficultyInstance p_332793_, MobSpawnType p_332761_, @Nullable SpawnGroupData p_332782_) {
        return null;
    }

    public double getAttributeValue(Holder<Attribute> attrib) {
        if (attrib == Attributes.FOLLOW_RANGE) {
            DogAttackManager attack_manager = this.dogAttackManager;
            if (attack_manager != null && attack_manager.isDogFarChasingTarget()) {
                return 32.0;
            }
            IDogRangedAttackManager ranged_attack = this.getDogRangedAttack();
            if (ranged_attack != null && ranged_attack.isApplicable(this)) {
                return 20.0;
            }
        }
        return super.getAttributeValue(attrib);
    }

    public boolean causeFallDamage(float distance, float damageMultiplier, DamageSource source) {
        if (this.dogFallImmune()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.onLivingFall(this, distance, damageMultiplier);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        float[] ret = CommonHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        int i = this.calculateFallDamage(distance, damageMultiplier);
        if (i > 0) {
            if (this.isVehicle()) {
                for (Entity e : this.getPassengers()) {
                    e.hurt(this.damageSources().fall(), (float)i);
                }
            }
            this.playSound(i > 4 ? this.getFallSounds().big() : this.getFallSounds().small(), 1.0f, 1.0f);
            this.playBlockFallSound();
            this.hurt(this.damageSources().fall(), i);
            return true;
        }
        return false;
    }

    public boolean dogFallImmune() {
        return this.alterationProps.fallImmune();
    }

    public int getMaxFallDistance() {
        return 3;
    }

    protected int calculateFallDamage(float distance, float damageMultiplier) {
        MobEffectInstance effectInst = this.getEffect(MobEffects.JUMP);
        float f = effectInst == null ? 0.0f : (float)(effectInst.getAmplifier() + 1);
        distance -= f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.calculateFallDistance(this, distance);
            if (!result.getResult().shouldSwing()) continue;
            distance = ((Float)result.getObject()).floatValue();
            break;
        }
        return Mth.ceil((float)((distance - 3.0f - f) * damageMultiplier));
    }

    protected void checkFallDamage(double fallVelocity, boolean onGround, BlockState state, BlockPos pos) {
        if (this.fireImmune() && state.getBlock() == Blocks.LAVA) {
            this.resetFallDistance();
        }
        super.checkFallDamage(fallVelocity, onGround, state, pos);
    }

    public boolean canBreatheUnderwater() {
        return this.alterationProps.canBreatheUnderwater();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return !this.alterationProps.canBreatheUnderwater();
    }

    protected int decreaseAirSupply(int air) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.decreaseAirSupply(this, air);
            if (!result.getResult().shouldSwing()) continue;
            return (Integer)result.getObject();
        }
        return super.decreaseAirSupply(air);
    }

    public boolean canStandOnFluid(FluidState state) {
        if (this.fireImmune() && state.is(FluidTags.LAVA)) {
            return true;
        }
        return super.canStandOnFluid(state);
    }

    public boolean ignoreExplosion(Explosion x) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.negateExplosion(this);
            if (!result.shouldSwing()) continue;
            return true;
        }
        return super.ignoreExplosion(x);
    }

    protected int increaseAirSupply(int currentAir) {
        currentAir += 4;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.determineNextAir(this, currentAir);
            if (!result.getResult().shouldSwing()) continue;
            currentAir = (Integer)result.getObject();
            break;
        }
        return Math.min(currentAir, this.getMaxAirSupply());
    }

    public boolean canAttack(LivingEntity target) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        if (this.getMode().minorAttack() && this.dogMinorAttackCheckToAvoid(target)) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canAttack(this, target);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper) {
            return false;
        }
        return super.canAttack(target);
    }

    private boolean dogMinorAttackCheckToAvoid(LivingEntity target) {
        LivingEntity owner;
        if (target instanceof ZombifiedPiglin) {
            return true;
        }
        if (target instanceof AbstractPiglin && (owner = this.getOwner()) != null) {
            for (ItemStack stack : owner.getArmorSlots()) {
                if (!stack.makesPiglinsNeutral(owner)) continue;
                return true;
            }
        }
        return target.getType().is(DoggyTags.DOG_SHOULD_IGNORE);
    }

    public boolean canAttackType(EntityType<?> entityType) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        return entityType != EntityType.GHAST || this.canDogFly();
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (!this.getMode().shouldAttack()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldAttackEntity(this, target, owner);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        if (target instanceof Creeper) {
            return false;
        }
        return !DogAllyCheck.isAlliedToDog(this, (Entity)target, owner);
    }

    protected boolean stillIdleOrSitWhenHurt(DamageSource source, float amount) {
        if (this.isDogDrunk()) {
            return true;
        }
        if (this.isPassenger()) {
            return true;
        }
        for (IDogAlteration alt : this.alterations) {
            if (!alt.stillIdleOrSitWhenHurt(this, source, amount).shouldSwing()) continue;
            return true;
        }
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean flag;
        Entity attacker = source.getEntity();
        if (this.isDefeated() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            Mob mob;
            LivingEntity target;
            this.incapacitatedMananger.onHurt();
            if (attacker instanceof Mob && (target = (mob = (Mob)attacker).getTarget()) == this) {
                mob.setTarget(null);
            }
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.gettingAttackedFrom(this, source, amount);
            if (result.getResult() == InteractionResult.FAIL) {
                return false;
            }
            amount = ((Float)result.getObject()).floatValue();
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && attacker instanceof Player) {
            return false;
        }
        if (!this.canOwnerAttack() && (flag = DogAllyCheck.isAlliedToDog(this, attacker))) {
            return false;
        }
        float health0 = this.getHealth();
        this.dogMood.onStartHurting(health0);
        boolean ret = super.hurt(source, amount);
        float actual_hurt_amount = health0 - this.getHealth();
        if (!this.level().isClientSide) {
            this.mayStandUpAndPlayHurtAnim(source, actual_hurt_amount, health0);
            if (actual_hurt_amount > 0.0f) {
                DogSleepOnManager.onHurt(this);
            }
        }
        if (this.level().isClientSide && ((Boolean)ConfigHandler.CLIENT.BLOCK_RED_OVERLAY_WHEN_HURT.get()).booleanValue()) {
            this.hurtTime = 0;
            this.hurtDuration = 0;
        }
        return ret;
    }

    protected void actuallyHurt(DamageSource source, float amount) {
        if (this.mayWolfArmorAbsorb(source, amount)) {
            return;
        }
        super.actuallyHurt(source, amount);
    }

    private boolean mayWolfArmorAbsorb(DamageSource source, float amount) {
        if (!this.canWolfArmorAbsorb(source)) {
            return false;
        }
        ItemStack wolf_armor_stack = this.wolfArmor();
        int damage_val0 = wolf_armor_stack.getDamageValue();
        int damage_max0 = wolf_armor_stack.getMaxDamage();
        wolf_armor_stack.hurtAndBreak(Mth.ceil((float)amount), (LivingEntity)this, EquipmentSlot.BODY);
        this.playWolfArmorCrackSound(this.useItem, damage_val0, damage_max0);
        return true;
    }

    private boolean canWolfArmorAbsorb(DamageSource source) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_WOLF_ARMOR_FUNCTION.get()).booleanValue()) {
            return false;
        }
        return this.hasWolfArmor() && !source.is(DamageTypeTags.BYPASSES_WOLF_ARMOR);
    }

    private void playWolfArmorCrackSound(ItemStack wolf_armor_stack, int damage_val0, int damage_max0) {
        Crackiness.Level crackiness0 = Crackiness.WOLF_ARMOR.byDamage(damage_val0, damage_max0);
        Crackiness.Level crackiness = Crackiness.WOLF_ARMOR.byDamage(wolf_armor_stack);
        if (crackiness == crackiness0) {
            return;
        }
        this.playSound(SoundEvents.WOLF_ARMOR_CRACK);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            sLevel.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, Items.ARMADILLO_SCUTE.getDefaultInstance()), this.getX(), this.getY() + 1.0, this.getZ(), 20, 0.2, 0.1, 0.2, 0.1);
        }
    }

    private void mayStandUpAndPlayHurtAnim(DamageSource source, float real_hurt_amount, float health0) {
        if (this.isDefeated()) {
            return;
        }
        if (this.isDeadOrDying()) {
            this.setOrderedToSit(false);
            this.setInSittingPose(false);
            this.setAnim(DogAnimation.HURT_1);
            return;
        }
        if (this.stillIdleOrSitWhenHurt(source, real_hurt_amount)) {
            return;
        }
        this.dogAnimHurtImpules = true;
        this.setOrderedToSit(false);
        boolean wasSitting = this.isInSittingPose();
        if (wasSitting) {
            this.setStandAnim(DogAnimation.NONE);
            this.setInSittingPose(false);
        }
        if (wasSitting || real_hurt_amount >= 6.0f) {
            this.setAnim(DogAnimation.HURT_1);
            return;
        }
        if (source.getEntity() != null && real_hurt_amount >= 1.0f) {
            this.setAnim(DogAnimation.HURT_2);
            return;
        }
    }

    public boolean doHurtTarget(Entity target) {
        for (IDogAlteration alter : this.alterations) {
            alter.doInitialAttackEffects(this, target);
        }
        AttributeInstance attackDamageInst = this.getAttribute(Attributes.ATTACK_DAMAGE);
        AttributeInstance critDamageInst = this.getAttribute((Holder)DoggyAttributes.CRIT_CHANCE);
        Set critModifiers = null;
        if (critDamageInst != null && critDamageInst.getValue() > this.getRandom().nextDouble()) {
            AttributeInstance critBonusInst = this.getAttribute((Holder)DoggyAttributes.CRIT_BONUS);
            Set set = critModifiers = critBonusInst == null ? null : critBonusInst.getModifiers();
            if (critModifiers != null && attackDamageInst != null) {
                critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).addTransientModifier(arg_0));
            }
        }
        float damage = (float)(attackDamageInst == null ? 0.0 : attackDamageInst.getValue());
        ItemStack stack = this.getMainHandItem();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)stack, (Entity)target, (DamageSource)this.damageSources().mobAttack((LivingEntity)this), (float)damage);
        }
        if (critModifiers != null && attackDamageInst != null) {
            critModifiers.forEach(arg_0 -> ((AttributeInstance)attackDamageInst).removeModifier(arg_0));
        }
        this.doInitialEnchantDamageEffects((LivingEntity)this, target);
        boolean flag = target.hurt(this.damageSources().mobAttack((LivingEntity)this), damage);
        if (!flag) {
            return false;
        }
        Level level2 = this.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverlevel1 = (ServerLevel)level2;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)target, (DamageSource)this.damageSources().mobAttack((LivingEntity)this));
        }
        this.statsTracker.increaseDamageDealt(damage);
        if (critModifiers != null) {
            ParticlePackets.CritEmitterPacket.sendCritEmitterPacketToNearClients(target);
            this.playSound(SoundEvents.PLAYER_ATTACK_CRIT, 0.5f, 1.0f);
        }
        for (IDogAlteration alter : this.alterations) {
            alter.doAdditionalAttackEffects(this, target);
        }
        if (this.hasEffect((Holder)DoggyEffects.NATTO_BITE) && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            ((NattoBiteEffect)((Object)DoggyEffects.NATTO_BITE.get())).doAdditionalAttackEffects(this, living);
        }
        this.setLastHurtMob(target);
        return true;
    }

    public boolean killedEntity(ServerLevel level, LivingEntity entity) {
        if (!((Boolean)ConfigHandler.SERVER.DISABLE_KILL_STATS.get()).booleanValue()) {
            this.statsTracker.incrementKillCount((Entity)entity);
        }
        return true;
    }

    protected void doInitialEnchantDamageEffects(LivingEntity dog, Entity target) {
        float knockback = this.getKnockback(target, this.damageSources().mobAttack((LivingEntity)this));
        if (knockback > 0.0f && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.knockback((double)(knockback * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 1.0, 0.6));
        }
    }

    public boolean isDamageSourceBlocked(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canBlockDamageSource(this, source);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.isDamageSourceBlocked(source);
    }

    public boolean canBeSeenAsEnemy() {
        return !this.isDefeated() && super.canBeSeenAsEnemy();
    }

    public void setRemainingFireTicks(int ticks) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Integer> result = alter.setFire(this, ticks);
            if (!result.getResult().shouldSwing()) continue;
            ticks = (Integer)result.getObject();
        }
        super.setRemainingFireTicks(ticks);
    }

    public boolean fireImmune() {
        return this.alterationProps.fireImmune();
    }

    public boolean canFreeze() {
        return !this.alterationProps.fireImmune();
    }

    public boolean shouldDogNotAfraidOfFire() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldNotAfraidOfFire(this);
            if (!result.shouldSwing()) continue;
            return true;
        }
        return false;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerableTo(this, source);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean isInvulnerable() {
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isInvulnerable(this);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.isInvulnerable();
    }

    public boolean addEffect(MobEffectInstance effectInst, @Nullable Entity adder) {
        if (this.isDefeated()) {
            return false;
        }
        return super.addEffect(effectInst, adder);
    }

    public void forceAddEffect(MobEffectInstance p_147216_, @Nullable Entity adder) {
        if (this.isDefeated()) {
            return;
        }
        super.forceAddEffect(p_147216_, adder);
    }

    public boolean canBeAffected(MobEffectInstance effectIn) {
        if (this.isDefeated()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.isPotionApplicable(this, effectIn);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return super.canBeAffected(effectIn);
    }

    public boolean canHaveALeashAttachedToIt() {
        return false;
    }

    public void setLeashedTo(Entity p_21464_, boolean p_21465_) {
    }

    public boolean isLeashed() {
        return false;
    }

    @Nullable
    public Entity getLeashHolder() {
        return null;
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean removeWhenFarAway(double distance) {
        return false;
    }

    public void checkDespawn() {
        this.noActionTime = 0;
    }

    public void setUUID(UUID uniqueIdIn) {
        UUID oldUniqueId = this.getUUID();
        if (uniqueIdIn.equals(oldUniqueId)) {
            return;
        }
        super.setUUID(uniqueIdIn);
        if (!this.isAddedToWorld()) {
            return;
        }
        if (this.level() != null && !this.level().isClientSide) {
            DogLocationStorage.get(this.level()).remove(oldUniqueId);
            DogLocationStorage.get(this.level()).getOrCreateData(this).update(this);
        }
    }

    public void tame(Player player) {
        super.tame(player);
        this.setOwnersName(player.getName());
    }

    public void setTame(boolean tame, boolean update_tame_props) {
        super.setTame(tame, update_tame_props);
        if (tame) {
            float maxHealth = this.getDogLevel().getMaxHealth();
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)maxHealth);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
        }
        this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(4.0);
    }

    public void maxHealth() {
        this.setHealth(this.getMaxHealth());
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        boolean isChangingOwner;
        UUID currentUUID = this.getOwnerUUID();
        boolean bl = isChangingOwner = currentUUID != null && ObjectUtils.notEqual((Object)currentUUID, (Object)uuid);
        if (isChangingOwner && !this.authorizedChangingOwner) {
            return;
        }
        super.setOwnerUUID(uuid);
        if (uuid == null) {
            this.setOwnersName((Component)null);
        }
    }

    public void setCustomName(@Nullable Component name) {
        if (!this.authorizedChangingName) {
            return;
        }
        name = this.checkDogNameLength(name);
        name = this.checkDogValidName(name);
        super.setCustomName(name);
    }

    private Component checkDogNameLength(Component name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        if (str.length() <= MAX_NAME_LEN) {
            return name;
        }
        String new_str = str.substring(0, MAX_NAME_LEN);
        MutableComponent new_name = Component.literal((String)new_str).withStyle(name.getStyle());
        return new_name;
    }

    private Component checkDogValidName(Component name) {
        if (name == null) {
            return null;
        }
        String str = name.getString();
        String newStr = DogUtil.checkAndCorrectInvalidName(str);
        if (newStr == str) {
            return name;
        }
        return Component.literal((String)newStr).withStyle(name.getStyle());
    }

    public void setDogCustomName(@Nullable Component name) {
        this.authorizedChangingName = true;
        this.setCustomName(name);
        this.authorizedChangingName = false;
    }

    public boolean skipAttackInteraction(Entity entityIn) {
        boolean allPlayerCannotAttackDog = (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.SERVER.ALL_PLAYER_CANNOT_ATTACK_DOG);
        if (allPlayerCannotAttackDog && entityIn instanceof Player) {
            return true;
        }
        if (!this.canOwnerAttack() && DogAllyCheck.isAlliedToDog(this, entityIn)) {
            return true;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.shouldSkipAttackFrom(this, entityIn);
            if (result.shouldSwing()) {
                return true;
            }
            if (result != InteractionResult.FAIL) continue;
            return false;
        }
        return false;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)DoggyItems.DOGGY_CHARM.get());
    }

    public boolean isFood(ItemStack stack) {
        return false;
    }

    public boolean canMate(Animal otherAnimal) {
        if (this.isDefeated()) {
            return false;
        }
        if (otherAnimal == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(otherAnimal instanceof Dog)) {
            return false;
        }
        Dog entitydog = (Dog)otherAnimal;
        if (!entitydog.isTame()) {
            return false;
        }
        if (entitydog.isInSittingPose()) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER)).booleanValue() && !this.getGender().canMateWith(entitydog.getGender())) {
            return false;
        }
        return !entitydog.isDefeated() && this.isInLove() && entitydog.isInLove();
    }

    public AgeableMob getBreedOffspring(ServerLevel worldIn, AgeableMob partner) {
        Dog child = (Dog)DoggyEntityTypes.DOG.get().create((Level)worldIn);
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            child.setOwnerUUID(uuid);
            child.setTame(true, true);
            child.maxHealth();
        }
        if (partner instanceof Dog && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PUPS_GET_PARENT_LEVELS)).booleanValue()) {
            child.setLevel(this.getDogLevel().combine(((Dog)partner).getDogLevel()));
        }
        return child;
    }

    public void spawnChildFromBreeding(ServerLevel level, Animal otherDog) {
        if (!this.checkOwnerTrainLimitBeforeBreed()) {
            this.setAge(6000);
            otherDog.setAge(6000);
            this.resetLove();
            otherDog.resetLove();
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
            return;
        }
        super.spawnChildFromBreeding(level, otherDog);
    }

    private boolean checkOwnerTrainLimitBeforeBreed() {
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        if (!(owner instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer sP = (ServerPlayer)owner;
        return EventHandler.isWithinTrainWolfLimit((Player)sP);
    }

    public boolean shouldShowName() {
        return this.hasCustomName() || super.shouldShowName();
    }

    public float getScale() {
        if (this.isBaby()) {
            return 0.5f;
        }
        return this.getDogSize().getScale();
    }

    public float getAgeScale() {
        return 1.0f;
    }

    public void authorizeChangeDimension() {
        this.changeDimensionAuthorized = true;
    }

    public Entity changeDimension(DimensionTransition tansition) {
        if (this.checkBlockPortal()) {
            return null;
        }
        this.DTN_dogChangingDim = true;
        Entity transportedEntity = super.changeDimension(tansition);
        this.DTN_dogChangingDim = false;
        if (transportedEntity instanceof Dog) {
            Dog dog = (Dog)transportedEntity;
            DogLocationStorage.get(this.level()).getOrCreateData(this).update(dog);
            if (dog.getMode().canWander()) {
                dog.setMode(DogMode.DOCILE);
            }
        }
        return transportedEntity;
    }

    private boolean checkBlockPortal() {
        boolean default_block;
        boolean defeated_bypass;
        boolean changeDimensionAuth0 = this.changeDimensionAuthorized;
        this.changeDimensionAuthorized = false;
        boolean bl = defeated_bypass = this.isDefeated() && (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.INJURED_DOG_BLOCK_PORTAL) == false;
        if (defeated_bypass) {
            return false;
        }
        boolean bl2 = default_block = !changeDimensionAuth0 && (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.ALL_DOG_BLOCK_PORTAL) != false;
        return default_block;
    }

    public void onRemovedFromWorld() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server_level = (ServerLevel)level;
        DogLocationData data = DogLocationStorage.get((Level)server_level).getData(this);
        if (data == null) {
            return;
        }
        if (this.isAlive()) {
            data.update(this);
            this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.UPDATED;
        }
        data.invalidateCachedDog();
    }

    public void onAddedToWorld() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isAlive()) {
                DogLocationStorage storage = DogLocationStorage.get((Level)serverLevel);
                DogLocationData data = storage.getOrCreateData(this);
                if (data != null) {
                    data.update(this);
                }
                storage.getOnlineDogsManager().onDogGoOnline(this);
                DogDuplicationDetection.afterDogJoinLevel(this, data);
            }
        }
    }

    public void onDogStartTracking() {
        this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.NONE;
    }

    public void onDogStopTracking() {
    }

    public void remove(Entity.RemovalReason removalReason) {
        if (this.level() != null && !this.level().isClientSide) {
            boolean remove_trusted;
            boolean bl = remove_trusted = (Boolean)ConfigHandler.SERVER.TRUST_THIRD_PARTY_STORAGE.get() != false && removalReason == Entity.RemovalReason.DISCARDED;
            if (!remove_trusted && removalReason.shouldDestroy()) {
                DogLocationStorage.get(this.level()).remove(this);
                if (this.getOwnerUUID() != null) {
                    DogRespawnStorage.get(this.level()).putData(this);
                    this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.UNLOADED_TO_RESPAWN;
                } else {
                    this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.REMOVED;
                }
            }
            if (remove_trusted) {
                DogLocationStorage.get(this.level()).remove(this);
                this.locationUpdatedUponRemove = OnlineDogLocationManager.RemoveState.REMOVE_TRUSTED;
            }
        }
        super.remove(removalReason);
        for (IDogAlteration x : this.alterations) {
            x.remove(this);
        }
    }

    public boolean shouldBeSaved() {
        if (this.doDogRidingPlayerSave()) {
            return true;
        }
        return super.shouldBeSaved();
    }

    public boolean save(CompoundTag compound) {
        if (this.doDogRidingPlayerSave()) {
            return this.saveAsPassenger(compound);
        }
        return super.save(compound);
    }

    private boolean doDogRidingPlayerSave() {
        if (!((Boolean)ConfigHandler.SERVER.SAVE_DOG_RIDING_PLAYER.get()).booleanValue()) {
            return false;
        }
        Entity.RemovalReason remove_reason = this.getRemovalReason();
        if (remove_reason != null && !remove_reason.shouldSave()) {
            return false;
        }
        if (!this.isPassenger()) {
            return false;
        }
        return this.getVehicle() instanceof Player;
    }

    public void setPosRaw(double x, double y, double z) {
        int y_cap;
        boolean max_build_height_check;
        Vec3 current_pos = this.position();
        boolean bl = max_build_height_check = y != current_pos.y && ConfigHandler.ServerConfig.getConfigOrDefault(ConfigHandler.SERVER.DOG_MAX_BUILD_Y_CAP, false) != false;
        if (max_build_height_check && y > (double)(y_cap = this.level().getMaxBuildHeight())) {
            y = y_cap;
        }
        this.mayDogLoadChunkBeforeMoveTo(x, y, z);
        super.setPosRaw(x, y, z);
    }

    private void mayDogLoadChunkBeforeMoveTo(double x, double y, double z) {
        boolean changed_chunk;
        boolean changed_xz;
        Vec3 current_pos = this.position();
        boolean bl = changed_xz = current_pos.x != x || current_pos.z != z;
        if (!changed_xz) {
            return;
        }
        ChunkPos current_chunk_pos = this.chunkPosition();
        boolean bl2 = changed_chunk = SectionPos.blockToSectionCoord((double)x) != current_chunk_pos.x || SectionPos.blockToSectionCoord((double)z) != current_chunk_pos.z;
        if (!changed_chunk) {
            return;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOG_LOAD_CHUNK_BEFORE_MOVE.get()).booleanValue()) {
            return;
        }
        if (!this.dogTrackingTracker.isTracking()) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        if (this.isRemoved()) {
            return;
        }
        this.level().getChunk(SectionPos.blockToSectionCoord((double)x), SectionPos.blockToSectionCoord((double)z));
    }

    public void lerpTo(double x, double y, double z, float yrot, float xrot, int step) {
        if (this.level().isClientSide && FixClientTeleportDesync_1_21.onDogLerpTo(this)) {
            this.setPos(x, y, z);
            this.setRot(yrot, xrot);
            this.lerpSteps = 0;
            return;
        }
        super.lerpTo(x, y, z, yrot, xrot, step);
    }

    private void startShaking() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingAndBroadcast(boolean shakeFire) {
        if (this.isShaking) {
            return;
        }
        if (this.level().isClientSide) {
            return;
        }
        if (shakeFire) {
            this.startShakingLava();
            ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_LAVA);
            return;
        }
        this.startShaking();
        ParticlePackets.DogShakingPacket.sendDogShakingPacket(this, DogShakingData.State.SHAKE_WATER);
    }

    private void finishShaking() {
        this.isShaking = false;
        this.shakeFire = false;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public void startShakingLava() {
        if (this.isShaking) {
            return;
        }
        this.isShaking = true;
        this.shakeFire = true;
        this.timeWolfIsShaking = 0.0f;
        this.prevTimeWolfIsShaking = 0.0f;
    }

    public boolean isShakingLava() {
        return this.isShaking && this.shakeFire;
    }

    public void resetBeggingRotation() {
        this.headRotationCourse = 0.0f;
        this.headRotationCourseOld = 0.0f;
    }

    public void die(DamageSource cause) {
        if (this.checkAndHandleIncapacitated(cause)) {
            return;
        }
        this.wetSource = WetSource.NONE;
        this.finishShaking();
        this.alterations.forEach(alter -> alter.onDeath(this, cause));
        this.dogDeathCause = Optional.empty();
        if (((Boolean)ConfigHandler.SERVER.DOG_RESPAWN_INCAPACITATED_WHEN_KILLED.get()).booleanValue() && !cause.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.dogDeathCause = Optional.ofNullable(cause);
            this.setDogIncapValue(this.getInitalDogIncapVal(cause));
        }
        this.dogProccessAndBroadcastDieVanilla(cause);
    }

    public Optional<DamageSource> getDogDeathCause() {
        return this.dogDeathCause;
    }

    private void dogProccessAndBroadcastDieVanilla(DamageSource cause) {
        if (this.isRemoved()) {
            return;
        }
        if (this.dead) {
            return;
        }
        Component deathMessage = this.getCombatTracker().getDeathMessage();
        this.dead = true;
        this.getCombatTracker().recheckStatus();
        Level level = this.level();
        Entity entity = cause.getEntity();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (entity == null || entity.killedEntity(serverlevel, (LivingEntity)this)) {
                this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                this.dropAllDeathLoot(serverlevel, cause);
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
        }
        LivingEntity owner = this.getOwner();
        if (!this.level().isClientSide && this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && owner instanceof ServerPlayer) {
            owner.sendSystemMessage(deathMessage);
        }
    }

    private boolean checkAndHandleIncapacitated(DamageSource cause) {
        if (this.level().isClientSide) {
            return false;
        }
        if (!((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.IMMORTAL_DOGS)).booleanValue()) {
            return false;
        }
        if (cause.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        if (this.getOwnerUUID() == null) {
            return false;
        }
        this.handleIncapacitated(cause);
        return true;
    }

    private void handleIncapacitated(DamageSource source) {
        this.setHealth(1.0f);
        this.setMode(DogMode.INJURED);
        this.setDogHunger(0.0f);
        this.removeAllEffects();
        this.setDogIncapValue(this.getInitalDogIncapVal(source));
        this.updateControlFlags();
        this.dogAi.forceStopAllGoal();
        this.getNavigation().stop();
        this.unRide();
        this.createAndSetIncapSyncState(source);
        if (this.isInWater() || !this.fireImmune() && this.isInLava()) {
            this.triggerAnimationAction(new DogDrownAction(this));
        } else {
            this.setAnim(this.incapacitatedMananger.getAnim());
        }
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            this.sendIncapacitatedMsg(owner, source);
        }
        this.incapacitatedMananger.setIncapMsg(source.getLocalizedDeathMessage((LivingEntity)this).getString());
        this.wetSource = WetSource.NONE;
        this.finishShaking();
    }

    public int getInitalDogIncapVal(DamageSource source) {
        Difficulty difficulty = this.level().getDifficulty();
        if (difficulty == Difficulty.PEACEFUL) {
            return this.getDefaultInitIncapVal() / 2;
        }
        if (difficulty == Difficulty.EASY) {
            return this.getDefaultInitIncapVal();
        }
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return this.getDefaultInitIncapVal();
        }
        float fatal_damage = this.lastHurt;
        if (fatal_damage <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        fatal_damage = this.getDamageAfterArmorAbsorb(source, fatal_damage);
        if ((fatal_damage = this.getDamageAfterMagicAbsorb(source, fatal_damage)) <= 0.0f) {
            return this.getDefaultInitIncapVal();
        }
        int multipler = difficulty == Difficulty.HARD ? 2 : 1;
        int additional_incap = Mth.floor((float)((float)multipler * fatal_damage));
        return this.getDefaultInitIncapVal() + additional_incap;
    }

    private void sendIncapacitatedMsg(LivingEntity owner, DamageSource source) {
        MutableComponent msg = source.getLocalizedDeathMessage((LivingEntity)this).copy();
        String genderStr = Component.translatable((String)this.getGender().getUnlocalisedSubject()).getString();
        String msg005 = ". " + genderStr.substring(0, 1).toUpperCase() + genderStr.substring(1) + " ";
        MutableComponent msg01 = Component.translatable((String)"dog.mode.incapacitated.msg.partition1", (Object[])new Object[]{Component.literal((String)msg005), Component.translatable((String)DogMode.INJURED.getUnlocalisedName()).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(14025732))});
        msg.append((Component)msg01);
        owner.sendSystemMessage((Component)msg);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState createIncapSyncState(DamageSource source) {
        DogIncapacitatedMananger.DefeatedType type = source.is(DamageTypeTags.IS_FIRE) || this.isOnFire() && !this.fireImmune() ? DogIncapacitatedMananger.DefeatedType.BURN : (source.is(DamageTypes.MAGIC) ? DogIncapacitatedMananger.DefeatedType.POISON : (source.is(DamageTypes.DROWN) ? DogIncapacitatedMananger.DefeatedType.DROWN : (source.is(DamageTypes.STARVE) ? DogIncapacitatedMananger.DefeatedType.STARVE : DogIncapacitatedMananger.DefeatedType.BLOOD)));
        int poseId = this.getRandom().nextInt(2);
        return new DogIncapacitatedMananger.IncapacitatedSyncState(type, DogIncapacitatedMananger.BandaidState.NONE, poseId);
    }

    private void createAndSetIncapSyncState(DamageSource source) {
        DogIncapacitatedMananger.IncapacitatedSyncState state = this.createIncapSyncState(source);
        this.setIncapSyncState(state);
    }

    public double getFluidJumpThreshold() {
        float defeated_threshold = this.isInLava() ? 0.9f : 1.0f;
        return this.isDefeated() ? (double)defeated_threshold : super.getFluidJumpThreshold();
    }

    public void jumpInFluid(FluidType type) {
        if (this.getNavigation().canFloat()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)0.04f, 0.0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.3, 0.0));
        }
    }

    public void dropEquipment() {
        this.alterations.forEach(alter -> alter.dropInventory(this));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addDTNAdditionalSavedData(compound);
    }

    public void addDTNAdditionalSavedData(CompoundTag compound) {
        Dimension2BlockPosMap bowlsData;
        Dimension2BlockPosMap bedsData;
        ListTag talentList = new ListTag();
        List<TalentInstance> talents = this.getTalentMap();
        for (int i = 0; i < talents.size(); ++i) {
            CompoundTag talentTag = new CompoundTag();
            talents.get(i).writeInstance(this, talentTag);
            talentList.add((Object)talentTag);
        }
        compound.put("talents", (Tag)talentList);
        ListTag accessoryList = new ListTag();
        List<AccessoryInstance> accessories = this.getAccessories();
        for (int i = 0; i < accessories.size(); ++i) {
            CompoundTag accessoryTag = new CompoundTag();
            accessories.get(i).writeInstance(accessoryTag);
            accessoryList.add((Object)accessoryTag);
        }
        compound.put("accessories", (Tag)accessoryList);
        ListTag artifactsListTag = new ListTag();
        List<DoggyArtifactItem> artifacts = this.getArtifactsList();
        for (DoggyArtifactItem x : artifacts) {
            CompoundTag artifactTag = DoggyArtifactItem.writeCompound(x);
            if (artifactTag == null) continue;
            artifactsListTag.add((Object)artifactTag);
        }
        compound.put("doggy_artifacts", (Tag)artifactsListTag);
        compound.putString("classicalVariant", DogVariantUtil.toSaveString(this.dogVariant(), () -> Optional.ofNullable(this.missingDogVariant)));
        compound.putString("mode", this.getMode().getSaveName());
        compound.putString("dogGender", this.getGender().getSaveName());
        compound.putFloat("dogHunger", this.getDogHunger());
        compound.putInt("dogIncapacitatedValue", this.getDogIncapValue());
        this.getOwnersName().ifPresent(comp -> NBTUtil.putTextComponent(compound, "lastKnownOwnerName", comp));
        this.getSkinData().save(compound);
        compound.putBoolean("willObey", this.willObeyOthers());
        compound.putBoolean("friendlyFire", this.canOwnerAttack());
        compound.putBoolean("regardTeamPlayers", this.regardTeamPlayers());
        compound.putBoolean("forceSit", this.forceSit());
        compound.putBoolean("dogAutoMount", this.dogAutoMount());
        compound.putByte("lowHealthStrategy", this.getLowHealthStrategy().getId());
        compound.putByte("combatReturnStrategy", this.getCombatReturnStrategy().getId());
        compound.putBoolean("crossOriginTp", this.crossOriginTp());
        compound.putBoolean("patrolTargetLock", this.patrolTargetLock());
        compound.putBoolean("hideDogArmor", this.hideArmor());
        compound.putBoolean("dogOnDuty", this.dogOnDuty());
        compound.putInt("dogSize", this.getDogSize().getId());
        compound.putInt("level_normal", this.getDogLevel().getLevel(DogLevel.Type.NORMAL));
        compound.putInt("level_kami", this.getDogLevel().getLevel(DogLevel.Type.KAMI));
        NBTUtil.writeItemStack((HolderLookup.Provider)this.registryAccess(), compound, "fetchItem", this.getBoneVariant());
        ItemStack wolf_armor = this.wolfArmor();
        if (wolf_armor != null && !wolf_armor.isEmpty()) {
            NBTUtil.writeItemStack((HolderLookup.Provider)this.registryAccess(), compound, "wolfArmorItem", wolf_armor);
        }
        if (!(bedsData = (Dimension2BlockPosMap)this.entityData.get(DOG_BED_LOCATION)).isEmpty()) {
            ListTag bedsList = new ListTag();
            for (Map.Entry<ResourceKey<Level>, BlockPos> entry : bedsData.entrySet()) {
                CompoundTag compoundTag = new CompoundTag();
                NBTUtil.putResourceLocation(compoundTag, "dim", entry.getKey().location());
                NBTUtil.putBlockPos(compoundTag, "pos", entry.getValue());
                bedsList.add((Object)compoundTag);
            }
            compound.put("beds", (Tag)bedsList);
        }
        if (!(bowlsData = (Dimension2BlockPosMap)this.entityData.get(DOG_BOWL_LOCATION)).isEmpty()) {
            ListTag bowlsList = new ListTag();
            for (Map.Entry<ResourceKey<Level>, BlockPos> entry : bowlsData.entrySet()) {
                CompoundTag bowlsNBT = new CompoundTag();
                NBTUtil.putResourceLocation(bowlsNBT, "dim", entry.getKey().location());
                NBTUtil.putBlockPos(bowlsNBT, "pos", entry.getValue());
                bowlsList.add((Object)bowlsNBT);
            }
            compound.put("bowls", (Tag)bowlsList);
        }
        this.statsTracker.writeAdditional(compound);
        this.dogOwnerDistanceManager.save(compound);
        this.pettingManager.save(compound);
        this.animationManager.save(compound);
        this.alterations.forEach(alter -> alter.onWrite(this, compound));
        this.dogGroupsManager.save(compound);
        if (this.isDefeated()) {
            this.incapacitatedMananger.save(compound);
        }
        if (this.getMode().canWander() && this.hasRestriction()) {
            BlockPos restrict = this.getRestrictCenter();
            int n = (int)this.getRestrictRadius();
            if (restrict != null) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.putInt("wanderX", restrict.getX());
                compoundTag.putInt("wanderY", restrict.getY());
                compoundTag.putInt("wanderZ", restrict.getZ());
                compoundTag.putInt("wanderR", n);
                compound.put("dogWanderCenter", (Tag)compoundTag);
            }
        }
        if (!this.level().isClientSide && !this.DTN_dogChangingDim) {
            this.dogDuplicateDetection.save(compound);
        }
    }

    public void addNonDTNAdditionalData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
    }

    public void load(CompoundTag compound) {
        this.authorizedChangingOwner = true;
        this.authorizedChangingName = true;
        super.load(compound);
        this.authorizedChangingOwner = false;
        this.authorizedChangingName = false;
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ArrayList<TalentInstance> newTlInstLs = new ArrayList<TalentInstance>();
        this.tryReadAllTalents(compound, newTlInstLs);
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.talents().addAll(newTlInstLs);
        this.dogSyncedDataManager.setTalentsDirty();
        ArrayList<AccessoryInstance> newAccInstLs = new ArrayList<AccessoryInstance>();
        this.tryReadAllAccessories(compound, newAccInstLs);
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.accessories().addAll(newAccInstLs);
        this.dogSyncedDataManager.setAccessoriesDirty();
        ArrayList<DoggyArtifactItem> artifactsList = new ArrayList<DoggyArtifactItem>(3);
        try {
            if (compound.contains("doggy_artifacts", 9)) {
                ListTag artifactsListTag = compound.getList("doggy_artifacts", 10);
                for (int i = 0; i < artifactsListTag.size(); ++i) {
                    DoggyArtifactItem artifactItem = DoggyArtifactItem.readCompound(artifactsListTag.getCompound(i));
                    if (artifactItem == null) continue;
                    artifactsList.add(artifactItem);
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load artifacts : " + String.valueOf(e));
        }
        this.entityData.set(ARTIFACTS, artifactsList);
        try {
            this.spendablePoints.markForRefresh();
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to init alteration: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.setDogVariant(DogVariantUtil.fromSaveString(compound.getString("classicalVariant"), id -> {
                this.missingDogVariant = id;
            }));
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load Dog Variant: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            DogSkinData dogSkinData = DogSkinData.readFromTag(compound);
            this.setDogSkinData(dogSkinData);
            if (compound.contains("wolfArmorItem", 10)) {
                this.setWolfArmor(NBTUtil.readItemStack((HolderLookup.Provider)this.registryAccess(), compound, "wolfArmorItem"));
            }
            if (compound.contains("fetchItem", 10)) {
                this.setBoneVariant(NBTUtil.readItemStack((HolderLookup.Provider)this.registryAccess(), compound, "fetchItem"));
            }
        }
        catch (Exception dogSkinData) {
            // empty catch block
        }
        try {
            this.setGender(DogGender.bySaveName(compound.getString("dogGender")));
            if (compound.contains("mode", 8)) {
                this.setMode(DogMode.bySaveName(compound.getString("mode")));
            }
            this.setHungerDirectly(compound.getFloat("dogHunger"));
            this.setDogIncapValue(compound.getInt("dogIncapacitatedValue"));
            this.setOwnersName(NBTUtil.getTextComponent(compound, "lastKnownOwnerName"));
            this.setWillObeyOthers(compound.getBoolean("willObey"));
            this.setCanPlayersAttack(compound.getBoolean("friendlyFire"));
            this.setRegardTeamPlayers(compound.getBoolean("regardTeamPlayers"));
            this.setDogAutoMount(compound.getBoolean("dogAutoMount"));
            this.setForceSit(compound.getBoolean("forceSit"));
            this.setCrossOriginTp(compound.getBoolean("crossOriginTp"));
            this.setPatrolTargetLock(compound.getBoolean("patrolTargetLock"));
            this.setHideArmor(compound.getBoolean("hideDogArmor"));
            this.setDogOnDuty(compound.getBoolean("dogOnDuty"));
            byte low_health_strategy_id = compound.getByte("lowHealthStrategy");
            this.setLowHealthStrategy(LowHealthStrategy.fromId(low_health_strategy_id));
            byte combat_return_strategy_id = compound.getByte("combatReturnStrategy");
            this.setCombatReturnStrategy(CombatReturnStrategy.fromId(combat_return_strategy_id));
            if (compound.contains("dogSize", 99)) {
                this.setDogSize(DogSize.fromId(compound.getInt("dogSize")));
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            int level_normal = 0;
            int level_kami = 0;
            if (compound.contains("level_normal", 99)) {
                level_normal = compound.getInt("level_normal");
            }
            if (compound.contains("level_kami", 99)) {
                level_kami = compound.getInt("level_kami");
            } else if (compound.contains("level_dire", 99)) {
                level_kami = compound.getInt("level_dire");
            }
            this.entityData.set(DOG_LEVEL, (Object)new DogLevel(level_normal, level_kami));
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load levels: " + e.getMessage());
            e.printStackTrace();
        }
        Dimension2BlockPosMap bedsData = new Dimension2BlockPosMap();
        try {
            if (compound.contains("beds", 9)) {
                ListTag bedsList = compound.getList("beds", 10);
                for (int i = 0; i < bedsList.size(); ++i) {
                    CompoundTag bedNBT = bedsList.getCompound(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bedNBT, "dim");
                    ResourceKey type = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bedNBT, "pos");
                    if (!pos.isPresent()) continue;
                    bedsData.put((ResourceKey<Level>)type, pos.get());
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load beds: " + e.getMessage());
            e.printStackTrace();
        }
        this.entityData.set(DOG_BED_LOCATION, (Object)bedsData);
        Dimension2BlockPosMap bowlsData = new Dimension2BlockPosMap();
        try {
            if (compound.contains("bowls", 9)) {
                ListTag bowlsList = compound.getList("bowls", 10);
                for (int i = 0; i < bowlsList.size(); ++i) {
                    CompoundTag bowlsNBT = bowlsList.getCompound(i);
                    ResourceLocation loc = NBTUtil.getResourceLocation(bowlsNBT, "dim");
                    ResourceKey type = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc);
                    Optional<BlockPos> pos = NBTUtil.getBlockPos(bowlsNBT, "pos");
                    if (!pos.isPresent()) continue;
                    bowlsData.put((ResourceKey<Level>)type, pos.get());
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load bowls: " + e.getMessage());
            e.printStackTrace();
        }
        this.entityData.set(DOG_BOWL_LOCATION, (Object)bowlsData);
        try {
            this.statsTracker.readAdditional(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load stats tracker: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.dogOwnerDistanceManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load owner distance manager: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.pettingManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load dog petting manager: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            this.animationManager.load(compound);
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load dog animation manager: " + e.getMessage());
            e.printStackTrace();
        }
        this.alterations.forEach(alter -> {
            try {
                alter.onRead(this, compound);
            }
            catch (Exception e) {
                DoggyTalentsNext.LOGGER.error("Failed to load alteration: " + e.getMessage());
                e.printStackTrace();
            }
        });
        try {
            this.dogGroupsManager.load(compound);
            if (this.isDefeated()) {
                this.incapacitatedMananger.load(compound);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getMode().canWander() && compound.contains("dogWanderCenter", 10)) {
                CompoundTag wanderTg = compound.getCompound("dogWanderCenter");
                BlockPos restrictPos = new BlockPos(wanderTg.getInt("wanderX"), wanderTg.getInt("wanderY"), wanderTg.getInt("wanderZ"));
                int restrict_r = wanderTg.getInt("wanderR");
                restrict_r = Math.max(0, restrict_r);
                this.restrictTo(restrictPos, restrict_r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.level().isClientSide) {
            try {
                this.dogDuplicateDetection.load(compound, new_owner_uuid -> {
                    boolean prevAuthorized = this.authorizedChangingOwner;
                    this.authorizedChangingOwner = true;
                    this.setOwnerUUID((UUID)new_owner_uuid);
                    this.authorizedChangingOwner = prevAuthorized;
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.level().isClientSide) {
            try {
                this.setAnim(DogAnimation.NONE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void tryReadAllTalents(CompoundTag compound, ArrayList<TalentInstance> target) {
        try {
            if (compound.contains("talents", 9)) {
                ListTag talentList = compound.getList("talents", 10);
                for (int i = 0; i < talentList.size(); ++i) {
                    try {
                        TalentInstance.readInstance(this, talentList.getCompound(i)).ifPresent(target::add);
                        continue;
                    }
                    catch (Exception e) {
                        DoggyTalentsNext.LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load talents : " + String.valueOf(e));
        }
    }

    private void tryReadAllAccessories(CompoundTag compound, ArrayList<AccessoryInstance> target) {
        try {
            if (compound.contains("accessories", 9)) {
                ListTag accessoryList = compound.getList("accessories", 10);
                for (int i = 0; i < accessoryList.size(); ++i) {
                    try {
                        AccessoryInstance.readInstance(accessoryList.getCompound(i)).ifPresent(target::add);
                        continue;
                    }
                    catch (Exception e) {
                        DoggyTalentsNext.LOGGER.error(e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            DoggyTalentsNext.LOGGER.error("Failed to load accessories : " + String.valueOf(e));
        }
    }

    public DogDuplicationDetection getDogDuplicationDetection() {
        return this.dogDuplicateDetection;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DOG_VARIANT.equals(key)) {
            this.refreshAlterations();
        }
        if (ARTIFACTS.equals(key)) {
            this.refreshAlterations();
        }
        if (DOG_LEVEL.equals(key)) {
            this.spendablePoints.markForRefresh();
            float h = this.getDogLevel().getMaxHealth();
            if (h != this.getMaxHealth()) {
                this.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)h);
            }
        }
        if (DOG_SIZE.equals(key)) {
            this.refreshDimensions();
        }
        if (this.level().isClientSide && CUSTOM_SKIN.equals(key)) {
            this.clientSkin = DogSkinHolder.pendingResolve();
        }
        if (ANIMATION.equals(key)) {
            this.animationManager.onAnimationChange(this.getAnim());
        }
        if (ANIM_SYNC_TIME.equals(key)) {
            this.animationManager.onSyncTimeUpdated();
        }
        if (HUNGER_INT.equals(key)) {
            this.hungerManager.onHungerUpdated(this.getDogHunger());
        }
        if (!this.level().isClientSide && MODE.equals(key)) {
            DogMode mode = this.getMode();
            this.incapacitatedMananger.onModeUpdate(mode);
            if (mode == DogMode.INJURED) {
                this.hungerManager.onBeingIncapacitated();
            }
            this.updateWanderState(mode);
        }
        if (DOG_PETTING_STATE.equals(key) && this.level().isClientSide) {
            DTNClientPettingManager.get().onPettingUpdate(this, this.getPettingState());
        }
        if (DOG_ANIM_DEBUG_STATE.equals(key)) {
            DogAnimationManager.DogAnimDebugState debug_state = this.getDogAnimDebugState();
            if (!debug_state.isNone() && !this.level().isClientSide) {
                this.dogAi.forceStopAllGoal();
            }
            this.animationManager.onDebugUpdate(debug_state);
        }
        if (DOG_SLEEP_ON_STATE.equals(key)) {
            DogSleepOnManager.onDogSleepOnDataUpdated(this, this.getSleepOnState());
        }
    }

    public void onDogSyncedDataUpdated(boolean talents, boolean accessories) {
        if (talents || accessories) {
            this.refreshAlterations();
            this.spendablePoints.markForRefresh();
        }
        if (talents && this.level().isClientSide) {
            ClientEventHandler.onDogTalentUpdated(this);
        }
        if (accessories && this.level().isClientSide) {
            this.clientAccessories = new ArrayList<AccessoryInstance>(this.getAccessories());
            this.clientAccessories.sort(AccessoryInstance.RENDER_SORTER);
        }
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.dogSyncedDataManager.onStartBeingSeenBy(player);
    }

    private void updateWanderState(DogMode mode) {
        BlockPos bowlPos;
        if (!mode.canWander()) {
            this.clearRestriction();
            return;
        }
        BlockPos restrictPos = this.blockPosition();
        int restrictRadius = 12;
        Optional<BlockPos> bowlPosOptional = this.getBowlPos();
        if (bowlPosOptional.isPresent() && (bowlPos = bowlPosOptional.get()).distSqr((Vec3i)this.blockPosition()) < 64.0) {
            restrictRadius = 5;
            restrictPos = bowlPos;
        }
        this.restrictTo(restrictPos, restrictRadius);
    }

    private boolean invalidateWanderCenter(int distanceSqr) {
        if (!this.hasRestriction()) {
            return false;
        }
        BlockPos restrict_pos = this.getRestrictCenter();
        if (restrict_pos == null) {
            return false;
        }
        if (restrict_pos.distSqr((Vec3i)this.blockPosition()) >= (double)distanceSqr) {
            this.clearRestriction();
            return true;
        }
        return false;
    }

    public void refreshAlterations() {
        for (IDogAlteration iDogAlteration : this.alterations) {
            iDogAlteration.remove(this);
        }
        this.alterations.clear();
        this.foodHandlers.clear();
        this.alterationProps = new DogAlterationProps();
        this.dogRangedAttackManager = IDogRangedAttackManager.NONE;
        DogVariant dogVariant = this.dogVariant();
        if (dogVariant instanceof IDogAlteration) {
            IDogAlteration alter_var = (IDogAlteration)((Object)dogVariant);
            this.alterations.add(alter_var);
        }
        for (AccessoryInstance accessoryInstance : this.getAccessories()) {
            if (accessoryInstance instanceof IDogAlteration) {
                this.alterations.add((IDogAlteration)((Object)accessoryInstance));
            }
            if (!(accessoryInstance instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)accessoryInstance));
        }
        List<TalentInstance> talents = this.getTalentMap();
        this.alterations.addAll(talents);
        for (TalentInstance inst3 : talents) {
            if (!(inst3 instanceof IDogFoodHandler)) continue;
            this.foodHandlers.add((IDogFoodHandler)((Object)inst3));
        }
        List<DoggyArtifactItem> list = this.getArtifactsList();
        for (DoggyArtifactItem artifactItem : list) {
            DoggyArtifact artifact = artifactItem.createArtifact();
            this.alterations.add(artifact);
        }
        for (IDogAlteration inst4 : this.alterations) {
            inst4.props(this, this.alterationProps);
            inst4.init(this);
            if (this.dogRangedAttackManager != IDogRangedAttackManager.NONE || !inst4.getRangedAttack().isPresent()) continue;
            this.dogRangedAttackManager = inst4.getRangedAttack().get();
        }
        this.onPropsUpdated();
    }

    private void onPropsUpdated() {
        if (this.level().isClientSide) {
            return;
        }
        this.dogArmors.onPropsUpdated(this.alterationProps);
        if (!this.alterationProps.canUseTools()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
        this.dogSwimmingManager.onPropsUpdated(this.alterationProps);
    }

    public IDogRangedAttackManager getDogRangedAttack() {
        if (this.dogRangedAttackManager == null) {
            return IDogRangedAttackManager.NONE;
        }
        return this.dogRangedAttackManager;
    }

    @Override
    public boolean canInteract(LivingEntity livingEntity) {
        if (!this.isDoingFine()) {
            return false;
        }
        return this.willObeyOthers() || this.isOwnedBy(livingEntity);
    }

    @Override
    public List<AccessoryInstance> getAccessories() {
        return this.dogSyncedDataManager.accessories();
    }

    @Override
    public boolean addAccessory(@Nonnull AccessoryInstance accessoryInst) {
        List<AccessoryInstance> accessories = this.getAccessories();
        AccessoryType type = accessoryInst.getAccessory().getType();
        List filtered = accessories.stream().filter(inst -> type == inst.getAccessory().getType()).collect(Collectors.toList());
        if (filtered.size() >= type.numberToPutOn()) {
            return false;
        }
        this.dogSyncedDataManager.accessories().add(accessoryInst);
        this.dogSyncedDataManager.setAccessoriesDirty();
        return true;
    }

    @Override
    public List<AccessoryInstance> removeAccessories() {
        ArrayList<AccessoryInstance> removed = new ArrayList<AccessoryInstance>(this.getAccessories());
        this.dogSyncedDataManager.accessories().clear();
        this.dogSyncedDataManager.setAccessoriesDirty();
        return removed;
    }

    public Optional<AccessoryInstance> getAccessory(AccessoryType typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory().getType() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<AccessoryInstance> getAccessory(Accessory typeIn) {
        List<AccessoryInstance> accessories = this.getAccessories();
        for (AccessoryInstance inst : accessories) {
            if (inst.getAccessory() != typeIn) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    public Optional<Component> getOwnersName() {
        return (Optional)this.entityData.get(LAST_KNOWN_NAME);
    }

    public void setOwnersName(@Nullable Component comp) {
        this.setOwnersName(Optional.ofNullable(comp));
    }

    public void setOwnersName(Optional<Component> collar) {
        this.entityData.set(LAST_KNOWN_NAME, collar);
    }

    public DogVariant dogVariant() {
        return (DogVariant)this.entityData.get(DOG_VARIANT);
    }

    public void setDogVariant(DogVariant val) {
        this.entityData.set(DOG_VARIANT, (Object)val);
    }

    public DogGender getGender() {
        return (DogGender)((Object)this.entityData.get(GENDER));
    }

    public void setGender(DogGender collar) {
        this.entityData.set(GENDER, (Object)collar);
    }

    @Override
    public DogMode getMode() {
        return (DogMode)((Object)this.entityData.get(MODE));
    }

    public boolean isMode(DogMode ... modes) {
        DogMode mode = this.getMode();
        for (DogMode test : modes) {
            if (mode != test) continue;
            return true;
        }
        return false;
    }

    public void setMode(DogMode collar) {
        this.entityData.set(MODE, (Object)collar);
    }

    public Optional<BlockPos> getBedPos() {
        return this.getBedPos((ResourceKey<Level>)this.level().dimension());
    }

    public Optional<BlockPos> getBedPos(ResourceKey<Level> registryKey) {
        return ((Dimension2BlockPosMap)this.entityData.get(DOG_BED_LOCATION)).get(registryKey);
    }

    public void setBedPos(@Nullable BlockPos pos) {
        this.setBedPos((ResourceKey<Level>)this.level().dimension(), pos);
    }

    public void setBedPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBedPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBedPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.entityData.set(DOG_BED_LOCATION, (Object)((Dimension2BlockPosMap)this.entityData.get(DOG_BED_LOCATION)).copyAndSet(registryKey, pos));
    }

    public Optional<BlockPos> getBowlPos() {
        return this.getBowlPos((ResourceKey<Level>)this.level().dimension());
    }

    public Optional<BlockPos> getBowlPos(ResourceKey<Level> registryKey) {
        return ((Dimension2BlockPosMap)this.entityData.get(DOG_BOWL_LOCATION)).get(registryKey);
    }

    public void setBowlPos(@Nullable BlockPos pos) {
        this.setBowlPos((ResourceKey<Level>)this.level().dimension(), pos);
    }

    public void setBowlPos(ResourceKey<Level> registryKey, @Nullable BlockPos pos) {
        this.setBowlPos(registryKey, WorldUtil.toImmutable(pos));
    }

    public void setBowlPos(ResourceKey<Level> registryKey, Optional<BlockPos> pos) {
        this.entityData.set(DOG_BOWL_LOCATION, (Object)((Dimension2BlockPosMap)this.entityData.get(DOG_BOWL_LOCATION)).copyAndSet(registryKey, pos));
    }

    @Override
    public int getDefaultInitIncapVal() {
        return 64;
    }

    @Override
    public int getMaxDogIncapVal() {
        return 256;
    }

    @Override
    public int getDogIncapValue() {
        return (Integer)this.entityData.get(INCAP_VAL);
    }

    @Override
    public void setDogIncapValue(int val) {
        val = Mth.clamp((int)val, (int)0, (int)this.getMaxDogIncapVal());
        this.entityData.set(INCAP_VAL, (Object)val);
    }

    @Override
    public float getMaxHunger() {
        float maxHunger = 120.0f;
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.getMaxHunger(this, maxHunger);
            if (!result.getResult().shouldSwing()) continue;
            maxHunger = ((Float)result.getObject()).floatValue();
        }
        return maxHunger;
    }

    @Override
    public float getDogHunger() {
        return ((Float)this.entityData.get(HUNGER_INT)).floatValue();
    }

    @Override
    public void addHunger(float add) {
        this.hungerManager.addHunger(add);
    }

    @Override
    public void setDogHunger(float hunger) {
        float diff = hunger - this.getDogHunger();
        for (IDogAlteration alter : this.alterations) {
            InteractionResultHolder<Float> result = alter.setDogHunger(this, hunger, diff);
            if (!result.getResult().shouldSwing()) continue;
            hunger = ((Float)result.getObject()).floatValue();
            diff = hunger - this.getDogHunger();
        }
        this.setHungerDirectly(Mth.clamp((float)hunger, (float)0.0f, (float)this.getMaxHunger()));
    }

    private void setHungerDirectly(float hunger) {
        this.entityData.set(HUNGER_INT, (Object)Float.valueOf(hunger));
    }

    public void heal(float add) {
        if (add <= 0.0f) {
            return;
        }
        float add1 = EventHooks.onLivingHeal((LivingEntity)this, (float)add);
        add = Math.max(add1, add);
        float h = this.getHealth();
        if (h > 0.0f) {
            this.setHealth(h + add);
        }
    }

    public void setTarget(@Nullable LivingEntity target) {
        if (target == this) {
            target = null;
        }
        UUID owner_id = this.getOwnerUUID();
        if (target != null && owner_id != null && owner_id.equals(target.getUUID())) {
            target = null;
        }
        LivingEntity oldTarget = this.getTarget();
        super.setTarget(target);
        LivingEntity newTarget = this.getTarget();
        if (oldTarget != newTarget) {
            for (IDogAlteration alt : this.alterations) {
                alt.onDogSetTarget(this, newTarget, oldTarget);
            }
            this.dogAttackManager.onTargetChange();
        }
    }

    public boolean hasCustomSkin() {
        return !Strings.isNullOrEmpty((String)this.getSkinData().getHash());
    }

    public DogSkinData getSkinData() {
        return (DogSkinData)this.entityData.get(CUSTOM_SKIN);
    }

    public void setDogSkinData(DogSkinData data) {
        if (data == null) {
            data = DogSkinData.NULL;
        }
        this.entityData.set(CUSTOM_SKIN, (Object)data);
    }

    @Override
    public DogLevel getDogLevel() {
        return (DogLevel)this.entityData.get(DOG_LEVEL);
    }

    public void setLevel(DogLevel level) {
        this.entityData.set(DOG_LEVEL, (Object)level);
    }

    public DogIncapacitatedMananger.IncapacitatedSyncState getIncapSyncState() {
        return (DogIncapacitatedMananger.IncapacitatedSyncState)this.entityData.get(DOG_INCAP_SYNC_STATE);
    }

    public void setIncapSyncState(DogIncapacitatedMananger.IncapacitatedSyncState state) {
        this.entityData.set(DOG_INCAP_SYNC_STATE, (Object)state);
    }

    public DogPettingManager.DogPettingState getPettingState() {
        return (DogPettingManager.DogPettingState)this.entityData.get(DOG_PETTING_STATE);
    }

    public void setPettingState(DogPettingManager.DogPettingState state) {
        this.entityData.set(DOG_PETTING_STATE, (Object)state);
    }

    public DogSleepOnManager.DogSleepOnState getSleepOnState() {
        return (DogSleepOnManager.DogSleepOnState)this.entityData.get(DOG_SLEEP_ON_STATE);
    }

    public void setSleepOnState(DogSleepOnManager.DogSleepOnState state) {
        this.entityData.set(DOG_SLEEP_ON_STATE, (Object)state);
    }

    @Override
    public void increaseLevel(DogLevel.Type typeIn) {
        DogLevel copy = this.getDogLevel().copy();
        copy.incrementLevel(typeIn);
        this.setLevel(copy);
    }

    @Override
    public void setDogSize(DogSize size) {
        this.entityData.set(DOG_SIZE, (Object)size);
    }

    @Override
    public DogSize getDogSize() {
        return (DogSize)((Object)this.entityData.get(DOG_SIZE));
    }

    public boolean isBaby() {
        if (this.getDogSize() == DogSize.PPP) {
            return true;
        }
        return super.isBaby();
    }

    public void setBoneVariant(ItemStack stack) {
        this.entityData.set(BONE_VARIANT, (Object)stack);
    }

    public ItemStack getBoneVariant() {
        return (ItemStack)this.entityData.get(BONE_VARIANT);
    }

    @Nullable
    public IThrowableItem getThrowableItem() {
        Item item = ((ItemStack)this.entityData.get(BONE_VARIANT)).getItem();
        return item instanceof IThrowableItem ? (IThrowableItem)item : null;
    }

    public boolean hasBone() {
        return !this.getBoneVariant().isEmpty();
    }

    private boolean getDogFlag(int bit) {
        return ((Integer)this.entityData.get(DOG_FLAGS) & bit) != 0;
    }

    private void setDogFlag(int bits, boolean flag) {
        int c = (Integer)this.entityData.get(DOG_FLAGS);
        this.entityData.set(DOG_FLAGS, (Object)(flag ? c | bits : c & ~bits));
    }

    public void setBegging(boolean begging) {
        this.setDogFlag(1, begging);
    }

    public boolean isBegging() {
        return this.getDogFlag(1);
    }

    public void setWillObeyOthers(boolean obeyOthers) {
        this.setDogFlag(2, obeyOthers);
    }

    public boolean willObeyOthers() {
        return this.getDogFlag(2);
    }

    public void setCanPlayersAttack(boolean flag) {
        this.setDogFlag(4, flag);
    }

    public boolean canOwnerAttack() {
        return this.getDogFlag(4);
    }

    public void setForceSit(boolean val) {
        this.setDogFlag(8, val);
    }

    public boolean forceSit() {
        return this.getDogFlag(8);
    }

    public LowHealthStrategy getLowHealthStrategy() {
        int msb = this.getDogFlag(32) ? 1 : 0;
        int lsb = this.getDogFlag(16) ? 1 : 0;
        return LowHealthStrategy.fromId(msb * 2 + lsb);
    }

    public void setLowHealthStrategy(LowHealthStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(32, msb);
        this.setDogFlag(16, lsb);
    }

    public CombatReturnStrategy getCombatReturnStrategy() {
        int msb = this.getDogFlag(8192) ? 1 : 0;
        int lsb = this.getDogFlag(4096) ? 1 : 0;
        return CombatReturnStrategy.fromId(msb * 2 + lsb);
    }

    public void setCombatReturnStrategy(CombatReturnStrategy strategy) {
        byte id = strategy.getId();
        boolean lsb = (id & 1) == 1;
        boolean msb = (id >> 1 & 1) == 1;
        this.setDogFlag(8192, msb);
        this.setDogFlag(4096, lsb);
    }

    public void setRegardTeamPlayers(boolean val) {
        this.setDogFlag(128, val);
    }

    public boolean regardTeamPlayers() {
        return this.getDogFlag(128);
    }

    public boolean crossOriginTp() {
        return this.getDogFlag(64);
    }

    public void setCrossOriginTp(boolean val) {
        this.setDogFlag(64, val);
    }

    public RestingState getDogRestingState() {
        boolean isResting = this.getDogFlag(32768);
        if (!isResting) {
            return RestingState.NONE;
        }
        boolean bellyUp = this.getDogFlag(65536);
        return bellyUp ? RestingState.BELLY : RestingState.LYING;
    }

    public void setDogRestingState(RestingState val) {
        if (val == null) {
            val = RestingState.NONE;
        }
        switch (val.ordinal()) {
            default: {
                this.setDogFlag(32768, false);
                this.setDogFlag(65536, false);
                break;
            }
            case 1: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, false);
                break;
            }
            case 2: {
                this.setDogFlag(32768, true);
                this.setDogFlag(65536, true);
            }
        }
    }

    public boolean isDogResting() {
        return this.getDogRestingState() != RestingState.NONE;
    }

    public boolean patrolTargetLock() {
        return this.getDogFlag(512);
    }

    public boolean isInDrunkPose() {
        return this.getDogFlag(131072);
    }

    public void setInDrunkPose(boolean val) {
        this.setDogFlag(131072, val);
    }

    public void setForcedActionAnim(boolean val) {
        this.setDogFlag(262144, val);
    }

    @Override
    public boolean forcedWhenNoneAnim() {
        return this.getDogFlag(262144);
    }

    public void setDogOnDuty(boolean val) {
        this.setDogFlag(256, val);
    }

    public boolean dogOnDuty() {
        return this.getDogFlag(256);
    }

    public void setDrunkTicks(int ticks) {
        this.drunkTickLeft = ticks;
    }

    public boolean isDogDrunk() {
        return this.drunkTickLeft > 0;
    }

    public void setSilentTickLeft(int ticks) {
        this.silentTickLeft = ticks;
    }

    public boolean isDogSilent() {
        return this.silentTickLeft > 0;
    }

    public void setPatrolTargetLock(boolean val) {
        this.setDogFlag(512, val);
    }

    public boolean hideArmor() {
        return this.getDogFlag(2048);
    }

    public void setHideArmor(boolean val) {
        this.setDogFlag(2048, val);
    }

    public boolean dogAutoMount() {
        return this.getDogFlag(16384);
    }

    public void setDogAutoMount(boolean val) {
        this.setDogFlag(16384, val);
    }

    public boolean wantsToRest() {
        return this.tickUntilRest <= 0 && this.getRandom().nextFloat() < 0.02f;
    }

    public void resetTickTillRest() {
        this.tickUntilRest = 600 + this.getRandom().nextInt(271) * 20;
    }

    public List<TalentInstance> getTalentMap() {
        return this.dogSyncedDataManager.talents();
    }

    public InteractionResult setTalentLevel(Talent talent, int level) {
        if (0 > level || level > talent.getMaxLevel()) {
            return InteractionResult.FAIL;
        }
        List<TalentInstance> activeTalents = this.getTalentMap();
        TalentInstance inst = null;
        int selected_id = -1;
        for (int i = 0; i < activeTalents.size(); ++i) {
            TalentInstance activeInst = activeTalents.get(i);
            if (!activeInst.of(talent)) continue;
            inst = activeInst;
            selected_id = i;
            break;
        }
        if (inst == null) {
            if (level == 0) {
                return InteractionResult.PASS;
            }
            TalentInstance newTalent = talent.getDefault(level);
            this.dogSyncedDataManager.talents().add(newTalent);
        } else {
            int remove_id;
            int previousLevel = inst.level();
            if (previousLevel == level) {
                return InteractionResult.PASS;
            }
            inst.setLevel(level);
            inst.set(this, previousLevel);
            if (level <= 0 && (remove_id = selected_id) >= 0) {
                this.dogSyncedDataManager.talents().remove(remove_id);
            }
        }
        this.dogSyncedDataManager.setTalentsDirty();
        return InteractionResult.SUCCESS;
    }

    public List<DoggyArtifactItem> getArtifactsList() {
        List array = (List)this.entityData.get(ARTIFACTS);
        return array;
    }

    public boolean addArtifact(DoggyArtifactItem artifact) {
        if (artifact == null) {
            return false;
        }
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (array.size() >= 3) {
            return false;
        }
        if (array.contains((Object)artifact)) {
            return false;
        }
        this.modifyArtifact(artifacts -> artifacts.add(artifact));
        return true;
    }

    public ItemStack removeArtifact(int indx) {
        List<DoggyArtifactItem> array = this.getArtifactsList();
        if (indx < 0 || indx >= array.size()) {
            return null;
        }
        DoggyArtifactItem removedArtifact = array.get(indx);
        this.modifyArtifact(artifacts -> artifacts.remove(indx));
        return new ItemStack((ItemLike)removedArtifact);
    }

    public void modifyArtifact(Consumer<List<DoggyArtifactItem>> modify) {
        this.modifyListSyncedData(ARTIFACTS, modify);
    }

    public <T> void modifyListSyncedData(EntityDataAccessor<List<T>> key, Consumer<List<T>> modify) {
        this.modifySyncedData(key, modify, x -> new ArrayList(x));
    }

    public <T> void modifySyncedData(EntityDataAccessor<T> key, Consumer<T> modify, Function<T, T> copyFunc) {
        Object result = copyFunc.apply(this.entityData.get(key));
        modify.accept(result);
        this.entityData.set(key, result);
    }

    @Override
    public Optional<TalentInstance> getTalent(Talent talentIn) {
        List<TalentInstance> activeTalents = this.getTalentMap();
        for (TalentInstance activeInst : activeTalents) {
            if (!activeInst.of(talentIn)) continue;
            return Optional.of(activeInst);
        }
        return Optional.empty();
    }

    public <T extends TalentInstance> Optional<T> getTalent(Talent talent, Class<T> type) {
        Optional<TalentInstance> inst_optional = this.getTalent(talent);
        return inst_optional.map(x -> x.cast(type));
    }

    @Override
    public int getDogLevel(Talent talentIn) {
        return this.getTalent(talentIn).map(TalentInstance::level).orElse(0);
    }

    public void untame() {
        this.navigation.stop();
        this.clearTriggerableAction();
        this.dogAi.forceStopAllGoal();
        this.setOrderedToSit(false);
        this.setHealth(8.0f);
        this.setDogCustomName(null);
        this.dogSyncedDataManager.talents().clear();
        this.dogSyncedDataManager.setTalentsDirty();
        this.authorizedChangingOwner = true;
        this.setTame(false, false);
        this.setOwnerUUID(null);
        this.setWillObeyOthers(false);
        this.setCanPlayersAttack(true);
        this.setMode(DogMode.DOCILE);
        this.authorizedChangingOwner = false;
    }

    public void migrateOwner(UUID newOwnerUUID) {
        this.navigation.stop();
        this.clearTriggerableAction();
        this.dogAi.forceStopAllGoal();
        this.setMode(DogMode.DOCILE);
        this.authorizedChangingOwner = true;
        this.setOwnerUUID(newOwnerUUID);
        this.authorizedChangingOwner = false;
    }

    public boolean canSpendPoints(int amount) {
        return this.getSpendablePoints() >= amount || this.getAccessory(DoggyAccessories.GOLDEN_COLLAR.get()).isPresent();
    }

    private final int getSpendablePointsInternal() {
        int totalPoints = 15 + this.getDogLevel().getLevel(DogLevel.Type.NORMAL) + this.getDogLevel().getLevel(DogLevel.Type.KAMI);
        for (TalentInstance entry : this.getTalentMap()) {
            totalPoints -= entry.getTalent().getCummulativeCost(entry.level());
        }
        return totalPoints;
    }

    public int getSpendablePoints() {
        return this.spendablePoints.get();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public LivingEntity getControllingPassenger() {
        List passengers = this.getPassengers();
        if (passengers.isEmpty()) {
            return null;
        }
        Entity first_passenger = (Entity)passengers.get(0);
        if (!(first_passenger instanceof Player)) {
            return null;
        }
        Player player = (Player)first_passenger;
        return this.canInteract((LivingEntity)player) ? player : null;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        float a1 = this.getYRot();
        float dx1 = -Mth.sin((float)(a1 * ((float)Math.PI / 180)));
        float dz1 = Mth.cos((float)(a1 * ((float)Math.PI / 180)));
        double newX = this.getX() + (double)dx1;
        double newZ = this.getZ() + (double)dz1;
        Vec3 newPos = new Vec3(newX, this.getY() + 0.5, newZ);
        BlockPos b0 = BlockPos.containing((Position)newPos);
        newPos = Vec3.atBottomCenterOf((Vec3i)b0);
        PathType type = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)b0.mutable());
        if (type == PathType.WALKABLE) {
            for (Pose pose : passenger.getDismountPoses()) {
                AABB dismountBb = passenger.getLocalBoundsForPose(pose).move(newPos);
                if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)dismountBb)) continue;
                passenger.setPose(pose);
                return newPos;
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    public boolean isPickable() {
        if (this.level().isClientSide && ClientEventHandler.shouldClientBlockPick(this)) {
            return false;
        }
        return super.isPickable();
    }

    public boolean isPushable() {
        return (!this.isVehicle() || !this.hasControllingPassenger()) && super.isPushable();
    }

    public boolean isDogJumping() {
        return this.dogJumping;
    }

    public void setDogJumping(boolean jumping) {
        this.dogJumping = jumping;
    }

    public void setJumpPower(int jumpPowerIn) {
        this.jumpPower = 1.0f;
    }

    public boolean canJump() {
        return true;
    }

    public void travel(Vec3 positionIn) {
        if (this.isDogResistingPush()) {
            this.mayDogResistPush();
        }
        super.travel(positionIn);
        if (this.isDogFlying()) {
            Vec3 moveVec = this.getDeltaMovement();
            double down = moveVec.y;
            double gravity = -0.112102;
            AttributeInstance attrib = this.getAttribute(Attributes.GRAVITY);
            if (attrib != null) {
                gravity = -attrib.getValue();
            }
            down = down < 0.0 ? Math.min(down * 0.7, gravity) : (down *= 0.7);
            this.setDeltaMovement(moveVec.x * 0.67, down, moveVec.z * 0.67);
        }
        this.addMovementStat(this.getX() - this.xo, this.getY() - this.yo, this.getZ() - this.zo);
    }

    private void mayDogResistPush() {
        double moveZ;
        if (!this.canDogResistPush()) {
            return;
        }
        double max_XZ_push_len = this.getDogPushResistXZCap();
        Vec3 move = this.getDeltaMovement();
        double moveX = move.x();
        double moveXZ_lSqr = moveX * moveX + (moveZ = move.z()) * moveZ;
        if (moveXZ_lSqr <= max_XZ_push_len * max_XZ_push_len) {
            return;
        }
        double moveXZ_l = Math.sqrt(moveXZ_lSqr);
        moveX = moveX / moveXZ_l * max_XZ_push_len;
        moveZ = moveZ / moveXZ_l * max_XZ_push_len;
        this.setDeltaMovement(new Vec3(moveX, move.y(), moveZ));
    }

    public boolean canDogResistPush() {
        if (!this.onGround()) {
            return false;
        }
        if (!this.isDoingFine()) {
            return false;
        }
        if (this.isDogCurious()) {
            return false;
        }
        if (this.isVehicle()) {
            return false;
        }
        return !this.isPathFinding();
    }

    private void mayFloatDogInLava() {
        if (!this.isInLava()) {
            return;
        }
        CollisionContext collisioncontext = CollisionContext.of((Entity)this);
        if (collisioncontext.isAbove(LiquidBlock.STABLE_SHAPE, this.blockPosition(), true) && !this.level().getFluidState(this.blockPosition().above()).is(FluidTags.LAVA)) {
            this.setOnGround(true);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.085, 0.0));
        }
    }

    protected float getFlyingSpeed() {
        return this.isDogFlying() ? 0.49f : super.getFlyingSpeed();
    }

    public boolean canDogFly() {
        return this.alterationProps.canFly() && this.alterationProps.willFly();
    }

    protected void tickRidden(Player rider, Vec3 rideVec) {
        if (this.isDefeated()) {
            return;
        }
        this.setYRot(rider.getYRot());
        this.yRotO = this.getYRot();
        this.setXRot(rider.getXRot() * 0.5f);
        this.setRot(this.getYRot(), this.getXRot());
        this.yHeadRot = this.yBodyRot = this.getYRot();
        this.checkAndJumpWhenBeingRidden((LivingEntity)rider);
        if (this.onClimbable()) {
            this.fallDistance = 0.0f;
        }
        this.addMovementStat(this.getX() - this.xo, this.getY() - this.yo, this.getZ() - this.zo);
    }

    protected BodyRotationControl createBodyControl() {
        return new DogBodyRotationControl(this);
    }

    private void checkAndJumpWhenBeingRidden(LivingEntity rider) {
        float forward = rider.zza;
        if (this.jumpPower > 0.0f) {
            if (this.isInWater() && this.canSwimUnderwater()) {
                this.doDogRideFloat();
            } else if (!this.isDogJumping() && this.onGround()) {
                this.doDogRideJump(forward);
            }
        }
        if (this.onGround()) {
            this.jumpPower = 0.0f;
            this.setDogJumping(false);
        } else {
            this.jumpPower = 0.0f;
        }
    }

    protected Vec3 getRiddenInput(Player rider, Vec3 rideVec) {
        float straf = rider.xxa * 0.7f;
        float forward = rider.zza;
        double downward = rideVec.y;
        if (forward > 0.0f && !this.isDogRidingConstraintToGround()) {
            float l = forward;
            downward = -l * Mth.sin((float)(rider.getXRot() * ((float)Math.PI / 180)));
            forward = l * Mth.cos((float)(rider.getXRot() * ((float)Math.PI / 180)));
        }
        if (forward <= 0.0f) {
            forward *= 0.5f;
        }
        return new Vec3((double)straf, downward, (double)forward);
    }

    protected boolean isDogRidingConstraintToGround() {
        if (this.isInWater() && this.canSwimUnderwater()) {
            return false;
        }
        return !this.canDogFly();
    }

    protected float getRiddenSpeed(Player rider) {
        return (float)this.getAttribute(Attributes.MOVEMENT_SPEED).getValue() * 0.5f;
    }

    private void doDogRideFloat() {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x, 0.1, vec3d.z);
        this.jumpPower = 0.0f;
    }

    private void doDogRideJump(double forward) {
        double jumpValue = this.getAttribute((Holder)DoggyAttributes.JUMP_POWER).getValue() * (double)this.getBlockJumpFactor() * (double)this.jumpPower;
        if (this.hasEffect(MobEffects.JUMP)) {
            jumpValue += (double)((float)(this.getEffect(MobEffects.JUMP).getAmplifier() + 1) * 0.1f);
        }
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x, jumpValue, vec3d.z);
        this.setDogJumping(true);
        this.hasImpulse = true;
        if (forward > 0.0) {
            float amount = 0.4f;
            float compX = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)));
            float compZ = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)));
            this.setDeltaMovement(this.getDeltaMovement().add((double)(-0.4f * compX * this.jumpPower), 0.0, (double)(0.4f * compZ * this.jumpPower)));
        }
        this.jumpPower = 0.0f;
    }

    public void addMovementStat(double xD, double yD, double zD) {
        int j;
        if (this.isVehicle()) {
            j = Math.round(Mth.sqrt((float)((float)(xD * xD + zD * zD))) * 100.0f);
            this.statsTracker.increaseDistanceRidden(j);
        }
        if (!this.isPassenger()) {
            if (this.isEyeInFluid(FluidTags.WATER)) {
                j = Math.round(Mth.sqrt((float)((float)(xD * xD + yD * yD + zD * zD))) * 100.0f);
                if (j > 0) {
                    this.statsTracker.increaseDistanceOnWater(j);
                }
            } else if (this.isInWater()) {
                int k = Math.round(Mth.sqrt((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (k > 0) {
                    this.statsTracker.increaseDistanceInWater(k);
                }
            } else if (this.onGround()) {
                int l = Math.round(Mth.sqrt((float)((float)(xD * xD + zD * zD))) * 100.0f);
                if (l > 0) {
                    if (this.isSprinting()) {
                        this.statsTracker.increaseDistanceSprint(l);
                    } else if (this.isCrouching()) {
                        this.statsTracker.increaseDistanceSneaking(l);
                    } else {
                        this.statsTracker.increaseDistanceWalk(l);
                    }
                }
            } else {
                int n = Math.round(Mth.sqrt((float)((float)(xD * xD + zD * zD))) * 100.0f);
            }
        }
    }

    public boolean isPushedByFluid(FluidType type) {
        if (this.fireImmune() && type == NeoForgeMod.LAVA_TYPE.value()) {
            return false;
        }
        if (this.alterationProps.resistWaterPush() && type == NeoForgeMod.WATER_TYPE.value()) {
            return false;
        }
        if (this.isDogForcePushAvoid()) {
            return false;
        }
        if (this.getDefaultNavigationIfActive().map(DogPathNavigation::shouldDogBlockFluidPush).orElse(false).booleanValue()) {
            return false;
        }
        for (IDogAlteration alter : this.alterations) {
            InteractionResult result = alter.canResistPushFromFluidType(type);
            if (!result.shouldSwing()) continue;
            return false;
        }
        return super.isPushedByFluid(type);
    }

    public MutableComponent getTranslationKey(Function<DogGender, String> function) {
        return Component.translatable((String)((String)function.apply((Object)((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.DISABLE_GENDER) == false ? this.getGender() : DogGender.UNISEX))));
    }

    @Override
    public boolean isLying() {
        boolean ownerSleeping;
        LivingEntity owner = this.getOwner();
        boolean bl = ownerSleeping = owner != null && owner.isSleeping();
        if (ownerSleeping) {
            return true;
        }
        if (this.isDefeated()) {
            boolean onBed;
            BlockState blockBelow = this.level().getBlockState(this.blockPosition());
            boolean bl2 = onBed = blockBelow.is((Block)DoggyBlocks.DOG_BED.get()) || blockBelow.is(BlockTags.BEDS);
            if (onBed) {
                return true;
            }
        }
        return false;
    }

    public void setInSittingPose(boolean sit) {
        if (!this.level().isClientSide && this.animAction == null) {
            boolean sit0 = this.isInSittingPose();
            if (sit0 != sit) {
                DogAnimation anim;
                DogAnimation dogAnimation = anim = sit ? this.getSitAnim() : this.getStandAnim();
                if (!sit0 && this.isLying()) {
                    anim = DogAnimation.NONE;
                }
                if (anim != DogAnimation.NONE) {
                    this.setAnim(anim);
                }
            }
            this.sitAnim = DogAnimation.SIT_DOWN;
            this.standAnim = DogAnimation.STAND_QUICK;
        }
        super.setInSittingPose(sit);
    }

    public void setSitAnim(DogAnimation anim) {
        if (anim == null) {
            this.sitAnim = DogAnimation.SIT_DOWN;
            return;
        }
        this.sitAnim = anim;
    }

    public DogAnimation getStandAnim() {
        return this.standAnim;
    }

    public void setStandAnim(DogAnimation anim) {
        if (anim == null) {
            this.standAnim = DogAnimation.STAND_QUICK;
            return;
        }
        this.standAnim = anim;
    }

    public DogAnimation getSitAnim() {
        return this.sitAnim;
    }

    public void setOrderedToSit(boolean val) {
        super.setOrderedToSit(val);
        this.mayDogCorrectSittingPose(val);
    }

    private void mayDogCorrectSittingPose(boolean sit_ordered) {
        if (this.level().isClientSide) {
            return;
        }
        if (sit_ordered) {
            return;
        }
        if (this.dogAi == null) {
            return;
        }
        if (this.dogAi.isSitGoalRunning()) {
            return;
        }
        this.setInSittingPose(false);
    }

    public void setChopinTailFor(int ticks) {
        this.tickChopinTail = ticks;
    }

    public boolean isChopinTail() {
        return this.tickChopinTail > 0;
    }

    @Override
    public List<IDogFoodHandler> getFoodHandlers() {
        return this.foodHandlers;
    }

    @Override
    public void resetNavigation() {
        this.setNavigation(this.defaultNavigation);
    }

    @Override
    public void resetMoveControl() {
        this.setMoveControl(this.defaultMoveControl);
    }

    @Override
    public void setNavigation(PathNavigation p) {
        super.setNavigation(p);
        this.switchNavCooldown = 5;
        if (p instanceof IDogNavLock) {
            IDogNavLock lock = (IDogNavLock)p;
            this.currentNavigation = p;
            this.navigationLock = lock;
        }
    }

    @Override
    public DogPathNavigation getDefaultNavigation() {
        return this.defaultNavigation;
    }

    @Override
    public DogMoveControl getDefaultMoveControl() {
        return this.defaultMoveControl;
    }

    public boolean isDefaultNavigation() {
        return this.defaultNavigation == this.getNavigation();
    }

    public Optional<DogPathNavigation> getDefaultNavigationIfActive() {
        if (this.isDefaultNavigation()) {
            return Optional.of(this.defaultNavigation);
        }
        return Optional.empty();
    }

    protected DogPathNavigation createNavigation(Level p_21480_) {
        DogPathNavigation dogPathNav = new DogPathNavigation(this, p_21480_);
        this.currentNavigation = dogPathNav;
        this.navigationLock = dogPathNav;
        this.navigationLock.lockDogNavigation();
        return dogPathNav;
    }

    public void setDogSitOverridePos(@Nonnull BlockPos pos) {
        this.lastSitPos = Optional.of(pos);
        this.lastSitPosSaveTimestamp = this.tickCount;
    }

    public void clearDogSitOverridePos() {
        this.lastSitPos = Optional.empty();
    }

    public Optional<BlockPos> getDogSitOverridePos() {
        return this.lastSitPos;
    }

    public int getDogSitOverridePosTimestamp() {
        return this.lastSitPosSaveTimestamp;
    }

    public float getPathfindingMalus(PathType type) {
        switch (type) {
            default: {
                break;
            }
            case WATER: 
            case WATER_BORDER: {
                if (!this.shouldDogOmitWaterPathWeight()) break;
                return 0.0f;
            }
            case LAVA: 
            case DAMAGE_FIRE: 
            case DANGER_FIRE: {
                if (!this.fireImmune()) break;
                return 0.0f;
            }
            case DOOR_WOOD_CLOSED: {
                if (!this.canDogPassGate()) break;
                return 8.0f;
            }
            case DANGER_POWDER_SNOW: 
            case POWDER_SNOW: {
                return -1.0f;
            }
            case DANGER_TRAPDOOR: 
            case TRAPDOOR: {
                return -1.0f;
            }
        }
        return super.getPathfindingMalus(type);
    }

    private boolean shouldDogOmitWaterPathWeight() {
        if (this.isDogFollowingSomeone()) {
            return true;
        }
        if (!this.isInWater()) {
            return false;
        }
        if (this.alterationProps.canBreatheUnderwater()) {
            return true;
        }
        return this.canSwimUnderwater() && !this.isLowAirSupply();
    }

    public boolean shouldDogBlockFloat() {
        return this.fireImmune() && this.isInLava();
    }

    public boolean isDogFollowingSomeone() {
        return this.isDogFollowingSomeone;
    }

    public void setDogFollowingSomeone(boolean val) {
        this.isDogFollowingSomeone = val;
    }

    public void setDogResistingPush(boolean val) {
        this.isDogResistingPush = val;
    }

    public boolean isDogResistingPush() {
        return this.isDogResistingPush;
    }

    public double getDogPushResistXZCap() {
        return 5.0E-4;
    }

    public List<IDogAlteration> getAlterations() {
        return this.alterations;
    }

    @Override
    public boolean canSwimUnderwater() {
        return this.alterationProps.canSwimUnderwater();
    }

    @Override
    public boolean canDogWearArmor() {
        return this.alterationProps.canWearArmor();
    }

    @Override
    public boolean canDogUseTools() {
        return this.alterationProps.canUseTools();
    }

    @Override
    public DogArmorItemHandlerImpl dogArmors() {
        return this.dogArmors;
    }

    @Override
    public ItemStack wolfArmor() {
        ItemStack stack = this.getItemBySlot(EquipmentSlot.BODY);
        if (stack == null || !stack.is(Items.WOLF_ARMOR)) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public void setWolfArmor(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            this.setItemSlot(EquipmentSlot.BODY, ItemStack.EMPTY);
        }
        if (!stack.is(Items.WOLF_ARMOR)) {
            return;
        }
        this.setItemSlot(EquipmentSlot.BODY, stack);
    }

    public boolean hasWolfArmor() {
        return !this.wolfArmor().isEmpty();
    }

    public Iterable<ItemStack> getHandSlots() {
        if (!this.canDogUseTools() || this.mouthStack == null) {
            return List.of();
        }
        return List.of(this.mouthStack);
    }

    public Iterable<ItemStack> getArmorSlots() {
        if (!this.canDogWearArmor()) {
            return List.of();
        }
        return this.dogArmors.armors();
    }

    public Iterable<ItemStack> getArmorAndBodyArmorSlots() {
        return this.getArmorSlots();
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        boolean getMouth;
        boolean getArmor;
        EquipmentSlot.Type type = slot.getType();
        boolean bl = getArmor = type == EquipmentSlot.Type.HUMANOID_ARMOR && (this.alterationProps.canWearArmor() || this.level().isClientSide);
        if (getArmor) {
            return this.dogArmors.getArmorFromSlot(slot);
        }
        boolean bl2 = getMouth = slot == EquipmentSlot.MAINHAND && (this.alterationProps.canUseTools() || this.level().isClientSide) && this.mouthStack != null;
        if (getMouth) {
            return this.mouthStack;
        }
        if (slot == EquipmentSlot.BODY && this.wolfArmorStack != null && this.wolfArmorStack.is(Items.WOLF_ARMOR)) {
            return this.wolfArmorStack;
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        this.verifyEquippedItem(stack);
        if (this.trySetDogArmorSlot(slot, stack)) {
            return;
        }
        if (this.trySetDogToolSlot(slot, stack)) {
            return;
        }
        if (this.trySetWolfArmor(slot, stack)) {
            return;
        }
    }

    private boolean trySetDogArmorSlot(EquipmentSlot slot, ItemStack stack) {
        if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) {
            return false;
        }
        if (!this.level().isClientSide && !this.canDogWearArmor()) {
            return false;
        }
        ItemStack oldStack = this.dogArmors.getArmorFromSlot(slot);
        this.dogArmors.setArmorInSlot(stack, slot);
        this.onEquipItem(slot, oldStack, stack);
        return true;
    }

    private boolean trySetDogToolSlot(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.MAINHAND) {
            return false;
        }
        if (!this.level().isClientSide && !this.canDogUseTools()) {
            return false;
        }
        ItemStack oldStack = this.mouthStack == null ? ItemStack.EMPTY : this.mouthStack;
        this.mouthStack = stack;
        this.onEquipItem(slot, oldStack, stack);
        return true;
    }

    private boolean trySetWolfArmor(EquipmentSlot slot, ItemStack stack) {
        boolean is_not_empty_not_wolf_armor;
        if (slot != EquipmentSlot.BODY) {
            return false;
        }
        boolean bl = is_not_empty_not_wolf_armor = stack != null && !stack.isEmpty() && !stack.is(Items.WOLF_ARMOR);
        if (is_not_empty_not_wolf_armor) {
            return false;
        }
        if (stack == null) {
            stack = ItemStack.EMPTY;
        }
        ItemStack oldStack = this.wolfArmorStack == null ? ItemStack.EMPTY : this.wolfArmorStack;
        this.wolfArmorStack = stack;
        this.onEquipItem(slot, oldStack, stack);
        return true;
    }

    public void onEquipItem(EquipmentSlot slot, ItemStack oldStack, ItemStack newStack) {
        boolean is_slot_should_be_handled;
        EquipmentSlot.Type type = slot.getType();
        boolean bl = is_slot_should_be_handled = type == EquipmentSlot.Type.HUMANOID_ARMOR || type == EquipmentSlot.Type.ANIMAL_ARMOR;
        if (!is_slot_should_be_handled) {
            return;
        }
        super.onEquipItem(slot, oldStack, newStack);
    }

    public boolean canTakeItem(ItemStack stack) {
        return this.checkEligibleArmorItemAndAvailableSlot(stack);
    }

    private boolean checkEligibleArmorItemAndAvailableSlot(ItemStack stack) {
        if (!this.canDogWearArmor()) {
            return false;
        }
        if (!(stack.getItem() instanceof ArmorItem)) {
            return false;
        }
        EquipmentSlot slot = this.getEquipmentSlotForItem(stack);
        if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) {
            return false;
        }
        ItemStack current = this.getItemBySlot(slot);
        return current == null || current.isEmpty();
    }

    protected void dropAllDeathLoot(ServerLevel p_348524_, DamageSource source) {
        this.dropEquipment();
    }

    public boolean isLowAirSupply() {
        return (double)this.getAirSupply() < (double)this.getMaxAirSupply() * 0.3;
    }

    @Override
    public boolean isDogLowHealth() {
        return this.getHealth() < 6.0f;
    }

    @Override
    public void setDogSwimming(boolean s) {
        this.isDogSwimming = s;
    }

    public boolean isDogSwimming() {
        return this.isDogSwimming;
    }

    public void setDogForcePushAvoid(boolean val) {
        this.setDogFlag(524288, val);
    }

    public boolean isDogForcePushAvoid() {
        return this.getDogFlag(524288);
    }

    public boolean isDogCurious() {
        return this.isDogCurious;
    }

    public void setDogCurious(boolean val) {
        this.isDogCurious = val;
    }

    @Override
    public void setDogFlying(boolean s) {
        this.setDogFlag(1024, s);
    }

    @Override
    public boolean isDogFlying() {
        return this.getDogFlag(1024);
    }

    public boolean isLowHunger() {
        return this.hungerManager.isLowHunger();
    }

    protected void updateControlFlags() {
        boolean incapBlockedMove = this.isDefeated() && !this.incapacitatedMananger.canMove();
        boolean animBlockedMove = this.animAction != null;
        boolean animBlockedLook = this.animAction != null;
        boolean notControlledByPlayer = !(this.getControllingPassenger() instanceof ServerPlayer);
        boolean notRidingBoat = !(this.getVehicle() instanceof Boat);
        this.dogAi.setLockedFlag(Goal.Flag.MOVE, notControlledByPlayer && !incapBlockedMove && !animBlockedMove);
        this.dogAi.setLockedFlag(Goal.Flag.JUMP, notControlledByPlayer && notRidingBoat);
        this.dogAi.setLockedFlag(Goal.Flag.LOOK, notControlledByPlayer && !animBlockedLook);
    }

    protected void doPush(Entity pushTarget) {
        if (this.pettingManager.checkPush(pushTarget)) {
            return;
        }
        if (this.dogPushAvoidManager.shouldBlockActivePush(pushTarget)) {
            return;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(pushTarget)) {
            return;
        }
        if (pushTarget.getVehicle() == this || this.getVehicle() == pushTarget) {
            return;
        }
        if (this.isVehicle() && !this.hasControllingPassenger()) {
            this.customDogPush(pushTarget, true);
        } else {
            super.doPush(pushTarget);
        }
    }

    public void push(Entity source) {
        if (source.getVehicle() == this || this.getVehicle() == source) {
            return;
        }
        if (this.pettingManager.checkPush(source)) {
            return;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return;
        }
        DogPushAvoidManager.OnBeingPushAction result = this.dogPushAvoidManager.onBeingPushed(source);
        if (result == DogPushAvoidManager.OnBeingPushAction.BLOCK_ALL) {
            return;
        }
        if (result == DogPushAvoidManager.OnBeingPushAction.BLOCK_SOURCE || this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(source)) {
            this.customDogPush(source, false);
        } else if (this.isVehicle() && !this.hasControllingPassenger()) {
            this.customDogPush(source, true);
        } else {
            if (this.isDogCurious()) {
                this.setDogCurious(false);
            }
            super.push(source);
        }
    }

    private void customDogPush(Entity source, boolean pushSource) {
        Optional<Vec3> push_vec_optional = this.calcDogPushVec(source);
        if (!push_vec_optional.isPresent()) {
            return;
        }
        Vec3 push_vec = push_vec_optional.get();
        if (this.isPushable()) {
            this.push(-push_vec.x(), 0.0, -push_vec.z());
        }
        if (pushSource && source.isPushable()) {
            source.push(push_vec.x(), 0.0, push_vec.z());
        }
    }

    private Optional<Vec3> calcDogPushVec(Entity source) {
        double dz_vec;
        if (this.isPassengerOfSameVehicle(source)) {
            return Optional.empty();
        }
        if (source.noPhysics || this.noPhysics) {
            return Optional.empty();
        }
        double dx_vec = source.getX() - this.getX();
        double max_magnitude = Mth.absMax((double)dx_vec, (double)(dz_vec = source.getZ() - this.getZ()));
        if (max_magnitude < 0.01) {
            return Optional.empty();
        }
        max_magnitude = Math.sqrt(max_magnitude);
        dx_vec /= max_magnitude;
        dz_vec /= max_magnitude;
        double max_magnitude_inv = 1.0 / max_magnitude;
        if (max_magnitude_inv > 1.0) {
            max_magnitude_inv = 1.0;
        }
        dx_vec *= max_magnitude_inv;
        dz_vec *= max_magnitude_inv;
        return Optional.of(new Vec3(dx_vec *= 0.05, 0.0, dz_vec *= 0.05));
    }

    public boolean canCollideWith(Entity otherEntity) {
        if (this.dogPushAvoidManager.shouldBlockActivePush(otherEntity)) {
            return false;
        }
        if (DogSleepOnManager.shouldBlockPush(this)) {
            return false;
        }
        if (this.isDefeated() && this.incapacitatedMananger.shouldApplyCustomPushBehaviour(otherEntity)) {
            return false;
        }
        if (otherEntity.getVehicle() == this || this.getVehicle() == otherEntity) {
            return false;
        }
        return super.canCollideWith(otherEntity);
    }

    public PathType getBlockPathTypeViaAlterations(BlockPos pos) {
        PathType blockType = WalkNodeEvaluator.getPathTypeStatic((Mob)this, (BlockPos)pos.mutable());
        blockType = this.inferType(blockType, InferTypeContext.getDefault());
        return blockType;
    }

    public PathType inferType(PathType type, InferTypeContext context) {
        if (this.fireImmune()) {
            if (type == PathType.DANGER_FIRE) {
                return PathType.WALKABLE;
            }
            if (type == PathType.LAVA) {
                return PathType.BLOCKED;
            }
        }
        if (this.canSwimUnderwater() && this.alterationProps.canBreatheUnderwater() && type == PathType.WATER) {
            return PathType.WALKABLE;
        }
        for (IDogAlteration alt : this.alterations) {
            InteractionResultHolder<PathType> result = alt.inferType(this, type, context);
            if (!result.getResult().shouldSwing()) continue;
            type = (PathType)result.getObject();
            break;
        }
        return type;
    }

    public boolean canDogPassGate() {
        for (IDogAlteration alt : this.alterations) {
            if (!alt.canDogPassGate(this).shouldSwing()) continue;
            return true;
        }
        return false;
    }

    public float getTimeDogIsShaking() {
        return this.timeWolfIsShaking;
    }

    public float getUrgentSpeedModifier() {
        if (this.getAttributeValue((Holder<Attribute>)Attributes.MOVEMENT_SPEED) <= 0.3) {
            return 1.5f;
        }
        return 1.0f;
    }

    public StatsTracker getStatTracker() {
        return this.statsTracker;
    }

    public DogGroupsManager getGroups() {
        return this.dogGroupsManager;
    }

    public void setAnim(DogAnimation animation) {
        this.entityData.set(ANIMATION, (Object)animation.getId());
    }

    @Override
    public DogAnimation getAnim() {
        return DogAnimation.byId((Integer)this.entityData.get(ANIMATION));
    }

    public DogAnimationManager.DogAnimDebugState getDogAnimDebugState() {
        return (DogAnimationManager.DogAnimDebugState)this.entityData.get(DOG_ANIM_DEBUG_STATE);
    }

    public void setDogAnimDebugState(DogAnimationManager.DogAnimDebugState state) {
        if (state.isNone()) {
            state = DogAnimationManager.DogAnimDebugState.NONE;
        }
        this.entityData.set(DOG_ANIM_DEBUG_STATE, (Object)state);
    }

    public boolean isDogInAnimDebug() {
        return !this.getDogAnimDebugState().isNone();
    }

    public void setAnimSyncTime(int val) {
        this.entityData.set(ANIM_SYNC_TIME, (Object)val);
    }

    public int getAnimSyncTime() {
        return (Integer)this.entityData.get(ANIM_SYNC_TIME);
    }

    public void triggerAnimationAction(AnimationAction action) {
        if (this.animAction != null) {
            this.animAction.stop();
        }
        this.animAction = action;
        if (this.animAction != null) {
            this.getNavigation().stop();
            this.updateControlFlags();
            this.forceStopAllGoalWithFlag(Goal.Flag.MOVE);
            this.forceStopAllGoalWithFlag(Goal.Flag.LOOK);
            this.animAction.start();
        }
    }

    private void forceStopAllGoalWithFlag(Goal.Flag flag) {
        this.dogAi.forceStopAllGoalWithFlag(flag);
    }

    protected void tickAnimAction() {
        if (this.animAction == null) {
            return;
        }
        switch (this.animAction.getState()) {
            case FINISHED: {
                this.triggerAnimationAction(null);
                break;
            }
            default: {
                this.animAction.tick();
            }
        }
    }

    public DogPose getDogPose() {
        return this.activePose;
    }

    private void setDogPose(DogPose pose) {
        this.activePose = pose;
    }

    public void updateDogPose() {
        if (this.isDefeated() && !this.incapacitatedMananger.canMove()) {
            this.setDogPose(this.incapacitatedMananger.getPose());
            return;
        }
        if (this.isInDrunkPose()) {
            this.setDogPose(DogPose.REST_BELLY);
            return;
        }
        if (this.isInSittingPose()) {
            RestingState restState = this.getDogRestingState();
            if (restState == RestingState.LYING) {
                this.setDogPose(DogPose.REST);
                return;
            }
            if (restState == RestingState.BELLY) {
                this.setDogPose(DogPose.REST_BELLY);
                return;
            }
            this.setDogPose(this.isLying() ? DogPose.LYING_2 : DogPose.SIT);
            return;
        }
        if (this.isDogFlying() && !this.forcedWhenNoneAnim()) {
            this.setDogPose(DogPose.FLYING);
            return;
        }
        this.setDogPose(DogPose.STAND);
    }

    @Override
    public float getClientAnimatedYBodyRotInRadians() {
        if (!this.level().isClientSide) {
            return this.yBodyRot * ((float)Math.PI / 180);
        }
        return this.yBodyRot * ((float)Math.PI / 180) + ClientEventHandler.getAnimatedYRot(this);
    }

    public DogSkin getClientSkin() {
        if (((Boolean)ConfigHandler.CLIENT.ALWAYS_RENDER_CLASSICAL.get()).booleanValue()) {
            return DogSkin.CLASSICAL;
        }
        this.clientSkin = DogSkinHolder.update(this, this.clientSkin);
        return this.clientSkin.getOrElse(DogSkin.CLASSICAL);
    }

    @Override
    public boolean isDogVariantRenderEffective() {
        DogSkin skin = this.getClientSkin();
        return skin == null || !skin.isCustom();
    }

    public void setClientSkinHolder(DogSkinHolder skin) {
        if (skin == null) {
            skin = DogSkinHolder.getNone();
        }
        this.clientSkin = skin;
    }

    public DogSkinHolder getClientSkinHolder() {
        return this.clientSkin;
    }

    public List<AccessoryInstance> getClientSortedAccessories() {
        return this.clientAccessories;
    }

    public Optional<ItemStack> getMouthItemForRender() {
        if (this.hasBone()) {
            ItemStack customStack;
            ItemStack renderStack = this.getBoneVariant();
            IThrowableItem throwableItem = this.getThrowableItem();
            if (throwableItem != null && (customStack = throwableItem.getCustomRenderStack(renderStack)) != null) {
                renderStack = customStack;
            }
            return Optional.of(renderStack);
        }
        ItemStack stack = this.getMainHandItem();
        if (stack != null && !stack.isEmpty()) {
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.onAddedToWorld();
    }

    public void onRemovedFromLevel() {
        super.onRemovedFromLevel();
        this.onRemovedFromWorld();
    }

    public boolean isAddedToWorld() {
        return this.isAddedToLevel();
    }

    public static enum LowHealthStrategy {
        NONE(0),
        RUN_AWAY(1),
        STICK_TO_OWNER(2);

        public static final LowHealthStrategy[] VALUES;
        private final byte id;

        private LowHealthStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.low_health_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.low_health_strategy." + this.getId() + ".help";
        }

        public static LowHealthStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public LowHealthStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public LowHealthStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (LowHealthStrategy[])Arrays.stream(LowHealthStrategy.values()).sorted(Comparator.comparingInt(LowHealthStrategy::getId)).toArray(LowHealthStrategy[]::new);
        }
    }

    public static enum CombatReturnStrategy {
        STANDARD(0),
        FAR(1),
        NONE(2);

        public static final CombatReturnStrategy[] VALUES;
        private final byte id;

        private CombatReturnStrategy(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public String getUnlocalisedTitle() {
            return "dog.combat_return_strategy." + this.getId();
        }

        public String getUnlocalisedInfo() {
            return "dog.combat_return_strategy." + this.getId() + ".help";
        }

        public static CombatReturnStrategy fromId(int id) {
            if (0 > id || id > 2) {
                return NONE;
            }
            return VALUES[id];
        }

        public CombatReturnStrategy prev() {
            int i = this.getId() - 1;
            if (i < 0) {
                i = VALUES.length - 1;
            }
            return VALUES[i];
        }

        public CombatReturnStrategy next() {
            int i = this.getId() + 1;
            if (i >= VALUES.length) {
                i = 0;
            }
            return VALUES[i];
        }

        static {
            VALUES = (CombatReturnStrategy[])Arrays.stream(CombatReturnStrategy.values()).sorted(Comparator.comparingInt(CombatReturnStrategy::getId)).toArray(CombatReturnStrategy[]::new);
        }
    }

    public static enum RestingState {
        NONE,
        LYING,
        BELLY;

    }
}

