/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.api.impl.DogAlterationProps;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogSwimMoveControl;
import doggytalents.common.entity.ai.nav.DogWaterBoundNavigation;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.neoforged.neoforge.common.NeoForgeMod;

public class DogSwimmingManager {
    private final Dog dog;
    private static final ResourceLocation SWIM_BOOST_ID = Util.getResource("swim_boost");
    private DogSwimMoveControl moveControl_water;
    private DogWaterBoundNavigation navigator_water;
    private boolean swimming = false;
    private static final float baseSwimSpeedModifierAdd = 2.0f;
    public static final float swimSpeedModifierAddCap = 10.0f;
    private float swimSpeedModifierAdd = 2.0f;

    public DogSwimmingManager(Dog dog) {
        this.dog = dog;
    }

    public void tickServer() {
        if (!this.dog.canSwimUnderwater()) {
            return;
        }
        if (this.moveControl_water == null || this.navigator_water == null) {
            return;
        }
        if (this.swimming) {
            this.updateSwimming(this.dog);
        } else {
            this.updateNotSwimming(this.dog);
        }
    }

    public void onPropsUpdated(DogAlterationProps props) {
        if (this.swimming) {
            this.swimming = false;
            this.stopSwimming(this.dog);
        }
        if (props.canSwimUnderwater()) {
            this.moveControl_water = new DogSwimMoveControl(this.dog);
            this.navigator_water = new DogWaterBoundNavigation(this.dog, this.dog.level());
            this.swimSpeedModifierAdd = 2.0f + Mth.clamp((float)props.bonusSwimSpeed(), (float)0.0f, (float)10.0f);
        } else {
            this.moveControl_water = null;
            this.navigator_water = null;
        }
    }

    private void updateSwimming(Dog dog) {
        if (!dog.isInWater() && dog.onGround() || !dog.isVehicle() && dog.isLowAirSupply() || dog.isDefeated() || this.hasNonControllingNonWaterBreathingPassenger(dog)) {
            this.swimming = false;
            this.stopSwimming(dog);
        }
    }

    private void updateNotSwimming(Dog dog) {
        if (dog.isInWater() && !dog.isDefeated() && this.readyToBeginSwimming(dog) && !this.hasNonControllingNonWaterBreathingPassenger(dog) && !dog.isDogSwimming()) {
            this.swimming = true;
            this.startSwimming(dog);
        }
    }

    private boolean readyToBeginSwimming(Dog dog) {
        return dog.getAirSupply() == dog.getMaxAirSupply();
    }

    private boolean hasNonControllingNonWaterBreathingPassenger(Dog dog) {
        if (!dog.isVehicle()) {
            return false;
        }
        if (dog.hasControllingPassenger()) {
            return false;
        }
        Entity passenger = dog.getFirstPassenger();
        if (passenger == null) {
            return false;
        }
        if (!(passenger instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)passenger;
        return !EntityUtil.isWaterBreathingEntity(living);
    }

    private void applySwimAttributes(Dog dog) {
        dog.setAttributeModifier((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, SWIM_BOOST_ID, (dd, u) -> new AttributeModifier(u, (double)this.swimSpeedModifierAdd, AttributeModifier.Operation.ADD_VALUE));
    }

    private void removeSwimAttributes(Dog dog) {
        dog.removeAttributeModifier((Holder<Attribute>)NeoForgeMod.SWIM_SPEED, SWIM_BOOST_ID);
    }

    private void startSwimming(Dog dog) {
        dog.setJumping(false);
        dog.setNavigation((PathNavigation)this.navigator_water);
        dog.setMoveControl(this.moveControl_water);
        if (dog.isInSittingPose()) {
            dog.setInSittingPose(false);
        }
        this.applySwimAttributes(dog);
        dog.setDogSwimming(true);
    }

    private void stopSwimming(Dog dog) {
        dog.resetMoveControl();
        dog.resetNavigation();
        this.removeSwimAttributes(dog);
        dog.setDogSwimming(false);
    }
}

