/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.DoggyTags;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.network.packet.ParticlePackets;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class WhitelistFoodHandler
implements IDogFoodHandler {
    @Override
    public boolean isFood(ItemStack stackIn) {
        if (stackIn.getFoodProperties(null) == null) {
            return false;
        }
        return this.isWhiteListFood(stackIn) && !this.isBlackListFood(stackIn);
    }

    @Override
    public boolean canConsume(AbstractDog dogIn, ItemStack stackIn, @Nullable Entity entityIn) {
        return this.isFood(stackIn);
    }

    @Override
    public InteractionResult consume(AbstractDog dog, ItemStack stack, @Nullable Entity entityIn) {
        if (dog.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (dog.canStillEat()) {
            if (!dog.level().isClientSide) {
                Item item = stack.getItem();
                FoodProperties props = stack.getFoodProperties((LivingEntity)dog);
                if (props == null) {
                    return InteractionResult.FAIL;
                }
                int heal = Mth.floor((double)((double)props.nutrition() * 2.5));
                dog.addHunger(heal);
                dog.consumeItemFromStack(entityIn, stack);
                if (dog.level() instanceof ServerLevel) {
                    ParticlePackets.DogEatingParticlePacket.sendDogEatingParticlePacketToNearby(dog, new ItemStack((ItemLike)item));
                }
                dog.playSound(SoundEvents.GENERIC_EAT, dog.getSoundVolume(), (dog.getRandom().nextFloat() - dog.getRandom().nextFloat()) * 0.2f + 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean isWhiteListFood(ItemStack stack) {
        return stack.is(DoggyTags.WHITELIST_FOOD);
    }

    private boolean isBlackListFood(ItemStack stack) {
        Item item = stack.getItem();
        return item == Items.ROTTEN_FLESH;
    }
}

