/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import java.util.EnumSet;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;

public class DogHungryGoal
extends Goal {
    private final Dog dog;
    private final Level world;
    private final double followSpeed;
    private final float stopDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private int tickTillSearchForTp = 0;
    private float oldWaterCost;
    private int looktime;
    private int remindtime;

    public DogHungryGoal(Dog dog, double speedIn, float minDistIn) {
        this.dog = dog;
        this.world = dog.level();
        this.followSpeed = speedIn;
        this.stopDist = 3.0f;
        this.looktime = 0;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.remindtime > 0) {
            this.remindtime = !this.dog.isLowHunger() ? 0 : --this.remindtime;
        }
        if (!this.dog.isDoingFine()) {
            return false;
        }
        LivingEntity owner = this.dog.getOwner();
        if (owner == null || this.remindtime > 0) {
            return false;
        }
        if (!this.dog.isLowHunger()) {
            return false;
        }
        if (owner.isSpectator()) {
            return false;
        }
        if (this.dog.isInSittingPose()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean canContinueToUse() {
        return this.looktime <= 60 && this.dog.isLowHunger();
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.dog.getPathfindingMalus(PathType.WATER);
        this.dog.setDogFollowingSomeone(true);
        this.looktime = 0;
    }

    public void stop() {
        double distanceToOwner;
        if (this.dog.hasBone() && (distanceToOwner = this.owner.distanceToSqr((Entity)this.dog)) <= (double)(this.stopDist * this.stopDist)) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.spawnAtLocation(fetchItem, 0.0f);
            this.dog.setBoneVariant(ItemStack.EMPTY);
        }
        this.owner = null;
        this.dog.getNavigation().stop();
        this.dog.setDogFollowingSomeone(false);
        this.dog.setBegging(false);
        this.remindtime = 200 + this.dog.getRandom().nextInt(40) * 20;
        this.dog.dogSoundManager.interuptPlaying();
    }

    public void tick() {
        if (this.dog.distanceToSqr((Entity)this.owner) > (double)this.stopDist) {
            this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.followSpeed, 144.0, true, --this.tickTillSearchForTp <= 0, 400.0, this.dog.getMaxFallDistance());
                if (this.tickTillSearchForTp <= 0) {
                    this.tickTillSearchForTp = 10;
                }
            }
        } else {
            this.dog.setBegging(true);
            if (this.looktime == 0) {
                this.owner.sendSystemMessage((Component)Component.translatable((String)("dog.msg.low_hunger." + this.dog.getRandom().nextInt(5)), (Object[])new Object[]{this.dog.getName()}));
                SoundEvent sound = this.dog.dogMood.getWhineAttentionSound();
                this.dog.dogSoundManager.playInterruptible(sound, this.dog.getSoundVolume(), this.dog.getVoicePitch());
            }
            this.dog.getLookControl().setLookAt((Entity)this.owner);
            ++this.looktime;
        }
    }
}

