/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.nav;

import doggytalents.common.entity.Dog;
import doggytalents.common.talent.FlyingFurballTalent;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;

public class DogFlyingMoveControl
extends FlyingMoveControl {
    private Dog dog;
    private FlyingFurballTalent talentInst;

    public DogFlyingMoveControl(Dog dog, FlyingFurballTalent talentInst) {
        super((Mob)dog, 10, false);
        this.dog = dog;
        this.talentInst = talentInst;
    }

    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            double dz;
            double dy;
            this.operation = MoveControl.Operation.WAIT;
            double dx = this.wantedX - this.dog.getX();
            double l_sqr = dx * dx + (dy = this.wantedY - this.dog.getY()) * dy + (dz = this.wantedZ - this.dog.getZ()) * dz;
            if (l_sqr < 2.500000277905201E-7) {
                this.dog.setYya(0.0f);
                this.dog.setZza(0.0f);
                this.dog.setNoGravity(false);
                return;
            }
            double l_xz = Math.sqrt(dx * dx + dz * dz);
            float speed = 0.0f;
            if (this.dog.onGround()) {
                speed = (float)(this.speedModifier * this.dog.getAttributeValue((Holder<Attribute>)Attributes.MOVEMENT_SPEED));
            } else {
                speed = (float)(this.speedModifier * this.dog.getAttributeValue((Holder<Attribute>)Attributes.FLYING_SPEED));
                if (this.dog.isDefeated()) {
                    speed = 0.2f;
                }
            }
            this.dog.setSpeed(speed);
            float dy_abs = Mth.abs((float)((float)dy));
            if ((double)dy_abs / l_xz >= 6.0) {
                this.dog.yya = (float)Mth.sign((double)dy) * speed;
                this.dog.zza = 0.0f;
                return;
            }
            if (dy_abs >= 0.1f) {
                this.dog.setNoGravity(true);
            }
            float wantedYRot = (float)(Mth.atan2((double)dz, (double)dx) * 57.2957763671875) - 90.0f;
            float approachingYRot = this.rotlerp(this.dog.getYRot(), wantedYRot, 90.0f);
            this.dog.setYRot(approachingYRot);
            if (Math.abs(dy) > (double)1.0E-5f || Math.abs(l_xz) > (double)1.0E-5f) {
                float wantedXRot = (float)(-(Mth.atan2((double)dy, (double)l_xz) * 57.2957763671875));
                float approachingXRot = this.rotlerp(this.dog.getXRot(), wantedXRot, this.dog.getMaxHeadXRot());
                this.dog.setXRot(approachingXRot);
                float zAngleMod = Mth.cos((float)(this.dog.getXRot() * ((float)Math.PI / 180)));
                float yAngleMod = Mth.sin((float)(this.dog.getXRot() * ((float)Math.PI / 180)));
                this.dog.zza = zAngleMod * speed;
                this.dog.yya = -yAngleMod * speed;
            }
        } else {
            boolean hoversInPlace = false;
            if (!hoversInPlace) {
                this.dog.setNoGravity(false);
            }
            this.dog.setSpeed(0.0f);
            this.dog.setXxa(0.0f);
            this.dog.setYya(0.0f);
            this.dog.setZza(0.0f);
        }
    }
}

