/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.api.feature.DogMode;
import doggytalents.api.inferface.IThrowableItem;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.util.DogUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.PathType;

public class DogFetchAction
extends TriggerableAction {
    @Nonnull
    private final ItemEntity fetchTarget;
    @Nonnull
    private final LivingEntity owner;
    private final int MIN_DIST = 2;
    private final int MAX_DIST = 32;
    private boolean isBringingBack = false;
    private int tickTillPathRecalc = 1;
    private float oldWaterCost;
    private double oldRangeSense = 16.0;
    private boolean initFetch;

    public DogFetchAction(Dog dog, @Nonnull LivingEntity owner, @Nonnull ItemEntity fetchTarget) {
        super(dog, true, true);
        this.fetchTarget = fetchTarget;
        this.owner = owner;
    }

    @Override
    public void onStart() {
        if (this.dog.hasBone() || this.dog.getMode() != DogMode.DOCILE) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        this.tickTillPathRecalc = 3;
        this.isBringingBack = false;
        this.initFetch();
    }

    @Override
    public void tick() {
        if (!this.owner.isAlive() || this.owner.isSpectator()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (!this.isBringingBack) {
            if (!this.canFetchStack(this.fetchTarget)) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.hasBone()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        } else if (!this.dog.hasBone()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (--this.tickTillPathRecalc < 0) {
            this.tickTillPathRecalc = 20;
        }
        if (!this.isBringingBack) {
            this.goGetFetchItem();
        } else if (this.bringBackFetchItem()) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
    }

    @Override
    public void onStop() {
        this.dropFetchItem();
        this.finishFetch();
    }

    private void initFetch() {
        this.tickTillPathRecalc = 1;
        this.oldWaterCost = this.dog.getPathfindingMalus(PathType.WATER);
        this.dog.setDogFollowingSomeone(true);
        AttributeInstance attrib = this.dog.getAttribute(Attributes.FOLLOW_RANGE);
        if (attrib == null) {
            return;
        }
        this.oldRangeSense = attrib.getValue();
        attrib.setBaseValue((double)this.MAX_DIST);
        this.initFetch = true;
    }

    private void finishFetch() {
        if (!this.initFetch) {
            return;
        }
        this.dog.getNavigation().stop();
        this.dog.setDogFollowingSomeone(false);
        AttributeInstance attrib = this.dog.getAttribute(Attributes.FOLLOW_RANGE);
        if (attrib == null) {
            return;
        }
        attrib.setBaseValue(this.oldRangeSense);
    }

    private void goGetFetchItem() {
        this.dog.getLookControl().setLookAt((Entity)this.fetchTarget, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (this.tickTillPathRecalc <= 0) {
            this.dog.getNavigation().moveTo((Entity)this.fetchTarget, 1.0);
        }
        this.checkAndGetFetchItem();
    }

    private boolean bringBackFetchItem() {
        this.dog.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.dog.getMaxHeadXRot());
        if (this.dog.distanceToSqr((Entity)this.owner) <= 4.0) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return true;
        }
        if (this.tickTillPathRecalc > 0) {
            return false;
        }
        DogUtil.moveToOwnerOrTeleportIfFarAway(this.dog, this.owner, this.dog.getUrgentSpeedModifier(), 400.0, false, false, 400.0, this.dog.getMaxFallDistance());
        return false;
    }

    private boolean checkAndGetFetchItem() {
        if (!this.dog.hasBone() && this.dog.distanceToSqr((Entity)this.fetchTarget) < (double)(this.MIN_DIST * this.MIN_DIST) && this.fetchTarget.isAlive() && !this.fetchTarget.hasPickUpDelay()) {
            this.dog.setBoneVariant(this.fetchTarget.getItem());
            this.fetchTarget.discard();
            this.isBringingBack = true;
            this.tickTillPathRecalc = 1;
            this.dog.getNavigation().stop();
            return true;
        }
        return false;
    }

    private void dropFetchItem() {
        if (this.dog.hasBone()) {
            IThrowableItem throwableItem = this.dog.getThrowableItem();
            ItemStack fetchItem = throwableItem != null ? throwableItem.getReturnStack(this.dog.getBoneVariant()) : this.dog.getBoneVariant();
            this.dog.spawnAtLocation(fetchItem, 0.0f);
            this.dog.setBoneVariant(ItemStack.EMPTY);
        }
    }

    private boolean canFetchStack(ItemEntity e) {
        if (!e.isAlive() || e.isInvisible()) {
            return false;
        }
        double follow_range = this.dog.getAttributeValue((Holder<Attribute>)Attributes.FOLLOW_RANGE);
        if (e.distanceToSqr((Entity)this.dog) > follow_range * follow_range) {
            return false;
        }
        return e.getItem().getItem() instanceof IThrowableItem;
    }
}

