/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.api.anim.DogAnimation;
import doggytalents.api.feature.FoodHandler;
import doggytalents.api.inferface.IDogFoodHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.item.IDogEddible;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.NetworkUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

public class DogFoodProjectile
extends ThrowableProjectile
implements IEntityWithComplexSpawn {
    private ItemStack foodStack = ItemStack.EMPTY;
    private int tickTillScan = 0;

    public DogFoodProjectile(EntityType<? extends ThrowableProjectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public DogFoodProjectile(Level worldIn, LivingEntity livingEntityIn) {
        super(DoggyEntityTypes.DOG_FOOD_PROJ.get(), livingEntityIn, worldIn);
    }

    protected void onHit(HitResult hitResult) {
        if (!this.level().isClientSide && !this.foodStack.isEmpty()) {
            this.spawnAtLocation(this.foodStack);
        }
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.scanDogAroundAndTrigger();
        }
    }

    private void scanDogAroundAndTrigger() {
        if (this.tickTillScan > 0) {
            --this.tickTillScan;
            return;
        }
        if (this.getOwner() == null) {
            return;
        }
        Vec3 pos = this.position();
        AABB aabb = new AABB(pos.add(-5.0, -5.0, -5.0), pos.add(5.0, 0.0, 5.0));
        Vec3 moveVec = this.getDeltaMovement();
        Vec3 moveVecXZ = new Vec3(moveVec.x, 0.0, moveVec.z).normalize();
        if (moveVecXZ.length() < 1.0) {
            return;
        }
        List dogs = this.level().getEntitiesOfClass(Dog.class, aabb, filter_dog -> this.isValidDog((Dog)filter_dog, moveVecXZ));
        if (dogs.isEmpty()) {
            return;
        }
        this.tickTillScan = 3;
        Dog nearestDog = (Dog)dogs.get(0);
        double minDist = nearestDog.distanceToSqr((Entity)this);
        for (Dog dog : dogs) {
            double dist = dog.distanceToSqr((Entity)this);
            if (!(dist < minDist)) continue;
            nearestDog = dog;
            minDist = dist;
        }
        double dy = this.position().y - nearestDog.position().y;
        double minDistXZ = new Vec3(this.position().x - nearestDog.position().x, 0.0, this.position().z - nearestDog.position().z).lengthSqr();
        if (minDist < 4.0) {
            this.feedDog(nearestDog);
        } else if (dy >= 1.5 && minDistXZ >= 10.0) {
            nearestDog.triggerAction(new DogJumpAndEatAction(nearestDog, this));
        }
    }

    private boolean isValidDog(Dog dog, Vec3 lookVecXZ) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (dog.isOrderedToSit()) {
            return false;
        }
        if (dog.getOwner() != this.getOwner()) {
            return false;
        }
        if (!this.checkIfDogCanCatch(dog, lookVecXZ) && dog.distanceToSqr((Entity)this) >= 4.0) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        return this.dogCanStillEatItem(dog, this.foodStack);
    }

    private boolean checkIfDogCanCatch(Dog dog, Vec3 lookVecXZ) {
        Vec3 dogPosXZ = new Vec3(dog.position().x, 0.0, dog.position().z);
        Vec3 posXZ = new Vec3(this.position().x, 0.0, this.position().z);
        double dist = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(dogPosXZ, posXZ, lookVecXZ);
        if (dist < 0.0) {
            return false;
        }
        return dist < 2.25;
    }

    private boolean dogCanStillEatItem(Dog dog, ItemStack stack) {
        IDogEddible eddible;
        Optional<IDogFoodHandler> handlerOptional = FoodHandler.getMatch(dog, stack, null);
        if (!handlerOptional.isPresent()) {
            return false;
        }
        IDogFoodHandler handler = handlerOptional.get();
        if (handler instanceof IDogEddible && (eddible = (IDogEddible)handler).alwaysEatWhenDogConsume(dog)) {
            return true;
        }
        return dog.getDogHunger() < dog.getMaxHunger();
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        boolean hasStack = !this.foodStack.isEmpty();
        buffer.writeBoolean(hasStack);
        if (hasStack) {
            NetworkUtil.writeItemToBuf((FriendlyByteBuf)buffer, this.foodStack);
        }
    }

    public void readSpawnData(RegistryFriendlyByteBuf buffer) {
        boolean hasStack = buffer.readBoolean();
        if (hasStack) {
            this.foodStack = NetworkUtil.readItemFromBuf((FriendlyByteBuf)buffer);
        }
    }

    public ItemStack getDogFoodStack() {
        return this.foodStack;
    }

    public void setDogFoodStack(ItemStack stack) {
        this.foodStack = stack;
    }

    public boolean feedDog(Dog dog) {
        if (!this.isAlive()) {
            return false;
        }
        ItemStack stack = this.getDogFoodStack();
        if (stack.isEmpty()) {
            return false;
        }
        Optional<IDogFoodHandler> handlerOptional = FoodHandler.getMatch(dog, stack, null);
        if (!handlerOptional.isPresent()) {
            return false;
        }
        IDogFoodHandler handler = handlerOptional.get();
        handler.consume(dog, stack, null);
        if (stack.isEmpty()) {
            this.discard();
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder b) {
    }

    public static class DogJumpAndEatAction
    extends TriggerableAction {
        private DogFoodProjectile target;
        private int tickTillJump;
        private int tickTillConsumeItem;
        private int stopTick;
        private boolean consumed = false;

        public DogJumpAndEatAction(Dog dog, DogFoodProjectile target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            this.stopTick = this.dog.tickCount + DogAnimation.BACKFLIP.getLengthTicks();
            this.dog.setAnim(DogAnimation.BACKFLIP);
            this.tickTillJump = 3;
            this.tickTillConsumeItem = 5;
        }

        @Override
        public void tick() {
            if (this.dog.getAnim() != DogAnimation.BACKFLIP) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.tickCount >= this.stopTick) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (--this.tickTillJump == 0) {
                this.dog.getJumpControl().jump();
            }
            if (!this.consumed && --this.tickTillConsumeItem <= 0) {
                this.tryConsumeItem();
            }
        }

        public void tryConsumeItem() {
            if (!this.target.isAlive()) {
                return;
            }
            if (this.dog.distanceToSqr((Entity)this.target) > 4.0) {
                return;
            }
            this.target.feedDog(this.dog);
            this.consumed = true;
        }

        @Override
        public void onStop() {
            this.dog.getNavigation().stop();
            if (this.dog.getAnim() == DogAnimation.BACKFLIP) {
                this.dog.setAnim(DogAnimation.NONE);
            }
        }
    }
}

