/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.misc;

import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyTalents;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.EntityUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class DogThrownTrident
extends AbstractArrow {
    private static final int loyalty_amount = 3;
    private boolean isReturning;
    private boolean playedClientReturnSound;
    private int timeOutTick = 0;

    public DogThrownTrident(EntityType<DogThrownTrident> p_37561_, Level p_37562_) {
        super(p_37561_, p_37562_);
    }

    public DogThrownTrident(Dog dog, ItemStack trident_stack) {
        super(DoggyEntityTypes.DOG_TRIDENT_PROJ.get(), (LivingEntity)dog, dog.level(), trident_stack, null);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326249_) {
        super.defineSynchedData(p_326249_);
    }

    public void tick() {
        Optional<Dog> return_owner_optional = this.getDogOwnerForReturn();
        if (!this.level().isClientSide && this.doDogTridentInvalidateSelf(return_owner_optional)) {
            return;
        }
        if (return_owner_optional.isPresent()) {
            Dog return_owner = return_owner_optional.get();
            this.updateReturning(return_owner);
            if (this.isReturning) {
                this.returnToDog(return_owner);
            }
        }
        super.tick();
    }

    private void updateReturning(Dog return_dog) {
        if (this.isReturning) {
            return;
        }
        if (this.inGroundTime > 1 || this.isNoPhysics()) {
            this.switchToReturnToDog();
            return;
        }
    }

    private void returnToDog(Dog return_dog) {
        this.setNoPhysics(true);
        Vec3 pos = this.position();
        Vec3 dog_pos = return_dog.getEyePosition();
        Vec3 v_self_dog = dog_pos.subtract(pos);
        Vec3 current_move_vec = this.getDeltaMovement();
        double l_current_move_vec = current_move_vec.length();
        float max_speed = 1.2f;
        double acceleration = 0.15000000000000002;
        double return_speed = Mth.clamp((double)(l_current_move_vec + 0.15000000000000002), (double)0.0, (double)1.2f);
        Vec3 return_vec = v_self_dog.normalize().scale(return_speed);
        this.setDeltaMovement(return_vec);
        if (!this.playedClientReturnSound) {
            this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
            this.playedClientReturnSound = true;
        }
    }

    private void switchToReturnToDog() {
        this.isReturning = true;
    }

    private boolean doDogTridentInvalidateSelf(Optional<Dog> return_dog_optional) {
        ++this.timeOutTick;
        if (this.timeOutTick > DogThrownTrident.getDogTridentTimeout()) {
            this.discard();
            return true;
        }
        if (!return_dog_optional.isPresent()) {
            this.discard();
            return true;
        }
        Dog return_dog = return_dog_optional.get();
        if (this.isReturning && return_dog.distanceToSqr((Entity)this) <= 4.0) {
            this.discard();
            return true;
        }
        return false;
    }

    public Optional<Dog> getDogOwnerForReturn() {
        Entity owner = this.getOwner();
        if (!(owner instanceof Dog)) {
            return Optional.empty();
        }
        Dog dog = (Dog)owner;
        if (!dog.isDoingFine()) {
            return Optional.empty();
        }
        if (dog.distanceToSqr((Entity)this) > 900.0) {
            return Optional.empty();
        }
        if (dog.isInSittingPose()) {
            return Optional.empty();
        }
        return Optional.of(dog);
    }

    public boolean isFoil() {
        return true;
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 p_37575_, Vec3 p_37576_) {
        return this.isReturning ? null : super.findHitEntity(p_37575_, p_37576_);
    }

    protected void onHitEntity(EntityHitResult hit_result) {
        float sound_volume;
        Entity target = hit_result.getEntity();
        boolean hurt_success = this.hurtDogTridentTarget(target);
        boolean did_lightning = this.maySummonLightningBolt(target);
        this.switchToReturnToDog();
        this.setDeltaMovement(Vec3.ZERO);
        Object play_sound = null;
        play_sound = did_lightning ? null : (hurt_success ? SoundEvents.TRIDENT_HIT : null);
        float f = sound_volume = did_lightning ? 5.0f : 1.0f;
        if (play_sound != null) {
            this.playSound((SoundEvent)play_sound, sound_volume, 1.0f);
        }
    }

    private boolean hurtDogTridentTarget(Entity target) {
        boolean result;
        float damage = 8.0f;
        Entity owner = this.getOwner();
        DogThrownTrident indirect_entity_source = owner == null ? this : owner;
        DamageSource trident_source = this.damageSources().arrow((AbstractArrow)this, (Entity)indirect_entity_source);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)trident_source, (float)damage);
        }
        if (this.isOnFire()) {
            EntityUtil.setSecondsOnFire(target, 5);
        }
        if (!(result = target.hurt(trident_source, damage))) {
            return false;
        }
        this.doDogTridentEnchantDamageEffects(owner, target, trident_source);
        this.killCreeperIfCreeperSweeper(target);
        return true;
    }

    private void doDogTridentEnchantDamageEffects(Entity owner, Entity target, DamageSource source) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel1 = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)target, (DamageSource)source, (ItemStack)this.getWeaponItem());
        }
        if (target instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)target;
            this.doKnockback(livingentity, source);
            this.doPostHurtEffects(livingentity);
        }
    }

    private void killCreeperIfCreeperSweeper(Entity target) {
        Entity owner = this.getOwner();
        if (!(owner instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)owner;
        if (dog.getDogLevel(DoggyTalents.CREEPER_SWEEPER) < 5) {
            return;
        }
        if (!(target instanceof Creeper)) {
            return;
        }
        Creeper creeper = (Creeper)target;
        creeper.setHealth(0.0f);
        creeper.die(dog.damageSources().mobAttack((LivingEntity)dog));
    }

    public boolean isChanneling() {
        Optional channel = this.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(Enchantments.CHANNELING);
        if (!channel.isPresent()) {
            return false;
        }
        return this.getPickupItemStackOrigin().getEnchantmentLevel((Holder)channel.get()) > 0;
    }

    private boolean maySummonLightningBolt(Entity target) {
        if (!(this.level() instanceof ServerLevel)) {
            return false;
        }
        if (!this.level().isThundering()) {
            return false;
        }
        if (!this.isChanneling()) {
            return false;
        }
        BlockPos target_b0 = target.blockPosition();
        if (!this.level().canSeeSky(target_b0)) {
            return false;
        }
        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
        if (lightningbolt == null) {
            return false;
        }
        lightningbolt.moveTo(Vec3.atBottomCenterOf((Vec3i)target_b0));
        lightningbolt.setCause(null);
        this.level().addFreshEntity((Entity)lightningbolt);
        return true;
    }

    public static int getDogTridentTimeout() {
        return 50;
    }

    protected boolean tryPickup(Player player) {
        return false;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.TRIDENT);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public boolean shouldBeSaved() {
        return false;
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double p_37588_, double p_37589_, double p_37590_) {
        return true;
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }
}

