/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class DoggyToolsItemHandler
extends ItemStackHandler {
    public DoggyToolsItemHandler() {
        super(5);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider prov) {
        ListTag itemsList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            itemsList.add((Object)stack.save(prov, (Tag)itemTag));
        }
        CompoundTag compound = new CompoundTag();
        compound.put("item_list", (Tag)itemsList);
        return compound;
    }

    public void deserializeNBT(HolderLookup.Provider prov, CompoundTag compound) {
        if (!compound.contains("item_list", 9)) {
            return;
        }
        ListTag tagList = compound.getList("item_list", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.getCompound(i);
            int slot = itemTag.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            ItemStack.parse((HolderLookup.Provider)prov, (Tag)itemTag).ifPresent(stack -> this.stacks.set(slot, stack));
        }
        this.onLoad();
    }

    public boolean hasStackRef(ItemStack stack) {
        for (ItemStack s : this.stacks) {
            if (stack != s) continue;
            return true;
        }
        return false;
    }
}

