/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.item.DogEddibleItem;
import java.util.function.Function;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class DogEddibleBowlFoodItem
extends DogEddibleItem {
    public DogEddibleBowlFoodItem(Item.Properties itemProps, FoodProperties foodProps) {
        super(itemProps.craftRemainder(Items.BOWL), foodProps);
    }

    public DogEddibleBowlFoodItem(Item.Properties itemProps, Function<FoodProperties.Builder, FoodProperties.Builder> propsCreator) {
        this(itemProps, propsCreator.apply(new FoodProperties.Builder()).build());
    }

    public DogEddibleBowlFoodItem(Item.Properties itemProps, Function<Item.Properties, Item.Properties> itemPropsCreator, Function<FoodProperties.Builder, FoodProperties.Builder> propsCreator) {
        this(itemPropsCreator.apply(itemProps), propsCreator.apply(new FoodProperties.Builder()).build());
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        boolean creativeUse;
        ItemStack returnStack = super.finishUsingItem(stack, level, user);
        boolean bl = creativeUse = user instanceof Player && ((Player)user).getAbilities().instabuild;
        if (creativeUse) {
            return returnStack;
        }
        if (returnStack.isEmpty()) {
            return new ItemStack((ItemLike)Items.BOWL);
        }
        if (!(user instanceof Player)) {
            return returnStack;
        }
        Player player = (Player)user;
        if (player.level().isClientSide) {
            return returnStack;
        }
        ItemStack bonusReturnStack = new ItemStack((ItemLike)Items.BOWL);
        Inventory inv = player.getInventory();
        int freeSlot = inv.getFreeSlot();
        if (freeSlot >= 0) {
            inv.add(bonusReturnStack);
        } else {
            player.spawnAtLocation(bonusReturnStack);
        }
        return returnStack;
    }

    @Override
    public ItemStack getReturnStackAfterDogConsume(ItemStack useStack, AbstractDog dog) {
        return new ItemStack((ItemLike)Items.BOWL);
    }
}

