/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.network.DTNNetworkHandler;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogDeTrainData;
import doggytalents.common.util.NetworkUtil;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class DogDeTrainPacket
extends DogPacket<DogDeTrainData> {
    @Override
    public void encode(DogDeTrainData data, FriendlyByteBuf buf) {
        super.encode(data, buf);
        NetworkUtil.writeTalentToBuf(buf, data.talent);
    }

    @Override
    public DogDeTrainData decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        Talent talent = NetworkUtil.readTalentFromBuf(buf);
        return new DogDeTrainData(entityId, talent);
    }

    @Override
    public void handleDog(Dog dog, DogDeTrainData data, Supplier<DTNNetworkHandler.NetworkEvent.Context> ctx) {
        boolean talent_allow_detrain;
        ServerPlayer sender = ctx.get().getSender();
        ItemStack stack = sender.getMainHandItem();
        if (stack.getItem() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.getCooldowns().isOnCooldown(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.getOwnerUUID();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.getUUID())) {
            return;
        }
        Talent talent = data.talent;
        Optional<TalentInstance> talent_inst_optional = dog.getTalent(talent);
        if (!talent_inst_optional.isPresent()) {
            return;
        }
        TalentInstance talent_inst = talent_inst_optional.get();
        int dog_level = talent_inst.level();
        if (dog_level <= 0) {
            return;
        }
        boolean bl = talent_allow_detrain = sender.hasPermissions(4) || talent_inst.allowDetrain(dog);
        if (!talent_allow_detrain) {
            return;
        }
        int xp_cost = talent.getDeTrainXPCost(dog_level);
        if (sender.experienceLevel < xp_cost) {
            return;
        }
        dog.setTalentLevel(talent, 0);
        dog.clearTriggerableAction();
        sender.getCooldowns().addCooldown(DoggyItems.AMNESIA_BONE.get(), 20);
        sender.giveExperienceLevels(-xp_cost);
    }
}

