/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.entity.Dog;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class GatePasserTalent
extends TalentInstance {
    private boolean allowPassingGate = true;
    private int openDoorCooldown = 0;
    private int keepOpenDoorTick = 0;
    private Optional<BlockPos> currentOpenedDoor = Optional.empty();
    private int navTickLeftTillCanOpenDoor = 20;
    private boolean canApplyBeginNavCooldown = true;

    public GatePasserTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void tick(AbstractDog dog) {
        if (dog.level().isClientSide) {
            return;
        }
        if (!this.allowPassingGate) {
            if (this.currentOpenedDoor.isPresent()) {
                this.currentOpenedDoor = Optional.empty();
            }
            return;
        }
        this.updateNavTickLeftTillCanOpenDoor(dog);
        if (this.openDoorCooldown > 0) {
            --this.openDoorCooldown;
        }
        if (this.keepOpenDoorTick > 0) {
            --this.keepOpenDoorTick;
        }
        if (this.currentOpenedDoor.isPresent()) {
            this.invalidateAndMayCloseOpenedDoor(dog);
        } else {
            this.checkPathForDoorAndTryOpen(dog);
        }
    }

    private void updateNavTickLeftTillCanOpenDoor(AbstractDog dog) {
        PathNavigation nav = dog.getNavigation();
        if (this.canApplyBeginNavCooldown && nav.isDone()) {
            this.navTickLeftTillCanOpenDoor = 20;
            this.canApplyBeginNavCooldown = false;
            return;
        }
        --this.navTickLeftTillCanOpenDoor;
        if (this.navTickLeftTillCanOpenDoor < 0) {
            this.navTickLeftTillCanOpenDoor = 0;
        }
    }

    private List<Dog> getNearbyGatePasser(AbstractDog dog) {
        Predicate<Dog> is_passer_and_not_dog = filter_dog -> filter_dog != dog && filter_dog.isDoingFine() && !filter_dog.getNavigation().isDone() && filter_dog.getDogLevel(DoggyTalents.GATE_PASSER) > 0;
        List passers = dog.level().getEntitiesOfClass(Dog.class, dog.getBoundingBox().inflate(1.0), is_passer_and_not_dog);
        return passers;
    }

    private void checkPathForDoorAndTryOpen(AbstractDog dog) {
        if (this.openDoorCooldown > 0) {
            return;
        }
        if (this.navTickLeftTillCanOpenDoor > 0) {
            return;
        }
        PathNavigation nav = dog.getNavigation();
        if (nav.isDone()) {
            return;
        }
        Path path = nav.getPath();
        if (path == null || path.isDone()) {
            return;
        }
        BlockPos doorPos = null;
        BlockState doorState = null;
        Block doorBlock = null;
        Node prevNode = path.getPreviousNode();
        if (prevNode != null) {
            BlockPos prevPos = prevNode.asBlockPos();
            BlockState state = dog.level().getBlockState(prevPos);
            Block block = state.getBlock();
            if (this.isValidDoorBlock(block) && !this.isDoorOpen(state, prevPos)) {
                doorState = state;
                doorPos = prevPos;
                doorBlock = block;
            }
        }
        Node nextNode = path.getNextNode();
        if (doorState == null) {
            BlockPos nextPos = nextNode.asBlockPos();
            BlockState state = dog.level().getBlockState(nextPos);
            Block block = state.getBlock();
            if (this.isValidDoorBlock(block) && !this.isDoorOpen(state, nextPos)) {
                doorState = state;
                doorPos = nextPos;
                doorBlock = block;
            }
        }
        if (doorState == null || doorPos == null || doorBlock == null) {
            return;
        }
        this.currentOpenedDoor = Optional.of(doorPos);
        this.setOpenDoor(dog, doorState, doorPos, true);
        this.canApplyBeginNavCooldown = true;
        this.keepOpenDoorTick = 5;
    }

    private void invalidateAndMayCloseOpenedDoor(AbstractDog dog) {
        if (this.keepOpenDoorTick > 0) {
            return;
        }
        if (!this.currentOpenedDoor.isPresent()) {
            return;
        }
        BlockPos currentOpened = this.currentOpenedDoor.get();
        if (dog.distanceToSqr(Vec3.atBottomCenterOf((Vec3i)currentOpened)) > 16.0) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        BlockState state = dog.level().getBlockState(currentOpened);
        Block block = state.getBlock();
        if (!this.isValidDoorBlock(block)) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        if (!this.isDoorOpen(state, currentOpened)) {
            this.currentOpenedDoor = Optional.empty();
            return;
        }
        if (this.isDogStillPassingThruDoor(dog, currentOpened)) {
            return;
        }
        if (this.mayDelegateClosingDoorToStillPassingDog(dog, currentOpened)) {
            return;
        }
        this.setOpenDoor(dog, state, currentOpened, false);
        this.openDoorCooldown = 5;
        this.currentOpenedDoor = Optional.empty();
    }

    private boolean isDogStillPassingThruDoor(AbstractDog dog, BlockPos doorPos) {
        PathNavigation nav = dog.getNavigation();
        if (nav.isDone()) {
            return false;
        }
        Path path = nav.getPath();
        if (path == null || path.isDone()) {
            return false;
        }
        Node nextNode = path.getNextNode();
        if (nextNode.asBlockPos().equals((Object)doorPos)) {
            return true;
        }
        Node prevNextNode = path.getPreviousNode();
        return prevNextNode != null && prevNextNode.asBlockPos().equals((Object)doorPos);
    }

    private boolean mayDelegateClosingDoorToStillPassingDog(AbstractDog delegator, BlockPos doorPos) {
        List<Dog> passers = this.getNearbyGatePasser(delegator);
        if (passers.isEmpty()) {
            return false;
        }
        Dog delegate = null;
        GatePasserTalent delegateInst = null;
        for (Dog dog : passers) {
            TalentInstance inst;
            Optional instOptional;
            if (!dog.isDoingFine() || !this.isDogStillPassingThruDoor(dog, doorPos) || !(instOptional = dog.getTalent(DoggyTalents.GATE_PASSER)).isPresent() || !((inst = (TalentInstance)instOptional.get()) instanceof GatePasserTalent)) continue;
            GatePasserTalent gate = (GatePasserTalent)inst;
            delegate = dog;
            delegateInst = gate;
            break;
        }
        if (delegate == null || delegateInst == null) {
            return false;
        }
        delegateInst.currentOpenedDoor = Optional.of(doorPos);
        this.currentOpenedDoor = Optional.empty();
        this.openDoorCooldown = 5;
        return true;
    }

    private boolean isValidDoorBlock(Block block) {
        DoorBlock door;
        return block instanceof DoorBlock && (door = (DoorBlock)block).type().canOpenByHand() || block instanceof FenceGateBlock;
    }

    private void setOpenDoor(AbstractDog dog, BlockState state, BlockPos pos, boolean open) {
        Block block = state.getBlock();
        if (block instanceof DoorBlock) {
            DoorBlock door = (DoorBlock)block;
            door.setOpen((Entity)dog, dog.level(), state, pos, open);
            return;
        }
        if (block instanceof FenceGateBlock) {
            FenceGateBlock fenceGate = (FenceGateBlock)block;
            this.setOpenFenceGate(dog.level(), state, pos, dog, fenceGate, open);
            return;
        }
    }

    private void setOpenFenceGate(Level level, BlockState state, BlockPos pos, AbstractDog dog, FenceGateBlock fence, boolean open) {
        boolean open0 = (Boolean)state.getValue((Property)FenceGateBlock.OPEN);
        boolean hasUpdate = false;
        if (!open && open0) {
            state = (BlockState)state.setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(false));
            level.setBlock(pos, state, 10);
            hasUpdate = true;
        }
        if (open && !open0) {
            Direction direction = dog.getDirection();
            if (state.getValue((Property)FenceGateBlock.FACING) == direction.getOpposite()) {
                state = (BlockState)state.setValue((Property)FenceGateBlock.FACING, (Comparable)direction);
            }
            state = (BlockState)state.setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, state, 10);
            hasUpdate = true;
        }
        if (hasUpdate) {
            boolean still_open = (Boolean)state.getValue((Property)FenceGateBlock.OPEN);
            level.playSound((Entity)dog, pos, still_open ? SoundEvents.FENCE_GATE_OPEN : SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 1.0f, dog.getRandom().nextFloat() * 0.1f + 0.9f);
            level.gameEvent((Entity)dog, (Holder)(still_open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        }
    }

    private boolean isDoorOpen(BlockState state, BlockPos pos) {
        Block block = state.getBlock();
        if (block instanceof DoorBlock) {
            DoorBlock door = (DoorBlock)block;
            return door.isOpen(state);
        }
        if (block instanceof FenceGateBlock) {
            FenceGateBlock fenceGate = (FenceGateBlock)block;
            return (Boolean)state.getValue((Property)FenceGateBlock.OPEN);
        }
        return false;
    }

    @Override
    public InteractionResult canDogPassGate(AbstractDog dogIn) {
        if (this.allowPassingGate) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.allowPassingGate = compound.getBoolean("DogGatePasser_allowPassingGate");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.putBoolean("DogGatePasser_allowPassingGate", this.allowPassingGate);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.GATE_PASSER_ENABLE.get()) {
            return this.allowPassingGate;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.GATE_PASSER_ENABLE.get()) {
            this.allowPassingGate = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.GATE_PASSER_ENABLE.get());
    }

    public boolean allowPassingGate() {
        return this.allowPassingGate;
    }

    public void setAllowPassingGate(boolean val) {
        this.allowPassingGate = val;
    }
}

