/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import doggytalents.DoggyTalentsNext;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class NBTUtil {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static void putUniqueId(CompoundTag compound, String key, @Nullable UUID uuid) {
        if (uuid != null) {
            compound.putUUID(key, uuid);
        }
    }

    @Nullable
    public static UUID getUniqueId(CompoundTag compound, String key) {
        if (compound.hasUUID(key)) {
            return compound.getUUID(key);
        }
        if (NBTUtil.hasOldUniqueId(compound, key)) {
            return NBTUtil.getOldUniqueId(compound, key);
        }
        return null;
    }

    public static UUID getOldUniqueId(CompoundTag compound, String key) {
        return new UUID(compound.getLong(key + "Most"), compound.getLong(key + "Least"));
    }

    public static boolean hasOldUniqueId(CompoundTag compound, String key) {
        return compound.contains(key + "Most", 99) && compound.contains(key + "Least", 99);
    }

    public static void removeOldUniqueId(CompoundTag compound, String key) {
        compound.remove(key + "Most");
        compound.remove(key + "Least");
    }

    public static void putResourceLocation(CompoundTag compound, String key, @Nullable ResourceLocation rl) {
        if (rl != null) {
            compound.putString(key, rl.toString());
        }
    }

    @Nullable
    public static ResourceLocation getResourceLocation(CompoundTag compound, String key) {
        if (compound.contains(key, 8)) {
            return ResourceLocation.tryParse((String)compound.getString(key));
        }
        return null;
    }

    public static void putVector3d(CompoundTag compound, @Nullable Vec3 vec3d) {
        if (vec3d != null) {
            compound.putDouble("x", vec3d.x());
            compound.putDouble("y", vec3d.y());
            compound.putDouble("z", vec3d.z());
        }
    }

    @Nullable
    public static Vec3 getVector3d(CompoundTag compound) {
        if (compound.contains("x", 99) && compound.contains("y", 99) && compound.contains("z", 99)) {
            return new Vec3(compound.getDouble("x"), compound.getDouble("y"), compound.getDouble("z"));
        }
        return null;
    }

    public static void putTextComponent(CompoundTag compound, String key, @Nullable Component component) {
        if (component != null) {
            compound.putString(key, NBTUtil.serializeComponentToJsonStr(component));
        }
    }

    @Nullable
    public static Component getTextComponent(CompoundTag compound, String key) {
        if (compound.contains(key, 8)) {
            return NBTUtil.parseComponentJsonStr(compound.getString(key));
        }
        return null;
    }

    private static Component parseComponentJsonStr(String str) {
        JsonElement c1_json = JsonParser.parseString((String)str);
        if (c1_json == null) {
            return Component.empty();
        }
        MutableComponent ret = null;
        try {
            ret = (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)c1_json).getOrThrow();
        }
        catch (Exception e) {
            ret = Component.empty();
        }
        if (ret == null) {
            ret = Component.empty();
        }
        return ret;
    }

    private static String serializeComponentToJsonStr(Component c1) {
        if (c1 == null) {
            return "";
        }
        JsonElement c1_json = null;
        try {
            c1_json = (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)c1).getOrThrow();
        }
        catch (Exception e) {
            c1_json = null;
        }
        return c1_json != null ? GSON.toJson(c1_json) : "";
    }

    @Nullable
    public static <T> T getRegistryValue(CompoundTag compound, String key, Registry<T> registry) {
        ResourceLocation rl = NBTUtil.getResourceLocation(compound, key);
        if (rl != null) {
            if (registry.containsKey(rl)) {
                return (T)registry.get(rl);
            }
            DoggyTalentsNext.LOGGER.warn("Unable to load registry value in registry {} with resource location {}", (Object)registry.key(), (Object)rl);
        } else {
            DoggyTalentsNext.LOGGER.warn("Unable to load resource location in NBT:{}, for {} registry", (Object)key, (Object)registry.key());
        }
        return null;
    }

    public static void putRegistryValue(CompoundTag compound, String key, ResourceLocation value) {
        if (value != null) {
            NBTUtil.putResourceLocation(compound, key, value);
        }
    }

    public static void putBlockPos(CompoundTag compound, @Nullable BlockPos vec3d) {
        if (vec3d != null) {
            compound.putInt("x", vec3d.getX());
            compound.putInt("y", vec3d.getY());
            compound.putInt("z", vec3d.getZ());
        }
    }

    @Nullable
    public static BlockPos getBlockPos(CompoundTag compound) {
        if (compound.contains("x", 99) && compound.contains("y", 99) && compound.contains("z", 99)) {
            return new BlockPos(compound.getInt("x"), compound.getInt("y"), compound.getInt("z"));
        }
        return null;
    }

    public static void putBlockPos(CompoundTag compound, String key, Optional<BlockPos> vec3d) {
        if (vec3d.isPresent()) {
            CompoundTag posNBT = new CompoundTag();
            NBTUtil.putBlockPos(posNBT, vec3d.get());
            compound.put(key, (Tag)posNBT);
        }
    }

    public static Optional<BlockPos> getBlockPos(CompoundTag compound, String key) {
        if (compound.contains(key, 10)) {
            return Optional.of(NBTUtil.getBlockPos(compound.getCompound(key)));
        }
        return Optional.empty();
    }

    public static void putBlockPos(CompoundTag compound, String key, @Nullable BlockPos vec3d) {
        if (vec3d != null) {
            CompoundTag posNBT = new CompoundTag();
            NBTUtil.putBlockPos(posNBT, vec3d);
            compound.put(key, (Tag)posNBT);
        }
    }

    public static void writeItemStack(HolderLookup.Provider prov, CompoundTag compound, String key, ItemStack stackIn) {
        if (!stackIn.isEmpty()) {
            compound.put(key, stackIn.save(prov, (Tag)new CompoundTag()));
        }
    }

    @Nonnull
    public static ItemStack readItemStack(HolderLookup.Provider prov, CompoundTag compound, String key) {
        if (compound.contains(key, 10)) {
            return ItemStack.parse((HolderLookup.Provider)prov, (Tag)compound.getCompound(key)).orElse(ItemStack.EMPTY);
        }
        return ItemStack.EMPTY;
    }
}

