/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.DoggyBlocks;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DogDistantTeleportToBedPromise
extends AbstractPromise {
    private Dog dog;
    private ServerLevel level;
    private BlockPos bedPos;
    private boolean dogTeleported = false;
    private int tickPersist = 5;

    public DogDistantTeleportToBedPromise(Dog dog) {
        ServerLevel sLevel;
        this.dog = dog;
        Level level = this.dog.level();
        this.level = level instanceof ServerLevel ? (sLevel = (ServerLevel)level) : null;
    }

    @Override
    public void start() {
        BlockPos bedPos0;
        if (!this.dog.isAlive()) {
            this.rejectedMsg = "DOGOFFLINE";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (this.level == null) {
            this.rejectedMsg = "CLIENTLEVEL";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Optional<BlockPos> bedPosOptional = this.dog.getBedPos();
        if (!bedPosOptional.isPresent()) {
            this.rejectedMsg = "NOBEDPOSATDIM";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.bedPos = bedPos0 = bedPosOptional.get();
        ChunkPos chunkpos = new ChunkPos(this.bedPos);
        if (this.dog.level().hasChunk(chunkpos.x, chunkpos.z)) {
            this.rejectedMsg = "ALREADYREQUESTORLOADED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.accquireChunk(this.level, chunkpos);
    }

    @Override
    public void tick() {
        if (this.dogTeleported) {
            if (--this.tickPersist <= 0) {
                this.setState(AbstractPromise.State.FULFILLED);
            }
            return;
        }
        if (!this.dog.isAlive()) {
            this.rejectedMsg = "DOGOFFLINE";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        BlockState blockState = this.level.getBlockState(this.bedPos);
        if (blockState.getBlock() != DoggyBlocks.DOG_BED.get()) {
            this.rejectedMsg = "BEDDESTROYED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        BlockPos b1 = this.bedPos.above();
        if (!DogUtil.isTeleportSafeBlockMidAir(this.dog, b1)) {
            this.rejectedMsg = "BEDOBSTRUCTED";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.dog.fallDistance = 0.0f;
        this.dog.moveTo((float)b1.getX() + 0.5f, b1.getY(), (float)b1.getZ() + 0.5f, this.dog.getYRot(), this.dog.getXRot());
        this.dog.getNavigation().stop();
        this.dog.setOrderedToSit(true);
        this.dogTeleported = true;
        this.tickPersist = 5;
    }

    @Override
    public void onFulfilled() {
        LivingEntity owner = this.dog.getOwner();
        if (owner != null) {
            owner.sendSystemMessage((Component)Component.translatable((String)"item.doggytalents.conducting_bone.fulfilled.tp_bed", (Object[])new Object[]{this.dog.getName().getString(), this.dog.getGenderPossessiveAdj()}));
        }
    }

    @Override
    public void onRejected() {
        LivingEntity owner = this.dog.getOwner();
        if (owner != null) {
            owner.sendSystemMessage((Component)Component.translatable((String)"item.doggytalents.conducting_bone.rejected", (Object[])new Object[]{Component.literal((String)this.rejectedMsg).withStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.RED))}));
        }
    }
}

