/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.client.entity.skin.DogSkinHolder;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7367;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DogTextureManager
extends class_4080<DogSkinLoadResult> {
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/dogSkin");
    public static final DogTextureManager INSTANCE = new DogTextureManager();
    private static final Gson GSON = new Gson();
    private Map<String, DogSkinHolder> hashToSkinHolder = ImmutableMap.of();
    private Map<DogSkin, String> skinToHash = ImmutableMap.of();
    private List<DogSkinHolder> dogSkinHolders = List.of();
    private List<DogSkin> dogSkins = List.of();
    private DogSkinHolder missingHolder = DogSkinHolder.resolved(DogSkin.MISSING);

    public List<DogSkin> getAll() {
        return this.dogSkins;
    }

    public DogSkinHolder getDogSkin(String hash) {
        if (hash == null || hash.isEmpty()) {
            return DogSkinHolder.getNone();
        }
        return this.hashToSkinHolder.getOrDefault(hash, this.missingHolder);
    }

    public String getHash(DogSkin loc) {
        if (loc == null || !loc.isCustom()) {
            return "";
        }
        return this.skinToHash.getOrDefault(loc, "");
    }

    public class_2960 getTexture(Dog dog) {
        DogSkin skin = dog.getClientSkin();
        if (skin != null && skin.isCustom()) {
            return skin.getPath();
        }
        return dog.dogVariant().texture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized RegisterState registerDogSkin(DogSkinLoadResult prep, class_3298 resource, DogSkin dogSkin) {
        RegisterState state = RegisterState.FAIL;
        InputStream inputstream = null;
        try {
            inputstream = resource.method_14482();
            String hash = this.computeHash(IOUtils.toByteArray((InputStream)inputstream));
            if (prep.hashAlreadyRegistered(hash)) {
                state = RegisterState.DUPLICATE;
            } else {
                prep.addDogSkin(dogSkin, hash);
                state = RegisterState.SUCCESS;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
        return state;
    }

    public String computeHash(byte[] targetArray) {
        return Hashing.sha1().hashBytes(targetArray).toString();
    }

    protected DogSkinLoadResult prepare(class_3300 resourceManager, class_3695 profiler) {
        DogSkinLoadResult prep = new DogSkinLoadResult();
        this.getSkinFromSkinJsonAllPack(resourceManager, prep);
        return prep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean getSkinFromSkinJsonAllPack(class_3300 resMan, DogSkinLoadResult prep) {
        class_2960 SKIN_JSON_RES = Util.getResource("textures/entity/dog/skin.json");
        List jsonSkinPacks = resMan.method_29213().collect(Collectors.toList());
        for (class_3262 jsonSkinPack : jsonSkinPacks) {
            InputStream istream = null;
            try {
                class_7367 packRes = jsonSkinPack.method_14405(class_3264.field_14188, SKIN_JSON_RES);
                if (packRes == null) continue;
                istream = (InputStream)packRes.get();
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                RegsiterResult result = this.getSkinFromSkinJson(resMan, prep, jsonObject);
                if (result.success > 0) {
                    LOGGER.info("Successfully registered " + result.success + " entries from pack [" + jsonSkinPack.method_14409() + "]");
                }
                if (result.duplicates > 0) {
                    LOGGER.warn("Pack [" + jsonSkinPack.method_14409() + "] contains " + result.duplicates + " duplicated entries. Those will be omitted.");
                }
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(istream);
            }
        }
        this.getSkinJsonFromOtherMods(resMan, prep);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSkinJsonFromOtherMods(class_3300 resMan, DogSkinLoadResult prep) {
        List<class_2960> paths = ClientSetup.OTHER_MOD_SKIN_JSONS;
        if (paths.isEmpty()) {
            return;
        }
        for (class_2960 path : paths) {
            InputStream istream = null;
            try {
                Optional res = resMan.method_14486(path);
                if (res.isEmpty()) continue;
                istream = ((class_3298)res.get()).method_14482();
                JsonElement jsonElement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(istream, StandardCharsets.UTF_8), JsonElement.class);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                RegsiterResult result = this.getSkinFromSkinJson(resMan, prep, jsonObject);
                if (result.success > 0) {
                    LOGGER.info("Successfully registered " + result.success + " entries from path [" + String.valueOf(path) + "]");
                }
                if (result.duplicates > 0) {
                    LOGGER.warn("Path [" + String.valueOf(path) + "] contains " + result.duplicates + " duplicated entries. Those will be omitted.");
                }
                IOUtils.closeQuietly((InputStream)istream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(istream);
            }
        }
    }

    public RegsiterResult getSkinFromSkinJson(class_3300 resMan, DogSkinLoadResult prep, JsonObject jsonObject) {
        int success_cnt = 0;
        int duplicate_cnt = 0;
        int failed_cnt = 0;
        JsonArray skinEntries = jsonObject.get("dog_skins").getAsJsonArray();
        block4: for (JsonElement skinEntry : skinEntries) {
            DogSkin skin;
            JsonObject skinObject = skinEntry.getAsJsonObject();
            String name = skinObject.get("skin_name").getAsString();
            String id = skinObject.get("skin_id").getAsString();
            String use_model = skinObject.get("use_model").getAsString();
            class_2960 text_rl = id.indexOf(58) >= 0 ? class_2960.method_60654((String)(id + ".png")) : Util.getResource("textures/entity/dog/custom/" + id + ".png");
            if (use_model == null || use_model.equals("default") || use_model.equals("")) {
                skin = new DogSkin(text_rl).setName(name);
            } else if (use_model.equals("variant")) {
                JsonElement earOptional;
                dogModel = DogModelRegistry.getDogModelHolder(use_model);
                skin = dogModel == null ? new DogSkin(text_rl).setName(name) : new DogSkin(text_rl, dogModel).setName(name);
                JsonElement tailOptional = skinObject.get("tail_id");
                if (tailOptional != null) {
                    skin.setTail(tailOptional.getAsByte());
                }
                if ((earOptional = skinObject.get("ear_id")) != null) {
                    skin.setEar(earOptional.getAsByte());
                }
            } else {
                dogModel = DogModelRegistry.getDogModelHolder(use_model);
                skin = dogModel == null ? new DogSkin(text_rl).setName(name) : new DogSkin(text_rl, dogModel).setName(name);
            }
            this.readSkinExtraInfo(skin, skinObject);
            RegisterState state = RegisterState.FAIL;
            Optional res = resMan.method_14486(text_rl);
            if (res.isPresent()) {
                state = this.registerDogSkin(prep, (class_3298)res.get(), skin);
            }
            switch (state.ordinal()) {
                case 0: {
                    ++success_cnt;
                    continue block4;
                }
                case 1: {
                    ++duplicate_cnt;
                    continue block4;
                }
            }
            ++failed_cnt;
        }
        return new RegsiterResult(success_cnt, duplicate_cnt, failed_cnt);
    }

    private void readSkinExtraInfo(DogSkin skin, JsonObject skinJsonObject) {
        JsonElement glow_path;
        JsonElement mystery;
        JsonElement tags;
        JsonElement desc;
        JsonElement based_on;
        JsonElement author = skinJsonObject.get("author");
        if (author != null) {
            skin.setAuthor(author.getAsString());
        }
        if ((based_on = skinJsonObject.get("based_on")) != null) {
            skin.setBasedOn(based_on.getAsString());
        }
        if ((desc = skinJsonObject.get("description")) != null) {
            skin.setDesc(desc.getAsString());
        }
        if ((tags = skinJsonObject.get("tags")) != null) {
            skin.setTags(tags.getAsString());
        }
        if ((mystery = skinJsonObject.get("mystery")) != null) {
            skin.setMystery(mystery.getAsBoolean());
        }
        if ((glow_path = skinJsonObject.get("glowing_overlay")) != null) {
            String raw_path = skinJsonObject.get("glowing_overlay").getAsString();
            class_2960 glow_rl = raw_path.indexOf(58) >= 0 ? class_2960.method_60654((String)(raw_path + ".png")) : Util.getResource("textures/entity/dog/custom/" + raw_path + ".png");
            skin.setGlowingOverlay(glow_rl);
        }
    }

    protected void apply(DogSkinLoadResult loadResult, class_3300 resourceManager, class_3695 profiler) {
        this.dogSkinHolders.forEach(DogSkinHolder::invalidate);
        this.dogSkinHolders = List.of();
        this.missingHolder.invalidate();
        this.missingHolder = DogSkinHolder.resolved(DogSkin.MISSING);
        this.dogSkins = List.of();
        this.skinToHash = ImmutableMap.of();
        this.hashToSkinHolder = ImmutableMap.of();
        int skipping_cnt = 0;
        HashMap filter_skin_map = Maps.newHashMap();
        HashMap filter_skin_map_1 = Maps.newHashMap();
        ArrayList<DogSkinHolder> holder_list = new ArrayList<DogSkinHolder>();
        ArrayList<DogSkin> skin_list = new ArrayList<DogSkin>();
        skin_list.add(DogSkin.CLASSICAL);
        for (Pair<DogSkin, String> entry : loadResult.dogSkinsAndHash) {
            DogSkin skin = (DogSkin)entry.getLeft();
            String hash = (String)entry.getRight();
            if (DogTextureManager.isDogSkinBlacklisted(skin)) {
                ++skipping_cnt;
                continue;
            }
            DogSkinHolder holder = DogSkinHolder.resolved(skin);
            filter_skin_map.put(skin, hash);
            filter_skin_map_1.put(hash, holder);
            holder_list.add(holder);
            skin_list.add(skin);
        }
        this.dogSkinHolders = List.copyOf(holder_list);
        this.dogSkins = List.copyOf(skin_list);
        this.skinToHash = ImmutableMap.copyOf((Map)filter_skin_map);
        this.hashToSkinHolder = ImmutableMap.copyOf((Map)filter_skin_map_1);
        if (skipping_cnt > 0) {
            LOGGER.info("Excluded " + skipping_cnt + " blacklisted dog skins.");
        }
    }

    private static boolean isDogSkinBlacklisted(DogSkin dog_skin) {
        if (dog_skin == null) {
            return false;
        }
        if (!dog_skin.isCustom()) {
            return false;
        }
        ConfigHandler.DogCustomSkinClientConfig.DataStrategy strategy = ConfigHandler.DogCustomSkinClientConfig.getStrategy();
        if (strategy == ConfigHandler.DogCustomSkinClientConfig.DataStrategy.NONE) {
            return false;
        }
        ConfigHandler.DogCustomSkinClientConfig config = ConfigHandler.DogCustomSkinClientConfig.getInstance();
        if (config == null) {
            return false;
        }
        String skin_path = dog_skin.getPath().toString();
        if (strategy == ConfigHandler.DogCustomSkinClientConfig.DataStrategy.ALLOW_EXCEPT && config.isBlacklisted(skin_path)) {
            return true;
        }
        return strategy == ConfigHandler.DogCustomSkinClientConfig.DataStrategy.DISALLOW_EXCEPT && !config.isWhitelisted(skin_path);
    }

    public String method_22322() {
        return "DogTextureManager";
    }

    private static enum RegisterState {
        SUCCESS,
        DUPLICATE,
        FAIL;

    }

    protected static class DogSkinLoadResult {
        public final List<Pair<DogSkin, String>> dogSkinsAndHash = new ArrayList<Pair<DogSkin, String>>();
        private final Set<String> registeredHash = new HashSet<String>();

        public void addDogSkin(DogSkin skin, String hash) {
            if (skin == null || hash == null) {
                return;
            }
            this.dogSkinsAndHash.add((Pair<DogSkin, String>)Pair.of((Object)skin, (Object)hash));
            this.registeredHash.add(hash);
        }

        public boolean hashAlreadyRegistered(String hash) {
            return this.registeredHash.contains(hash);
        }
    }

    private record RegsiterResult(int success, int duplicates, int fail) {
    }
}

