/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.block.model;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.fabric_helper.block.dogbed.DogBedModelData;
import doggytalents.common.util.DogBedUtil;
import doggytalents.common.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.renderer.VanillaModelEncoder;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1100;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class DogBedModel
implements class_1087 {
    private static final class_2960 MISSING_TEXTURE = Util.getVanillaResource("missingno");
    private final class_1088 modelLoader;
    private final class_793 unbakedModel;
    private final class_1087 defaultModelVariant;
    private final Map<class_2350, class_1087> defaultModelVariants = new ConcurrentHashMap<class_2350, class_1087>(class_2350.values().length);
    private final Map<class_2350, class_1087> missingModelVariant = new ConcurrentHashMap<class_2350, class_1087>(class_2350.values().length);
    private static final Map<Triple<ICasingMaterial, IBeddingMaterial, class_2350>, class_1087> cache = Maps.newConcurrentMap();
    private final int maxCacheSize;

    public DogBedModel(class_1088 modelLoader, class_793 model, class_1087 defaultModelVariant, int maxCacheSize) {
        this.modelLoader = modelLoader;
        this.unbakedModel = model;
        this.defaultModelVariant = defaultModelVariant;
        this.maxCacheSize = maxCacheSize;
    }

    public static void clearCache() {
        cache.clear();
    }

    public class_1087 getModelVariant(@Nonnull DogBedModelData data) {
        return this.getModelVariant(data.casing(), data.bedding(), data.direction());
    }

    public class_1087 getModelVariant(ICasingMaterial casing, IBeddingMaterial bedding, class_2350 facing) {
        if (facing == null) {
            facing = class_2350.field_11043;
        }
        if (casing == null || bedding == null) {
            return this.getDefaultVariant(facing);
        }
        if (casing.isNani() || bedding.isNani()) {
            return this.getMissingVariant(facing);
        }
        ImmutableTriple key = ImmutableTriple.of((Object)casing, (Object)bedding, (Object)facing);
        class_1087 model_variant = cache.get(key);
        if (model_variant != null) {
            return model_variant;
        }
        if (cache.size() >= this.maxCacheSize) {
            return this.getDefaultVariant(facing);
        }
        model_variant = this.bakeModelVariant(casing, bedding, facing);
        cache.put((Triple<ICasingMaterial, IBeddingMaterial, class_2350>)key, model_variant);
        return model_variant;
    }

    private class_1087 getMissingVariant(class_2350 dir) {
        class_1087 missing = this.missingModelVariant.get(dir);
        if (missing != null) {
            return missing;
        }
        missing = this.bakeModelVariant(DogBedMaterialManager.NaniCasing.NULL, DogBedMaterialManager.NaniBedding.NULL, dir);
        this.missingModelVariant.put(dir, missing);
        return missing;
    }

    private class_1087 getDefaultVariant(class_2350 dir) {
        class_1087 default_variant = this.defaultModelVariants.get(dir);
        if (default_variant != null) {
            return default_variant;
        }
        default_variant = DogBedModel.bakeModel(this.unbakedModel, dir);
        this.defaultModelVariants.put(dir, default_variant);
        return default_variant;
    }

    public List<class_777> method_4707(class_2680 state, class_2350 side, class_5819 rand) {
        return this.getModelVariant(null, null, class_2350.field_11043).method_4707(state, side, rand);
    }

    public class_1087 bakeModelVariant(@Nullable ICasingMaterial casing, @Nullable IBeddingMaterial bedding, @Nonnull class_2350 facing) {
        class_793 new_model = DogBedModel.deepCopyBlockModel(this.unbakedModel);
        Either<class_4730, String> casing_texture = DogBedModel.findCasingTexture(casing);
        Either<class_4730, String> bedding_texture = DogBedModel.findBeddingTexture(bedding);
        new_model.field_4251.put("bedding", bedding_texture);
        new_model.field_4251.put("casing", casing_texture);
        new_model.field_4251.put("particle", casing_texture);
        class_1087 ret = DogBedModel.bakeModel(new_model, facing);
        return ret;
    }

    private static class_793 deepCopyBlockModel(class_793 model) {
        List elements_old = model.method_3433();
        ArrayList<class_785> elements_new = new ArrayList<class_785>(elements_old.size());
        for (class_785 element : elements_old) {
            class_785 element_copy = new class_785(element.field_4228, element.field_4231, (Map)Maps.newHashMap((Map)element.field_4230), element.field_4232, element.field_4229);
            elements_new.add(element_copy);
        }
        class_793 ret = new class_793(model.field_4247, elements_new, (Map)Maps.newHashMap((Map)model.field_4251), Boolean.valueOf(model.method_3444()), model.method_24298(), model.method_3443(), new ArrayList(model.method_3434()));
        ret.field_4252 = model.field_4252;
        ret.field_4253 = model.field_4253;
        return ret;
    }

    private static class_1087 bakeModel(final class_793 to_bake, final class_2350 dir) {
        var baker = new class_7775(){

            @Nullable
            public class_1087 bake(class_2960 location, class_3665 state, Function<class_4730, class_1058> sprites) {
                return to_bake.method_3446((class_7775)this, to_bake, class_4730::method_24148, (class_3665)DogBedModel.getModelRotation(dir), true);
            }

            public Function<class_4730, class_1058> getModelTextureGetter() {
                return class_4730::method_24148;
            }

            public class_1100 method_45872(class_2960 p_252194_) {
                return to_bake;
            }

            @Nullable
            public class_1087 method_45873(class_2960 p_250776_, class_3665 p_251280_) {
                return this.bake(p_250776_, p_251280_, this.getModelTextureGetter());
            }
        };
        return baker.bake(null, null, null);
    }

    private static class_1086 getModelRotation(@Nonnull class_2350 dir) {
        switch (dir) {
            default: {
                return class_1086.field_5350;
            }
            case field_11034: {
                return class_1086.field_5366;
            }
            case field_11035: {
                return class_1086.field_5355;
            }
            case field_11039: 
        }
        return class_1086.field_5347;
    }

    private static Either<class_4730, String> findCasingTexture(@Nullable ICasingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<class_4730, String> findBeddingTexture(@Nullable IBeddingMaterial resource) {
        return DogBedModel.findTexture(resource != null ? resource.getTexture() : null);
    }

    private static Either<class_4730, String> findTexture(class_2960 resource) {
        if (resource == null) {
            resource = MISSING_TEXTURE;
        }
        return Either.left((Object)new class_4730(class_1723.field_21668, resource));
    }

    public boolean method_4708() {
        return this.defaultModelVariant.method_4708();
    }

    public boolean method_4712() {
        return this.defaultModelVariant.method_4712();
    }

    public boolean method_24304() {
        return this.defaultModelVariant.method_24304();
    }

    public boolean method_4713() {
        return this.defaultModelVariant.method_4713();
    }

    public class_1058 method_4711() {
        return this.defaultModelVariant.method_4711();
    }

    public class_809 method_4709() {
        return this.defaultModelVariant.method_4709();
    }

    public class_806 method_4710() {
        return this.defaultModelVariant.method_4710();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_1920 dataGetter = blockView;
        Object data = dataGetter.getBlockEntityRenderData(pos);
        class_1087 bakedModel = null;
        if (data instanceof DogBedModelData) {
            DogBedModelData dogBedData = (DogBedModelData)data;
            bakedModel = this.getModelVariant(dogBedData);
        } else {
            bakedModel = this.getModelVariant(DogBedModelData.EMPTY);
        }
        VanillaModelEncoder.emitBlockQuads((class_1087)bakedModel, (class_2680)state, randomSupplier, (RenderContext)context);
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        Pair<ICasingMaterial, IBeddingMaterial> bedMaterial = DogBedUtil.getMaterials(stack);
        class_1087 bakedModel = this.getModelVariant((ICasingMaterial)bedMaterial.getLeft(), (IBeddingMaterial)bedMaterial.getRight(), class_2350.field_11043);
        VanillaModelEncoder.emitItemQuads((class_1087)bakedModel, null, randomSupplier, (RenderContext)context);
    }
}

