/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render;

import doggytalents.api.inferface.IColoredObject;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.client.entity.model.SyncedAccessoryModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.render.layer.accessory.DefaultAccessoryRenderer;
import doggytalents.common.entity.Dog;
import doggytalents.forge_imitate.event.client.EntityRenderersEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_922;

public class AccessoryModelManager {
    private static ArrayList<Entry> entryArray = new ArrayList();
    private static List<Entry> entryArraySyncedView = Collections.synchronizedList(entryArray);

    public static void register(Entry entry) {
        if (entryArraySyncedView.contains(entry)) {
            return;
        }
        entryArraySyncedView.add(entry);
    }

    public static void resolve(class_5617.class_5618 ctx) {
        for (Entry x : entryArraySyncedView) {
            x.initModel(ctx);
        }
    }

    public static void registerLayerDef(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (Entry x : entryArraySyncedView) {
            x.registerLayerDef(event);
        }
    }

    public static void renderColoredCutoutModel(SyncedAccessoryModel p_117377_, class_2960 p_117378_, class_4587 p_117379_, class_4597 p_117380_, int p_117381_, Dog p_117382_, float p_117383_, float p_117384_, float p_117385_) {
        class_4588 vertexconsumer = p_117380_.getBuffer(class_1921.method_23578((class_2960)p_117378_));
        p_117377_.method_2828(p_117379_, vertexconsumer, p_117381_, class_922.method_23622((class_1309)p_117382_, (float)0.0f), class_5253.class_5254.method_59554((float)1.0f, (float)p_117383_, (float)p_117384_, (float)p_117385_));
    }

    public static abstract class Entry {
        public abstract void initModel(class_5617.class_5618 var1);

        public abstract SyncedAccessoryModel getModel();

        public void renderAccessory(class_3887<Dog, DogModel> layer, class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, AccessoryInstance inst) {
            SyncedAccessoryModel model = this.getModel();
            DogModel dogModel = (DogModel)layer.method_17165();
            dogModel.method_17081(model);
            model.prepareMobModel(dog, limbSwing, limbSwingAmount, partialTicks);
            model.setupAnim(dog, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.sync(dogModel);
            float[] color = new float[]{1.0f, 1.0f, 1.0f};
            if (this.isDyable() && inst instanceof IColoredObject) {
                IColoredObject coloredObject = (IColoredObject)((Object)inst);
                color = coloredObject.getColor();
            }
            if (this.isTranslucent()) {
                DefaultAccessoryRenderer.renderTranslucentModel(model, this.getResources(inst), poseStack, buffer, packedLight, dog, color[0], color[1], color[2], 1.0f);
            } else {
                AccessoryModelManager.renderColoredCutoutModel(model, this.getResources(inst), poseStack, buffer, packedLight, dog, color[0], color[1], color[2]);
            }
        }

        public abstract void registerLayerDef(EntityRenderersEvent.RegisterLayerDefinitions var1);

        public abstract class_2960 getResources(AccessoryInstance var1);

        public boolean isDyable() {
            return false;
        }

        public boolean isTranslucent() {
            return false;
        }
    }
}

