/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer;

import doggytalents.client.entity.model.DogModelRegistry;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.Util;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4059;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_9273;
import net.minecraft.class_9282;
import org.apache.commons.lang3.tuple.Pair;

public class DogWolfArmorRenderer
extends class_3887<Dog, DogModel> {
    private static final Map<class_9273.class_4621, class_2960> ARMOR_CRACK_LOCATIONS = Map.of(class_9273.class_4621.field_21082, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_low.png"), class_9273.class_4621.field_21083, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_medium.png"), class_9273.class_4621.field_21084, Util.getVanillaResource("textures/entity/wolf/wolf_armor_crackiness_high.png"));
    private DogModel defaultModel = DogModelRegistry.getDogModelHolder("default").getValue();

    public DogWolfArmorRenderer(class_3883 parentRenderer, class_5617.class_5618 ctx) {
        super(parentRenderer);
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (!dog.method_6181() || dog.method_5767()) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.RENDER_ARMOR.get()).booleanValue() || dog.hideArmor()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        if (dog.wolfArmor().method_7960()) {
            return;
        }
        Optional<Pair<class_1799, class_4059>> wolfArmorOptional = this.getWolfArmorItem(dog);
        if (!wolfArmorOptional.isPresent()) {
            return;
        }
        Pair<class_1799, class_4059> wolfArmorPair = wolfArmorOptional.get();
        DogModel parentModel = (DogModel)this.method_17165();
        DogModel dogModel = parentModel.useDefaultModelForAccessories() ? this.defaultModel : parentModel;
        if (dogModel != parentModel) {
            ((DogModel)this.method_17165()).method_17081(dogModel);
            dogModel.copyFrom(parentModel);
        }
        this.renderWolfArmorLayerMain(dogModel, poseStack, buffer, packedLight, (class_4059)wolfArmorPair.getRight());
        this.renderWolfArmorLayerDyed(dogModel, poseStack, buffer, packedLight, (class_1799)wolfArmorPair.getLeft(), (class_4059)wolfArmorPair.getRight());
        this.renderWolfArmorLayerCracks(dogModel, poseStack, buffer, packedLight, (class_1799)wolfArmorPair.getLeft());
    }

    private Optional<Pair<class_1799, class_4059>> getWolfArmorItem(Dog dog) {
        class_1799 wolf_armor_stack = dog.wolfArmor();
        class_1792 class_17922 = wolf_armor_stack.method_7909();
        if (!(class_17922 instanceof class_4059)) {
            return Optional.empty();
        }
        class_4059 wolfArmorItem = (class_4059)class_17922;
        if (wolfArmorItem.method_55756() != class_4059.class_9076.field_47826) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)wolf_armor_stack, (Object)wolfArmorItem));
    }

    private void renderWolfArmorLayerMain(DogModel model, class_4587 poseStack, class_4597 buffer, int light, class_4059 item) {
        class_4588 vertexConsumer = buffer.getBuffer(class_1921.method_23578((class_2960)item.method_18454()));
        model.method_2828(poseStack, vertexConsumer, light, class_4608.field_21444, -1);
    }

    private void renderWolfArmorLayerDyed(DogModel model, class_4587 stack, class_4597 buffer, int light, class_1799 itemStack, class_4059 item) {
        if (item != class_1802.field_47831) {
            return;
        }
        int i = class_9282.method_57470((class_1799)itemStack, (int)0);
        if (class_5253.class_5254.method_27762((int)i) == 0) {
            return;
        }
        class_2960 armor_overlay = item.method_57335();
        if (armor_overlay == null) {
            return;
        }
        float r = (float)class_5253.class_5254.method_27765((int)i) / 255.0f;
        float g = (float)class_5253.class_5254.method_27766((int)i) / 255.0f;
        float b = (float)class_5253.class_5254.method_27767((int)i) / 255.0f;
        model.method_2828(stack, buffer.getBuffer(class_1921.method_23578((class_2960)armor_overlay)), light, class_4608.field_21444, class_5253.class_5254.method_59554((float)1.0f, (float)r, (float)g, (float)b));
    }

    private void renderWolfArmorLayerCracks(DogModel model, class_4587 stack, class_4597 buffer, int light, class_1799 itemStack) {
        class_9273.class_4621 crack_level = class_9273.field_49211.method_57284(itemStack);
        if (crack_level == class_9273.class_4621.field_21081) {
            return;
        }
        class_2960 crack_rl = ARMOR_CRACK_LOCATIONS.get(crack_level);
        class_4588 vertexconsumer = buffer.getBuffer(class_1921.method_23580((class_2960)crack_rl));
        model.method_2828(stack, vertexconsumer, light, class_4608.field_21444, -1);
    }
}

