/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.entity.render.layer.accessory;

import doggytalents.DoggyTalents;
import doggytalents.client.ClientSetup;
import doggytalents.client.entity.model.DogArmorModel;
import doggytalents.client.entity.model.SyncedRenderFunctionWithHeadModel;
import doggytalents.client.entity.model.dog.DogModel;
import doggytalents.client.entity.render.DoggyArmorMapping;
import doggytalents.client.entity.render.layer.DogArmorHelmetAltModel;
import doggytalents.client.entity.skin.DogSkin;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.util.ItemUtil;
import java.util.Optional;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1304;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_6880;
import net.minecraft.class_8053;
import net.minecraft.class_8056;

public class DoggyArmorRenderer
extends class_3887<Dog, DogModel> {
    private DogArmorModel model;
    private DogArmorModel newModel;
    private DogArmorModel legacyModel;
    private SyncedRenderFunctionWithHeadModel alternativeModel;
    private boolean initAltModel = false;
    private DogArmorHelmetAltModel helmetAltModel;
    private final class_1059 dogArmorTrimAtlas;

    public DoggyArmorRenderer(class_3883 parentRenderer, class_5617.class_5618 ctx) {
        super(parentRenderer);
        this.newModel = new DogArmorModel(ctx.method_32167(ClientSetup.DOG_ARMOR));
        this.legacyModel = new DogArmorModel(ctx.method_32167(ClientSetup.DOG_ARMOR_LEGACY));
        this.alternativeModel = new SyncedRenderFunctionWithHeadModel(ctx.method_32167(ClientSetup.DOG_SYNCED_FUNCTION_WITH_HEAD));
        this.model = this.newModel;
        this.helmetAltModel = new DogArmorHelmetAltModel(ctx);
        this.dogArmorTrimAtlas = ctx.method_48481().method_24153(class_4722.field_42071);
    }

    public void render(class_4587 poseStack, class_4597 buffer, int packedLight, Dog dog, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DogModel model;
        if (!dog.method_6181() || dog.method_5767()) {
            return;
        }
        if (!((Boolean)ConfigHandler.CLIENT.RENDER_ARMOR.get()).booleanValue() || dog.hideArmor()) {
            return;
        }
        DogSkin skin = dog.getClientSkin();
        if (skin.useCustomModel() && !(model = skin.getCustomModel().getValue()).armorShouldRender(dog)) {
            return;
        }
        Optional inst = dog.getTalent(DoggyTalents.DOGGY_ARMOR);
        if (!inst.isPresent()) {
            return;
        }
        this.model = (Boolean)ConfigHandler.CLIENT.USE_LEGACY_DOG_ARMOR_RENDER.get() != false ? this.legacyModel : this.newModel;
        DogModel parentModel = (DogModel)this.method_17165();
        parentModel.method_17081(this.model);
        this.model.sync(parentModel);
        this.initAltModel = false;
        this.checkAndRenderSlot(dog, class_1304.field_6169, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, class_1304.field_6174, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, class_1304.field_6172, poseStack, buffer, packedLight);
        this.checkAndRenderSlot(dog, class_1304.field_6166, poseStack, buffer, packedLight);
    }

    private void checkAndRenderSlot(Dog dog, class_1304 slot, class_4587 stack, class_4597 buffer, int light) {
        class_1799 itemStack = dog.method_6118(slot);
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof class_1738)) {
            return;
        }
        class_1738 armor = (class_1738)item;
        switch (slot) {
            case field_6169: {
                this.model.setHelmet();
                break;
            }
            case field_6174: {
                this.model.setChestplate();
                break;
            }
            case field_6172: {
                this.model.setLeggings();
                break;
            }
            case field_6166: {
                this.model.setBoot();
                break;
            }
            default: {
                return;
            }
        }
        Optional<class_3879> altModel = this.getAlternativeArmorModel(dog, slot, stack, itemStack);
        if (altModel.isPresent()) {
            if (!this.initAltModel) {
                this.initAltModel = true;
                DogModel parentModel = (DogModel)this.method_17165();
                parentModel.method_17081(this.alternativeModel);
                this.alternativeModel.sync(parentModel);
            }
            this.startRenderAlternativeModelFromRoot(altModel.get(), dog, stack, buffer, light, itemStack, armor);
            return;
        }
        this.renderArmorCutout(this.model, DoggyArmorMapping.getMappedResource(itemStack.method_7909(), dog, itemStack), stack, buffer, light, dog, 1.0f, 1.0f, 1.0f);
        Optional<class_8053> trim = ItemUtil.getTrim(itemStack);
        if (trim.isPresent()) {
            this.renderTrim((class_6880<class_1741>)armor.method_7686(), stack, buffer, light, trim.get(), (class_3879)this.model);
        }
        if (itemStack.method_7958()) {
            this.renderGlint(stack, buffer, light, (class_3879)this.model);
        }
    }

    private Optional<class_3879> getAlternativeArmorModel(Dog dog, class_1304 slot, class_4587 stack, class_1799 itemStack) {
        if (slot == class_1304.field_6169 && ((Boolean)ConfigHandler.CLIENT.USE_PLAYER_HELMET_MODEL_BY_DEFAULT.get()).booleanValue()) {
            return Optional.of(this.helmetAltModel.getModel());
        }
        return Optional.empty();
    }

    private void startRenderAlternativeModelFromRoot(class_3879 model, Dog dog, class_4587 stack, class_4597 buffer, int light, class_1799 itemStack, class_1738 armor) {
        this.alternativeModel.startRenderFromRoot(stack, stack1 -> {
            stack1.method_22903();
            stack1.method_22905(0.6f, 0.6f, 0.6f);
            stack1.method_22904(0.0, (double)0.15f, 0.07);
            this.renderAlternativeModel(model, dog, stack1, buffer, light, itemStack);
            Optional<class_8053> trim = ItemUtil.getTrim(itemStack);
            if (trim.isPresent()) {
                this.renderTrim((class_6880<class_1741>)armor.method_7686(), stack, buffer, light, trim.get(), model);
            }
            if (itemStack.method_7958()) {
                this.renderGlint(stack, buffer, light, model);
            }
            stack1.method_22909();
        });
    }

    private void renderAlternativeModel(class_3879 model, Dog dog, class_4587 stack, class_4597 buffer, int light, class_1799 itemStack) {
        class_2960 texLoc = DoggyArmorMapping.getMappedResource(itemStack.method_7909(), dog, itemStack);
        class_4588 ivertexbuilder = buffer.getBuffer(class_1921.method_25448((class_2960)texLoc));
        model.method_2828(stack, ivertexbuilder, light, class_4608.field_21444, -1);
    }

    private void renderArmorCutout(DogArmorModel model, class_2960 textureLocationIn, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, Dog entityIn, float red, float green, float blue) {
        class_4588 ivertexbuilder = bufferIn.getBuffer(class_1921.method_25448((class_2960)textureLocationIn));
        model.method_2828(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, class_5253.class_5254.method_59554((float)1.0f, (float)red, (float)green, (float)blue));
    }

    private void renderTrim(class_6880<class_1741> material, class_4587 stack, class_4597 buffer, int light, class_8053 trim, class_3879 model) {
        class_1058 textureatlassprite = this.dogArmorTrimAtlas.method_4608(trim.method_48436(material));
        class_4588 vertexconsumer = textureatlassprite.method_24108(buffer.getBuffer(class_4722.method_48480((boolean)((class_8056)trim.method_48424().comp_349()).comp_1905())));
        model.method_2828(stack, vertexconsumer, light, class_4608.field_21444, -1);
    }

    private void renderGlint(class_4587 stack, class_4597 buffer, int light, class_3879 model) {
        model.method_2828(stack, buffer.getBuffer(class_1921.method_27949()), light, class_4608.field_21444, -1);
    }
}

