/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common;

import doggytalents.DoggyItems;
import doggytalents.DoggyTalents;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.block.tileentity.FoodBowlTileEntity;
import doggytalents.common.entity.Dog;
import doggytalents.common.fabric_helper.entity.network.container_sync.data.IntArrayData;
import doggytalents.common.fabric_helper.entity.network.container_sync.data.IntData;
import doggytalents.common.fabric_helper.entity.network.container_sync.data.ItemAndSlotData;
import doggytalents.common.inventory.container.DogArmorContainer;
import doggytalents.common.inventory.container.DogInventoriesContainer;
import doggytalents.common.inventory.container.DoggyToolsMenu;
import doggytalents.common.inventory.container.PackPuppyContainer;
import doggytalents.common.inventory.container.TreatBagContainer;
import doggytalents.forge_imitate.network.NetworkHooks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

public class Screens {
    public static void openPackPuppyScreen(class_3222 player, Dog dogIn) {
        if (!dogIn.canInteract((class_1309)player)) {
            return;
        }
        if (dogIn.isDoingFine()) {
            NetworkHooks.openScreen(player, new PackPuppyContainerProvider(dogIn), IntData.class, () -> new IntData(dogIn.method_5628()));
        }
    }

    public static void openDogInventoriesScreen(class_3222 player, List<Dog> dogIn) {
        if (!dogIn.isEmpty()) {
            NetworkHooks.openScreen(player, new DogInventoriesContainerProvider(dogIn), IntArrayData.class, () -> {
                ArrayList<Integer> list = new ArrayList<Integer>(dogIn.size());
                for (Dog dog : dogIn) {
                    list.add(dog.method_5628());
                }
                return new IntArrayData(list);
            });
        }
    }

    public static void openFoodBowlScreen(class_3222 player, FoodBowlTileEntity foodBowl) {
        NetworkHooks.openScreen(player, foodBowl, foodBowl.method_11016());
    }

    public static void openTreatBagScreen(class_3222 player, class_1799 stackIn, int slotId) {
        if (stackIn.method_7909() == DoggyItems.TREAT_BAG.get()) {
            NetworkHooks.openScreen(player, new TreatBagContainerProvider(stackIn, slotId), ItemAndSlotData.class, () -> new ItemAndSlotData(stackIn, slotId));
        }
    }

    public static void openArmorScreen(class_3222 player, Dog dogIn) {
        if (!dogIn.canInteract((class_1309)player)) {
            return;
        }
        if (dogIn.isDoingFine() && dogIn.getDogLevel(DoggyTalents.DOGGY_ARMOR) > 0) {
            NetworkHooks.openScreen(player, new DogArmorContainerProvider(dogIn), IntData.class, () -> new IntData(dogIn.method_5628()));
        }
    }

    public static void openDoggyToolsScreen(class_3222 player, Dog dogIn) {
        if (!dogIn.canInteract((class_1309)player)) {
            return;
        }
        if (dogIn.isDoingFine() && dogIn.getDogLevel(DoggyTalents.DOGGY_TOOLS) > 0) {
            NetworkHooks.openScreen(player, new DoggyToolsMenuProvider(dogIn), IntData.class, () -> new IntData(dogIn.method_5628()));
        }
    }

    public static class PackPuppyContainerProvider
    implements class_3908 {
        private AbstractDog dog;

        public PackPuppyContainerProvider(AbstractDog dogIn) {
            this.dog = dogIn;
        }

        public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
            return new PackPuppyContainer(windowId, inventory, this.dog);
        }

        public class_2561 method_5476() {
            return class_2561.method_43471((String)"container.doggytalents.pack_puppy");
        }
    }

    public static class DogInventoriesContainerProvider
    implements class_3908 {
        private List<Dog> dogs;

        public DogInventoriesContainerProvider(List<Dog> dogIn) {
            this.dogs = dogIn;
        }

        public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
            return new DogInventoriesContainer(windowId, inventory, this.dogs);
        }

        public class_2561 method_5476() {
            return class_2561.method_43471((String)"container.doggytalents.dog_inventories");
        }
    }

    public static class TreatBagContainerProvider
    implements class_3908 {
        private class_1799 stack;
        private int slotId;

        public TreatBagContainerProvider(class_1799 stackIn, int slotId) {
            this.stack = stackIn;
            this.slotId = slotId;
        }

        public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
            return new TreatBagContainer(windowId, inventory, this.slotId, this.stack);
        }

        public class_2561 method_5476() {
            return class_2561.method_43471((String)"container.doggytalents.treat_bag");
        }
    }

    public static class DogArmorContainerProvider
    implements class_3908 {
        private Dog dog;

        public DogArmorContainerProvider(Dog dog) {
            this.dog = dog;
        }

        public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
            return new DogArmorContainer(windowId, inventory, this.dog);
        }

        public class_2561 method_5476() {
            return class_2561.method_43471((String)"container.doggytalents.dog_armor");
        }
    }

    public static class DoggyToolsMenuProvider
    implements class_3908 {
        private Dog dog;

        public DoggyToolsMenuProvider(Dog dog) {
            this.dog = dog;
        }

        public class_1703 createMenu(int windowId, class_1661 inventory, class_1657 player) {
            return new DoggyToolsMenu(windowId, inventory, this.dog);
        }

        public class_2561 method_5476() {
            return class_2561.method_43471((String)"container.doggytalents.doggy_tools");
        }
    }
}

