/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.data;

import doggytalents.common.util.Util;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class DisplayInfoBuilder {
    private class_2561 title;
    private class_2561 description;
    private class_1799 icon;
    private class_2960 background;
    private class_189 frame;
    private boolean showToast = true;
    private boolean announceToChat = true;
    private boolean hidden = false;

    public DisplayInfoBuilder translate(class_2960 key) {
        return this.translate(key.method_12836() + "." + key.method_12832());
    }

    public DisplayInfoBuilder translate(String key) {
        this.title((class_2561)class_2561.method_43471((String)("advancements.doggytalents." + key + ".title")));
        this.description((class_2561)class_2561.method_43471((String)("advancements.doggytalents." + key + ".description")));
        return this;
    }

    public DisplayInfoBuilder title(class_2561 titleIn) {
        this.title = titleIn;
        return this;
    }

    public DisplayInfoBuilder description(class_2561 descriptionIn) {
        this.description = descriptionIn;
        return this;
    }

    public DisplayInfoBuilder icon(Supplier<? extends class_1935> stackIn) {
        return this.icon(stackIn.get());
    }

    public DisplayInfoBuilder icon(class_1935 provider) {
        return this.icon(new class_1799((class_1935)provider.method_8389()));
    }

    public DisplayInfoBuilder icon(class_1799 stackIn) {
        this.icon = stackIn;
        return this;
    }

    public DisplayInfoBuilder background(String path) {
        return this.background(Util.getVanillaResource("textures/gui/advancements/backgrounds/" + path));
    }

    public DisplayInfoBuilder background(String modId, String path) {
        return this.background(Util.getResource(modId, "textures/gui/advancements/backgrounds/" + path));
    }

    public DisplayInfoBuilder background(class_2960 backgroundIn) {
        this.background = backgroundIn;
        return this;
    }

    public DisplayInfoBuilder frame(class_189 frameIn) {
        this.frame = frameIn;
        return this;
    }

    public DisplayInfoBuilder noToast() {
        this.showToast = false;
        return this;
    }

    public DisplayInfoBuilder noAnnouncement() {
        this.announceToChat = false;
        return this;
    }

    public DisplayInfoBuilder hide() {
        this.hidden = true;
        return this;
    }

    public class_185 build() {
        return new class_185(this.icon, this.title, this.description, Optional.ofNullable(this.background), this.frame, this.showToast, this.announceToChat, this.hidden);
    }

    public static DisplayInfoBuilder create() {
        return new DisplayInfoBuilder();
    }
}

