/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity;

import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogPathNavigation;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.apache.commons.lang3.ObjectUtils;

public class DogPushAvoidManager {
    public final Dog dog;
    private short avoidPushTick = 0;
    private short avoidPushNotOnGroundTick = 0;

    public DogPushAvoidManager(Dog dog) {
        this.dog = dog;
    }

    public void tickServer() {
        this.updatePushAvoidAndNotOnGroundTicks();
    }

    private void updatePushAvoidAndNotOnGroundTicks() {
        if (this.dog.method_5942().method_6357()) {
            if (this.avoidPushTick > 0) {
                this.avoidPushTick = (short)(this.avoidPushTick - 1);
            }
        } else {
            this.avoidPushTick = (short)5;
        }
        if (this.avoidPushTick <= 0) {
            this.avoidPushNotOnGroundTick = 0;
            return;
        }
        if (this.dog.method_24828()) {
            if (this.avoidPushNotOnGroundTick > 0) {
                this.avoidPushNotOnGroundTick = (short)(this.avoidPushNotOnGroundTick - 1);
            }
        } else {
            this.avoidPushNotOnGroundTick = (short)5;
        }
    }

    public boolean shouldBlockActivePush(class_1297 target) {
        if (this.checkPushAvoidOwner(target)) {
            return true;
        }
        return !this.dog.method_37908().field_9236 && this.checkPushAvoidDog(target);
    }

    public OnBeingPushAction onBeingPushed(class_1297 source) {
        boolean block_push_owner;
        boolean force_push_avoid = this.dog.isDogForcePushAvoid();
        boolean bl = block_push_owner = (Boolean)ConfigHandler.SERVER.DOG_PUSH_OWNER.get() == false || force_push_avoid;
        if (!block_push_owner) {
            return OnBeingPushAction.NONE;
        }
        if (ObjectUtils.notEqual((Object)source.method_5667(), (Object)this.dog.method_6139())) {
            return OnBeingPushAction.NONE;
        }
        return force_push_avoid ? OnBeingPushAction.BLOCK_ALL : OnBeingPushAction.BLOCK_SOURCE;
    }

    public boolean checkPushAvoidOwner(class_1297 target) {
        boolean block_push_owner;
        boolean bl = block_push_owner = (Boolean)ConfigHandler.SERVER.DOG_PUSH_OWNER.get() == false || this.dog.isDogForcePushAvoid();
        if (!block_push_owner) {
            return false;
        }
        return !ObjectUtils.notEqual((Object)target.method_5667(), (Object)this.dog.method_6139());
    }

    public boolean checkPushAvoidDog(class_1297 target) {
        if (this.dog.isDefeated()) {
            return false;
        }
        if (this.isDogInFluid(this.dog)) {
            return false;
        }
        if (!(target instanceof Dog)) {
            return false;
        }
        Dog otherDog = (Dog)target;
        return DogPushAvoidManager.shouldDogsNotPushEachOther(this.dog, otherDog);
    }

    public static boolean shouldDogsNotPushEachOther(Dog dog1, Dog dog2) {
        boolean atleast_one_not_flying;
        if (DogPushAvoidManager.isAtLeastOneDogForcePushAvoid(dog1, dog2)) {
            return true;
        }
        if (!DogPushAvoidManager.atLeastOnePushAvoiding(dog1, dog2)) {
            return false;
        }
        if (!DogPushAvoidManager.isTeammateDogs(dog1, dog2)) {
            return false;
        }
        boolean bl = atleast_one_not_flying = !dog1.isDogFlying() || !dog2.isDogFlying();
        if (!atleast_one_not_flying) {
            return false;
        }
        if (DogPushAvoidManager.atLeastOnePushAvoidingNotOnGround(dog1, dog2)) {
            return true;
        }
        if (DogPushAvoidManager.checkBlockPushResistingDogWhileNav(dog1, dog2)) {
            return true;
        }
        return DogPushAvoidManager.checkIfEitherDogApproachingDanger(dog1, dog2);
    }

    public static boolean isAtLeastOneDogForcePushAvoid(Dog dog1, Dog dog2) {
        return dog1.isDogForcePushAvoid() || dog2.isDogForcePushAvoid();
    }

    private static boolean atLeastOnePushAvoiding(Dog dog1, Dog dog2) {
        return dog1.dogPushAvoidManager.avoidPushTick > 0 || dog2.dogPushAvoidManager.avoidPushTick > 0;
    }

    private static boolean atLeastOnePushAvoidingNotOnGround(Dog dog1, Dog dog2) {
        if (!dog1.method_24828() || !dog2.method_24828()) {
            return true;
        }
        return dog1.dogPushAvoidManager.avoidPushNotOnGroundTick > 0 || dog2.dogPushAvoidManager.avoidPushNotOnGroundTick > 0;
    }

    private static boolean checkBlockPushResistingDogWhileNav(Dog dog1, Dog dog2) {
        boolean dog2_nav;
        boolean dog1_nav = !dog1.method_5942().method_6357();
        boolean bl = dog2_nav = !dog2.method_5942().method_6357();
        if (dog1_nav == dog2_nav) {
            return false;
        }
        Dog not_nav_dog = !dog1_nav ? dog1 : dog2;
        return not_nav_dog.isDogResistingPush();
    }

    private static boolean checkIfEitherDogApproachingDanger(Dog dog1, Dog dog2) {
        return DogPushAvoidManager.checkDogApproachingDanger(dog1) || DogPushAvoidManager.checkDogApproachingDanger(dog2);
    }

    private static boolean checkDogApproachingDanger(Dog dog) {
        return dog.getDefaultNavigationIfActive().flatMap(DogPathNavigation::getNodesUntilDogApproachDanger).filter(x -> (Integer)x.getLeft() <= 1).isPresent();
    }

    private static boolean isTeammateDogs(Dog dog1, Dog dog2) {
        class_1309 owner1 = dog1.method_35057();
        class_1309 owner2 = dog2.method_35057();
        if (owner1 == null || owner2 == null) {
            return false;
        }
        if (owner1 == owner2) {
            return true;
        }
        return owner1.method_5722((class_1297)owner2);
    }

    private boolean isDogInFluid(Dog dog) {
        return dog.getMaxFluidHeight().isPresent();
    }

    public static enum OnBeingPushAction {
        NONE,
        BLOCK_SOURCE,
        BLOCK_ALL;

    }
}

