/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.class_1352;

public class DogRandomStandIdleGoal
extends class_1352 {
    private Dog dog;
    private int stopTick;
    private int startTick;
    private boolean jumped;
    private DogAnimation currentAnimation = DogAnimation.NONE;

    public DogRandomStandIdleGoal(Dog dog) {
        this.dog = dog;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        double use_chance;
        if (!this.dog.canDoIdileAnim()) {
            return false;
        }
        if (this.dog.getAnim() != DogAnimation.NONE) {
            return false;
        }
        if (this.dog.method_5809()) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.method_24828()) {
            return false;
        }
        double d = use_chance = this.dog.isChopinTail() ? 0.08 : 0.02;
        if ((double)this.dog.method_59922().method_43057() >= use_chance) {
            return false;
        }
        this.currentAnimation = this.getIdleAnim();
        return this.currentAnimation != DogAnimation.NONE;
    }

    public boolean method_6266() {
        if (!this.dog.method_24828() && this.currentAnimation != DogAnimation.BACKFLIP) {
            return false;
        }
        if (this.dog.isLowHunger()) {
            return false;
        }
        if (!this.dog.canContinueDoIdileAnim()) {
            return false;
        }
        return this.dog.field_6012 < this.stopTick;
    }

    public void method_6269() {
        this.stopTick = this.dog.field_6012 + this.currentAnimation.getLengthTicks();
        this.startTick = this.dog.field_6012;
        this.jumped = false;
        this.dog.setAnimForIdle(this.currentAnimation);
    }

    public void method_6268() {
        if (this.currentAnimation == DogAnimation.BACKFLIP) {
            this.checkJumpIfBackfilip();
        }
    }

    private void checkJumpIfBackfilip() {
        if (!this.jumped && this.dog.field_6012 - this.startTick >= 3) {
            this.jumped = true;
            this.dog.method_5993().method_6233();
        }
    }

    public void method_6270() {
        if (this.dog.getAnim() == this.currentAnimation) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    private DogAnimation getIdleAnim() {
        float r = this.dog.method_59922().method_43057();
        if (this.dog.isChopinTail()) {
            if (r <= 0.1f) {
                return DogAnimation.NONE;
            }
            if (r <= 0.4f) {
                return DogAnimation.BACKFLIP;
            }
            return DogAnimation.CHOPIN_TAIL;
        }
        if (r <= 0.02f) {
            return DogAnimation.CHOPIN_TAIL;
        }
        if (r <= 0.08f) {
            return DogAnimation.DIG;
        }
        if (r <= 0.35f) {
            return DogAnimation.STRETCH;
        }
        return DogAnimation.NONE;
    }
}

