/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai.triggerable;

import doggytalents.common.entity.Dog;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public abstract class TriggerableAction {
    protected final Dog dog;
    private ActionState state = ActionState.PENDING;
    private final boolean isTrivial;
    private final boolean canPause;
    private boolean started;

    public TriggerableAction(Dog dog, boolean trivial, boolean canPause) {
        this.dog = dog;
        this.isTrivial = trivial;
        this.canPause = canPause;
    }

    public final void start() {
        this.onStart();
        this.started = this.getState() == ActionState.RUNNING;
    }

    public final void stop() {
        this.onStop();
        this.started = false;
        this.dog.method_5942().method_6340();
    }

    public final void doTick() {
        if (this.checkOwnerDistanceStop()) {
            this.setState(ActionState.FINISHED);
            return;
        }
        this.tick();
    }

    private boolean checkOwnerDistanceStop() {
        if (!this.dog.getMode().shouldFollowOwner()) {
            return false;
        }
        if (!this.shouldStopAndFollowOwner()) {
            return false;
        }
        float max_owner_dist = this.getDistanceForFollowOwner();
        class_1309 owner = this.dog.method_35057();
        if (owner == null) {
            return false;
        }
        return owner.method_5858((class_1297)this.dog) > (double)(max_owner_dist * max_owner_dist);
    }

    public boolean isStarted() {
        return this.started;
    }

    public abstract void onStart();

    public abstract void tick();

    public abstract void onStop();

    public final boolean isTrivial() {
        return this.isTrivial;
    }

    public boolean canPreventSit() {
        return false;
    }

    public boolean canOverrideSit() {
        return false;
    }

    public boolean goBackToSitPosWhenFinished() {
        return true;
    }

    public final boolean canPause() {
        return this.canPause;
    }

    public boolean shouldStopAndFollowOwner() {
        return false;
    }

    public float getDistanceForFollowOwner() {
        return 16.0f;
    }

    public void onDogGoesOfflineWhileActive() {
    }

    public ActionState getState() {
        return this.state;
    }

    public void setState(ActionState state) {
        this.state = state;
    }

    public static enum ActionState {
        PENDING,
        RUNNING,
        FINISHED,
        PAUSED;

    }
}

