/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.event;

import doggytalents.DogVariants;
import doggytalents.DoggyAccessories;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.common.block.DogBedMaterialManager;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogDuplicationDetection;
import doggytalents.common.entity.DogSleepOnManager;
import doggytalents.common.entity.ai.WolfBegAtTreatGoal;
import doggytalents.common.entity.ai.triggerable.DogBackFlipAction;
import doggytalents.common.entity.ai.triggerable.DogPlayTagAction;
import doggytalents.common.fabric_helper.storage.FabricRecievedStarterBundleStorage;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.TrainWolfToDogData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.storage.DogRespawnStorage;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.util.LangUtil;
import doggytalents.common.util.dogpromise.DogPromiseManager;
import doggytalents.common.util.dogpromise.chunk.DTNForcedChunkManager;
import doggytalents.common.util.dogpromise.promise.DogBatchTeleportToDimensionPromise;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import doggytalents.forge_imitate.event.CanContinueSleepingEvent;
import doggytalents.forge_imitate.event.EntityJoinLevelEvent;
import doggytalents.forge_imitate.event.EntityTravelToDimensionEvent;
import doggytalents.forge_imitate.event.LivingChangeTargetEvent;
import doggytalents.forge_imitate.event.LivingDropsEvent;
import doggytalents.forge_imitate.event.LivingHurtEvent;
import doggytalents.forge_imitate.event.PlayerInteractEvent;
import doggytalents.forge_imitate.event.PlayerLoggedInEvent;
import doggytalents.forge_imitate.event.PlayerLoggedOutEvent;
import doggytalents.forge_imitate.event.PlayerWakeUpEvent;
import doggytalents.forge_imitate.event.ProjectileImpactEvent;
import doggytalents.forge_imitate.event.ServerStoppedEvent;
import doggytalents.forge_imitate.event.ServerStoppingEvent;
import doggytalents.forge_imitate.event.ServerTickEvent;
import doggytalents.forge_imitate.event.SleepFinishedTimeEvent;
import doggytalents.forge_imitate.event.TagsUpdatedEvent;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_14;
import net.minecraft.class_1493;
import net.minecraft.class_1542;
import net.minecraft.class_1547;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_8111;
import net.minecraft.class_9346;
import net.minecraft.class_9347;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ObjectUtils;

public class EventHandler {
    public final int COLLECT_RADIUS = 26;
    public final int MIN_DISTANCE_TO_TRIGGER_TELEPORT_SQR = 400;

    public void onServerTickEnd(ServerTickEvent event) {
        if (event.phase != ServerTickEvent.Phase.END) {
            return;
        }
        DogPromiseManager.tick();
        DogLocationStorage.get(event.getServer()).getOnlineDogsManager().tick();
        DogSleepOnManager.tickServer(event.getServer());
    }

    public void onServerStop(ServerStoppingEvent event) {
        DogPromiseManager.forceStop();
        DTNForcedChunkManager.onServerStop();
        class_3218 overworld = event.getServer().method_3847(class_1937.field_25179);
        if (overworld != null) {
            DogLocationStorage.get((class_1937)overworld).onServerStop(event);
        }
        DogSleepOnManager.onServerStop(event.getServer());
    }

    public void onServerStopped(ServerStoppedEvent event) {
        class_3218 overworld = event.getServer().method_3847(class_1937.field_25179);
        if (overworld != null) {
            DogLocationStorage.get((class_1937)overworld).onServerStopped(event);
        }
    }

    public void onWolfRightClickWithTreat(PlayerInteractEvent.EntityInteract event) {
        class_1937 level = event.getLevel();
        class_1799 stack = event.getItemStack();
        class_1297 target = event.getTarget();
        class_1657 owner = event.getEntity();
        if (stack.method_7909() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!(target instanceof class_1493)) {
            return;
        }
        class_1493 wolf = (class_1493)target;
        event.setCanceled(true);
        if (!EventHandler.checkValidWolf(wolf, owner)) {
            event.setCancellationResult(class_1269.field_5814);
            return;
        }
        if (level.field_9236) {
            PacketHandler.send(PacketDistributor.SERVER.noArg(), new TrainWolfToDogData(wolf.method_5628(), wolf.field_6283, wolf.field_6241));
        }
        event.setCancellationResult(class_1269.field_5812);
    }

    public static void checkAndTrainWolf(class_1657 trainer, class_1493 wolf, float yBodyRot, float yHeadRot) {
        class_1937 level = trainer.method_37908();
        if (level.field_9236) {
            return;
        }
        class_1799 stack = trainer.method_6047();
        if (stack.method_7909() != DoggyItems.TRAINING_TREAT.get()) {
            return;
        }
        if (!EventHandler.checkValidWolf(wolf, trainer)) {
            return;
        }
        if (!EventHandler.isWithinTrainWolfLimit(trainer)) {
            level.method_8421((class_1297)wolf, (byte)6);
            return;
        }
        if (!trainer.method_31549().field_7477) {
            stack.method_7934(1);
        }
        EventHandler.tameWolfIfNeccessary(wolf, trainer);
        EventHandler.rotateWolfIfNecceassary(wolf, yHeadRot, yBodyRot);
        EventHandler.trainWolf(wolf, trainer, level);
    }

    private static void rotateWolfIfNecceassary(class_1493 wolf, float yHeadRot, float yBodyRot) {
        float wanted_yBodyRot = yHeadRot;
        float wanted_dYBodyRot = class_3532.method_15381((float)yBodyRot, (float)wanted_yBodyRot);
        float approaching_dYBodyRot = class_3532.method_15363((float)wanted_dYBodyRot, (float)-25.0f, (float)25.0f);
        float approaching_yBodyRot = yBodyRot + approaching_dYBodyRot;
        wolf.field_6283 = approaching_yBodyRot = class_3532.method_15393((float)approaching_yBodyRot);
    }

    private static boolean checkValidWolf(class_1493 wolf, class_1657 owner) {
        if (!wolf.method_5805()) {
            return false;
        }
        boolean trainUntamed = (Boolean)ConfigHandler.SERVER.DISABLE_TRAIN_UNTAMED_WOLF.get() == false;
        boolean condition1 = trainUntamed && !wolf.method_6181();
        boolean condition2 = wolf.method_6181() && wolf.method_6171((class_1309)owner);
        return condition1 || condition2;
    }

    public static boolean isWithinTrainWolfLimit(class_1657 owner) {
        int respawnCnt;
        int limit = (Integer)ConfigHandler.SERVER.TRAIN_WOLF_LIMIT.get();
        if (limit <= 0) {
            return true;
        }
        MinecraftServer server = owner.method_37908().method_8503();
        DogLocationStorage locStore = DogLocationStorage.get(server);
        DogRespawnStorage respawnStore = DogRespawnStorage.get(server);
        int locCnt = locStore.getDogs((class_1309)owner).collect(Collectors.toList()).size();
        int totalTrained = locCnt + (respawnCnt = respawnStore.getDogs(owner.method_5667()).collect(Collectors.toList()).size());
        return totalTrained < limit;
    }

    public static void tameWolfIfNeccessary(class_1493 wolf, class_1657 owner) {
        if (wolf.method_6181()) {
            return;
        }
        wolf.method_6170(owner);
    }

    public static void trainWolf(class_1493 wolf, class_1657 owner, class_1937 level) {
        Dog dog = (Dog)DoggyEntityTypes.DOG.get().method_5883(level);
        if (dog == null) {
            throw new IllegalStateException("Creator function for the dog returned \"null\"");
        }
        dog.method_6173(true, true);
        dog.method_6174(owner.method_5667());
        dog.maxHealth();
        dog.method_24346(false);
        dog.method_5614(wolf.method_5618());
        dog.method_5808(wolf.method_23317(), wolf.method_23318(), wolf.method_23321(), wolf.method_36454(), wolf.method_36455());
        dog.method_5847(wolf.field_6283);
        dog.method_5636(wolf.field_6283);
        dog.method_36456(wolf.field_6283);
        class_1767 wolf_collar_color = wolf.method_6713();
        int color = wolf_collar_color.method_7787();
        AccessoryInstance dog_collar = DoggyAccessories.DYEABLE_COLLAR_THICC.get().create(color);
        if (dog_collar != null) {
            dog.addAccessory(dog_collar);
        }
        EventHandler.migrateWolfVariant(wolf, dog);
        EventHandler.migrateWolfArmor(wolf, dog);
        if (wolf.method_16914()) {
            dog.setDogCustomName(wolf.method_5797());
        }
        UUID wolf_uuid = wolf.method_5667();
        wolf.method_31472();
        if (level instanceof class_3218) {
            class_3218 sL = (class_3218)level;
            EventHandler.migrateUUID(wolf_uuid, dog, sL);
        }
        level.method_8649((class_1297)dog);
        dog.triggerAnimationAction(new DogBackFlipAction(dog));
    }

    private static void migrateUUID(UUID uuid, Dog dog, class_3218 level) {
        if (((Boolean)ConfigHandler.SERVER.DISABLE_PRESERVE_UUID.get()).booleanValue()) {
            return;
        }
        if (level.method_14190(uuid) != null) {
            return;
        }
        dog.method_5826(uuid);
    }

    private static void migrateWolfVariant(class_1493 wolf, Dog dog) {
        boolean random_var_on_pale;
        DogVariant dog_variant = DogVariantUtil.fromVanila((class_5321<class_9346>)wolf.method_58062().method_40230().orElse(class_9347.field_49725));
        boolean bl = random_var_on_pale = dog_variant == DogVariantUtil.getDefault() && (Boolean)ConfigHandler.SERVER.RANDOM_VAR_ON_PALE.get() != false;
        if (random_var_on_pale) {
            List<DogVariant> vanilla_variants = List.of(DogVariants.PALE.get(), DogVariants.RUSTY.get(), DogVariants.WOOD.get(), DogVariants.CHESTNUT.get(), DogVariants.STRIPED.get(), DogVariants.ASHEN.get(), DogVariants.SNOWY.get(), DogVariants.SPOTTED.get(), DogVariants.BLACK.get());
            dog_variant = LangUtil.getRandomItem(wolf.method_59922(), vanilla_variants).get();
        }
        dog.setDogVariant(dog_variant);
    }

    private static void migrateWolfArmor(class_1493 wolf, Dog dog) {
        if (!wolf.method_55710()) {
            return;
        }
        class_1799 armor_stack = wolf.method_56676().method_46651(1);
        dog.setWolfArmor(armor_stack);
    }

    public void onEntitySpawn(EntityJoinLevelEvent event) {
        class_1309 entity = event.getEntity();
        class_1937 level = entity.method_37908();
        if (level.field_9236) {
            return;
        }
        if (entity instanceof class_1547) {
            class_1547 skeleton = (class_1547)entity;
            skeleton.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)skeleton, Dog.class, 6.0f, 1.0, 1.2));
        } else if (entity instanceof class_1493) {
            class_1493 \u5927\u795e = (class_1493)entity;
            \u5927\u795e.field_6201.method_6277(9, (class_1352)new WolfBegAtTreatGoal(\u5927\u795e, 8.0f));
        }
    }

    public void playerLoggedIn(PlayerLoggedInEvent event) {
        if (event.getEntity().method_37908().field_9236) {
            return;
        }
        if (this.isEnableStarterBundle()) {
            class_3222 player = event.getEntity();
            FabricRecievedStarterBundleStorage storage = FabricRecievedStarterBundleStorage.get(player.method_37908().method_8503());
            if (storage == null) {
                return;
            }
            if (!storage.hasBundleAlready(player)) {
                storage.onRecievedBundle(player);
                player.method_31548().method_7394(new class_1799((class_1935)DoggyItems.STARTER_BUNDLE.get()));
            }
        }
    }

    private boolean isEnableStarterBundle() {
        return (Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.STARTING_ITEMS);
    }

    public void onProjectileHit(ProjectileImpactEvent event) {
        class_1676 levelChecker = event.getProjectile();
        if (levelChecker == null) {
            return;
        }
        class_1937 level = levelChecker.method_37908();
        if (level.field_9236) {
            return;
        }
        class_239 hitResult = event.getRayTraceResult();
        if (hitResult instanceof class_3966) {
            class_3966 hitEntity = (class_3966)hitResult;
            this.proccessEntityProjectileHitEvent(event, hitEntity);
        } else if (hitResult instanceof class_3965) {
            class_3965 hitBlock = (class_3965)hitResult;
            this.proccessBlockProjectileHitEvent(event, hitBlock);
        }
    }

    private void proccessEntityProjectileHitEvent(ProjectileImpactEvent event, class_3966 hit) {
        class_1297 entity = hit.method_17782();
        if (entity instanceof Dog) {
            Dog dog = (Dog)entity;
            this.proccessDogProjectileHitEvent(event, hit, dog);
        }
    }

    private void proccessDogProjectileHitEvent(ProjectileImpactEvent event, class_3966 hit, Dog dog) {
        class_1676 projectile = event.getProjectile();
        class_1297 projectileOnwer = projectile.method_24921();
        if (projectileOnwer == null) {
            return;
        }
        class_1309 dogOwner = dog.method_35057();
        if (projectile instanceof class_1680) {
            if (projectileOnwer == dogOwner && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.PLAY_TAG_WITH_DOG)).booleanValue() && !dog.isBusy() && !dog.method_24345()) {
                dog.triggerAction(new DogPlayTagAction(dog, dogOwner));
            }
            return;
        }
    }

    private void proccessBlockProjectileHitEvent(ProjectileImpactEvent event, class_3965 hit) {
        class_1676 projectile = event.getProjectile();
        if (!(projectile instanceof class_1681)) {
            return;
        }
        class_1937 level = projectile.method_37908();
        class_2338 pos = hit.method_17777();
        class_2350 dir = hit.method_17780();
        if (dir != class_2350.field_11036) {
            return;
        }
        class_2680 state = level.method_8320(pos);
        if (!state.method_27852(class_2246.field_27097)) {
            return;
        }
        class_2680 state_under = level.method_8320(pos.method_10074());
        if (!class_14.method_57082((class_2680)state_under)) {
            return;
        }
        class_1799 resultStack = new class_1799((class_1935)DoggyItems.ONSEN_TAMAGO.get());
        class_1542 resultEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, resultStack);
        level.method_8649((class_1297)resultEntity);
        projectile.method_5783(class_3417.field_15109, 0.5f, 0.9f + level.field_9229.method_43057() * 0.2f);
    }

    public void onEntityChangeDimension(EntityTravelToDimensionEvent event) {
        class_1297 entity = event.getEntity();
        if (entity.method_37908().field_9236) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 owner = (class_3222)entity;
            this.onOwnerChangeDimension(event, owner);
        }
    }

    private void onOwnerChangeDimension(EntityTravelToDimensionEvent event, class_3222 owner) {
        class_1937 class_19372 = owner.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 sLevel = (class_3218)class_19372;
        MinecraftServer mcServer = sLevel.method_8503();
        class_3218 fromLevel = sLevel;
        class_3218 toLevel = mcServer.method_3847(event.getDimension());
        if (fromLevel == toLevel) {
            return;
        }
        List crossOriginTpList = fromLevel.method_8390(Dog.class, owner.method_5829().method_1009(26.0, 4.0, 26.0), d -> this.isDogReadyToTeleport((Dog)d, (class_1309)owner));
        if (crossOriginTpList.isEmpty()) {
            return;
        }
        DogPromiseManager.addPromiseWithOwnerAndStartImmediately(new DogBatchTeleportToDimensionPromise(crossOriginTpList, fromLevel, owner.method_5667(), event.getDimension(), d -> this.isDogReadyToTeleport((Dog)d, (class_1309)owner)), owner);
    }

    private boolean isDogReadyToTeleport(Dog dog, class_1309 owner) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (owner == null || dog.method_6139() == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)dog.method_6139(), (Object)owner.method_5667())) {
            return false;
        }
        if (dog.method_24345()) {
            return false;
        }
        if (!dog.getMode().shouldFollowOwner()) {
            return false;
        }
        return dog.crossOriginTp();
    }

    private boolean distanceTooShortToTeleport(class_243 from, class_243 to) {
        return from.method_1025(to) < 400.0;
    }

    public void onLivingDeath(LivingDropsEvent event) {
        PackPuppyTalent.mayNotifyNearbyPackPuppy(event);
    }

    public void onTagsUpdated(TagsUpdatedEvent event) {
        DogBedMaterialManager.onTagsUpdated(event);
    }

    public void onLivingHurt(LivingHurtEvent event) {
        this.onDogPassenegerHurtInWall(event);
    }

    public void onDogPassenegerHurtInWall(LivingHurtEvent event) {
        class_1309 entity = event.getEntity();
        if (entity == null) {
            return;
        }
        if (!entity.method_5765()) {
            return;
        }
        class_1282 source = event.getSource();
        if (!source.method_49708(class_8111.field_42340)) {
            return;
        }
        class_1297 vehicle = entity.method_5854();
        if (!(vehicle instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)vehicle;
        event.setAmount(0.0f);
        event.setCanceled(true);
    }

    public void onWolfSetTarget(LivingChangeTargetEvent event) {
        class_1309 entity = event.getEntity();
        if (!((Boolean)ConfigHandler.SERVER.PREVENT_WILD_WOLVES_ANGRY.get()).booleanValue()) {
            return;
        }
        if (!(entity instanceof class_1493)) {
            return;
        }
        class_1493 \u5927\u795e = (class_1493)entity;
        if (\u5927\u795e.method_6181()) {
            return;
        }
        class_1309 new_target = event.getNewAboutToBeSetTarget();
        if (!(new_target instanceof class_1657)) {
            return;
        }
        event.setCanceled(true);
    }

    public static void onWolfTame(class_1493 wolf) {
        if (!((Boolean)ConfigHandler.SERVER.TAMED_WOLF_NON_MOB_CAP.get()).booleanValue()) {
            return;
        }
        wolf.method_5971();
    }

    public void canPlayerContinueSleeping(CanContinueSleepingEvent event) {
        DogSleepOnManager.canPlayerContinueSleeping(event);
    }

    public void beforeAllPlayerWakeUp(SleepFinishedTimeEvent event) {
        DogSleepOnManager.beforeSleepFinishedForAllPlayer(event);
    }

    public void playerWakeUpEvent(PlayerWakeUpEvent event) {
        if (!event.getEntity().method_37908().field_9236) {
            DogSleepOnManager.onPlayerWakeUp(event.getEntity());
        }
    }

    public void playerLoggedOut(PlayerLoggedOutEvent event) {
        class_3222 player = event.getEntity();
        if (player.method_37908().field_9236) {
            return;
        }
        if (!player.method_5782()) {
            return;
        }
        ArrayList<Dog> dog_list = new ArrayList<Dog>();
        for (class_1297 passenger : player.method_5685()) {
            if (passenger.method_5864() != DoggyEntityTypes.DOG.get() || !(passenger instanceof Dog)) continue;
            Dog dog = (Dog)passenger;
            dog_list.add(dog);
        }
        for (Dog dog : dog_list) {
            dog.method_5848();
        }
    }

    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        DogDuplicationDetection.beforeEntityJoinLevel(event);
    }
}

