/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.DoggyTalentsNext;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogRespawnData;
import doggytalents.common.util.NBTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class DogRespawnStorage
extends class_18 {
    private Map<UUID, DogRespawnData> respawnDataMap = Maps.newHashMap();
    private static class_18.class_8645<DogRespawnStorage> FACTORY = new class_18.class_8645(DogRespawnStorage::new, DogRespawnStorage::load, null);

    public static DogRespawnStorage get(class_1937 world) {
        if (!(world instanceof class_3218)) {
            throw new IllegalStateException("DogRespawnStorage is being accessed from the Client Side. Please report to the DTN Team.");
        }
        class_3218 overworld = world.method_8503().method_3847(class_1937.field_25179);
        class_26 storage = overworld.method_17983();
        return (DogRespawnStorage)storage.method_17924(DogRespawnStorage.storageFactory(), "doggytalentsDeadDogs");
    }

    public static DogRespawnStorage get(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        class_26 storage = overworld.method_17983();
        return (DogRespawnStorage)storage.method_17924(DogRespawnStorage.storageFactory(), "doggytalentsDeadDogs");
    }

    public Stream<DogRespawnData> getDogs(@Nonnull UUID ownerId) {
        return this.respawnDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    @Nullable
    public DogRespawnData getData(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            return this.respawnDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public DogRespawnData remove(UUID uuid) {
        if (this.respawnDataMap.containsKey(uuid)) {
            DogRespawnData storage = this.respawnDataMap.remove(uuid);
            this.method_80();
            return storage;
        }
        return null;
    }

    @Nullable
    public DogRespawnData putData(Dog dogIn) {
        UUID uuid = dogIn.method_5667();
        DogRespawnData storage = new DogRespawnData(this, uuid);
        storage.populate(dogIn);
        this.respawnDataMap.put(uuid, storage);
        this.method_80();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.respawnDataMap.keySet());
    }

    public Collection<DogRespawnData> getAll() {
        return Collections.unmodifiableCollection(this.respawnDataMap.values());
    }

    public static DogRespawnStorage load(class_2487 nbt, class_7225.class_7874 prov) {
        DogRespawnStorage store = new DogRespawnStorage();
        store.respawnDataMap.clear();
        class_2499 list = nbt.method_10554("respawnData", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 respawnCompound = list.method_10602(i);
            UUID uuid = NBTUtil.getUniqueId(respawnCompound, "uuid");
            DogRespawnData respawnData = new DogRespawnData(store, uuid);
            respawnData.read(respawnCompound);
            if (uuid == null) {
                DoggyTalentsNext.LOGGER.info("Failed to load dog respawn data. Please report to mod author...");
                DoggyTalentsNext.LOGGER.info((Object)respawnData);
                continue;
            }
            store.respawnDataMap.put(uuid, respawnData);
        }
        return store;
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 prov) {
        class_2499 list = new class_2499();
        for (Map.Entry<UUID, DogRespawnData> entry : this.respawnDataMap.entrySet()) {
            class_2487 respawnCompound = new class_2487();
            DogRespawnData respawnData = entry.getValue();
            NBTUtil.putUniqueId(respawnCompound, "uuid", entry.getKey());
            respawnData.write(respawnCompound);
            list.add((Object)respawnCompound);
        }
        compound.method_10566("respawnData", (class_2520)list);
        return compound;
    }

    public static class_18.class_8645<DogRespawnStorage> storageFactory() {
        return FACTORY;
    }
}

