/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.storage;

import com.google.common.collect.Maps;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OnlineDogLocationManager {
    private final Map<UUID, Dog> onlineDogs = Maps.newHashMap();
    private final ArrayList<UUID> toRemove = new ArrayList();
    private final DogLocationStorage storage;
    private int tickTillUpdateAllOnlineDog = 40;
    public static final Logger LOGGER = LogManager.getLogger((String)"doggytalents/dogOnlineTracker");

    public OnlineDogLocationManager(DogLocationStorage storage) {
        this.storage = storage;
    }

    public void tick() {
        if (this.onlineDogs.isEmpty()) {
            return;
        }
        this.invalidateOnlineDogs();
        this.updateAllOnlineDogs();
    }

    private void invalidateOnlineDogs() {
        for (Map.Entry<UUID, Dog> entry : this.onlineDogs.entrySet()) {
            Dog dog = entry.getValue();
            if (!dog.method_31481()) continue;
            this.toRemove.add(entry.getKey());
            if (((Boolean)ConfigHandler.SERVER.LOG_WHEN_DOG_GO_OFFLINE.get()).booleanValue()) {
                OnlineDogLocationManager.logOfflineDog(entry.getValue());
            }
            dog.dogAi.handleOfflineDog();
        }
        if (this.toRemove.isEmpty()) {
            return;
        }
        for (UUID x : this.toRemove) {
            this.onlineDogs.remove(x);
        }
        this.toRemove.clear();
    }

    public void onDogGoOnline(Dog dog) {
        this.onlineDogs.put(dog.method_5667(), dog);
    }

    public Optional<Dog> getOnlineDog(UUID dogId) {
        Dog dog = this.onlineDogs.get(dogId);
        if (dog != null && dog.method_31481()) {
            return Optional.empty();
        }
        return Optional.ofNullable(dog);
    }

    private void updateAllOnlineDogs() {
        if (--this.tickTillUpdateAllOnlineDog > 0) {
            return;
        }
        this.tickTillUpdateAllOnlineDog = 40;
        for (Map.Entry<UUID, Dog> entry : this.onlineDogs.entrySet()) {
            Dog dog = entry.getValue();
            if (dog.method_31481() || !dog.dogTrackingTracker.isTracking()) continue;
            this.syncDataToStorage(this.storage, dog);
        }
    }

    private void syncDataToStorage(DogLocationStorage storage, Dog dog) {
        DogLocationData data = storage.getOrCreateData(dog);
        if (data == null) {
            return;
        }
        data.update(dog);
    }

    public void onServerStop() {
        this.unrideAllDogOnPlayer();
        if (!((Boolean)ConfigHandler.SERVER.LOG_WHEN_DOG_GO_OFFLINE.get()).booleanValue()) {
            this.onlineDogs.clear();
        }
        this.toRemove.clear();
    }

    public void onServerStopped() {
        if (!((Boolean)ConfigHandler.SERVER.LOG_WHEN_DOG_GO_OFFLINE.get()).booleanValue()) {
            return;
        }
        for (Map.Entry<UUID, Dog> entry : this.onlineDogs.entrySet()) {
            OnlineDogLocationManager.logOfflineDog(entry.getValue());
        }
        this.onlineDogs.clear();
    }

    public static void logOfflineDog(Dog dog) {
        if (dog.method_6139() == null) {
            return;
        }
        if (dog.locationUpdatedUponRemove == null) {
            return;
        }
        class_1297.class_5529 remove_reason = dog.method_35049();
        class_2338 pos = dog.method_24515();
        String name_str = dog.method_5477().getString();
        String pos_str = pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260();
        String type_str = remove_reason == null ? "WHAT?" : remove_reason.toString();
        String log_msg = dog.locationUpdatedUponRemove.getFormattedLog(name_str, pos_str, type_str);
        LOGGER.debug(log_msg);
    }

    private void unrideAllDogOnPlayer() {
        for (Map.Entry<UUID, Dog> entry : this.onlineDogs.entrySet()) {
            class_1297 vehicle;
            Dog dog = entry.getValue();
            if (dog.method_31481() || !dog.method_5765() || !((vehicle = dog.method_5854()) instanceof class_1657)) continue;
            dog.method_18375();
        }
    }

    public static enum RemoveState {
        NONE("Dog [ %s ] failed to update location upon going offline at [ %s ] with type [ %s ]"),
        UPDATED("Dog [ %s ] has gone Offline at [ %s ] with type [ %s ]"),
        UNLOADED_TO_RESPAWN("Dog [ %s ] has been unloaded to Respawn Storage"),
        REMOVED("Untamed Dog [ %s ] has been removed."),
        REMOVE_TRUSTED("Dog [ %s ] has been trustfully removed at [ %s ] with type [ %s ]");

        private final String unformattedLog;

        private RemoveState(String unformattedLog) {
            this.unformattedLog = unformattedLog;
        }

        public String getFormattedLog(String name, String pos, String type) {
            if (name == null) {
                name = "??";
            }
            if (pos == null) {
                pos = "??";
            }
            if (type == null) {
                type = "??";
            }
            return String.format(this.unformattedLog, name, pos, type);
        }
    }
}

