/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools;

import doggytalents.DoggyTalents;
import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.api.impl.IDogRangedAttackManager;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.misc.DogThrownTrident;
import doggytalents.common.talent.PackPuppyTalent;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.ShootHandler;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.ItemUtil;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5321;
import org.apache.commons.lang3.tuple.Pair;

public class DoggyToolsRangedAttack
implements IDogRangedAttackManager {
    private Optional<DogThrownTrident> awaitingTrident = Optional.empty();
    private int delayedCrossbowAttack;

    @Override
    public boolean isApplicable(AbstractDog dog) {
        return DoggyToolsRangedAttack.getActiveShootHandler(dog) != ShootHandler.NONE;
    }

    @Override
    public boolean updateUsingWeapon(IDogRangedAttackManager.UsingWeaponContext ctx) {
        this.validateAwaitingTrident();
        ShootHandler handler = DoggyToolsRangedAttack.getActiveShootHandler(ctx.dog);
        return handler.updateUsingWeapon(this, ctx);
    }

    public void shootProjectile(AbstractDog dog, class_1676 proj, class_1309 target, class_3414 shoot_sound) {
        double aim_y_offset_l_xz_influence = 0.2;
        double aim_y_offset_l_xz_influence_down = 0.1;
        double dx = target.method_23317() - dog.method_23317();
        double dz = target.method_23321() - dog.method_23321();
        double l_xz = Math.sqrt(dx * dx + dz * dz);
        double aim_y = target.method_23318() + 0.5 * (double)target.method_17682();
        double dy = aim_y - proj.method_23318();
        dy = dy > 0.0 ? (dy += l_xz * 0.2) : (dy += l_xz * 0.1);
        double shoot_dir_x = dx;
        double shoot_dir_y = dy;
        double shoot_dir_z = dz;
        float power = 1.6f;
        float error_window = 2.0f;
        proj.method_7485(shoot_dir_x, shoot_dir_y, shoot_dir_z, power, error_window);
        dog.method_5783(shoot_sound, 1.0f, 1.0f / (dog.method_59922().method_43057() * 0.4f + 0.8f));
        dog.method_37908().method_8649((class_1297)proj);
    }

    @Override
    public void onStop(AbstractDog dog) {
        dog.method_6021();
        this.awaitingTrident = Optional.empty();
    }

    private void validateAwaitingTrident() {
        if (this.awaitingTrident == null) {
            return;
        }
        if (!this.awaitingTrident.isPresent()) {
            return;
        }
        DogThrownTrident trident = this.awaitingTrident.get();
        if (!trident.method_5805()) {
            this.awaitingTrident = Optional.empty();
            return;
        }
    }

    public boolean hasAwaitingTrident() {
        return this.awaitingTrident != null && this.awaitingTrident.isPresent();
    }

    public void setAwaitingTrident(DogThrownTrident trident) {
        this.awaitingTrident = Optional.ofNullable(trident);
    }

    public void decDelayedCrossbowAttack() {
        if (this.delayedCrossbowAttack > 0) {
            --this.delayedCrossbowAttack;
        }
    }

    public void setDelayedCrossbowAttack(int x) {
        this.delayedCrossbowAttack = x;
    }

    public int getDelayedCrossbowAttack() {
        return this.delayedCrossbowAttack;
    }

    public static boolean isTridentAndEligible(AbstractDog dog, class_1799 stack) {
        if (!DogUtil.isTrident(stack)) {
            return false;
        }
        if (!((Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_USE_TRIDENT.get()).booleanValue()) {
            return false;
        }
        class_1937 class_19372 = dog.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 sLevel = (class_3218)class_19372;
        return ItemUtil.getEnchantmentLevelForItem((class_5321<class_1887>)class_1893.field_9120, dog.method_56673(), stack) >= 2;
    }

    public static Optional<Pair<ItemStackHandler, Integer>> findArrowsInInventory(AbstractDog dog) {
        Optional talentInstOptional = dog.getTalent(DoggyTalents.DOGGY_TOOLS);
        if (!talentInstOptional.isPresent()) {
            return Optional.empty();
        }
        Object t = talentInstOptional.get();
        if (!(t instanceof DoggyToolsTalent)) {
            return Optional.empty();
        }
        DoggyToolsTalent tools = (DoggyToolsTalent)t;
        ItemStackHandler inv = tools.getTools();
        int id = DoggyToolsRangedAttack.findArrowStackInInventory(inv);
        if (id >= 0) {
            return Optional.of(Pair.of((Object)((Object)inv), (Object)id));
        }
        talentInstOptional = dog.getTalent(DoggyTalents.PACK_PUPPY);
        if (!talentInstOptional.isPresent()) {
            return Optional.empty();
        }
        Object t2 = talentInstOptional.get();
        if (!(t2 instanceof PackPuppyTalent)) {
            return Optional.empty();
        }
        PackPuppyTalent packPup = (PackPuppyTalent)t2;
        inv = packPup.inventory();
        id = DoggyToolsRangedAttack.findArrowStackInInventory(inv);
        if (id >= 0) {
            return Optional.of(Pair.of((Object)((Object)inv), (Object)id));
        }
        return Optional.empty();
    }

    private static int findArrowStackInInventory(ItemStackHandler inv) {
        if (inv == null) {
            return -1;
        }
        int selected_id = -1;
        for (int i = 0; i < inv.getSlots(); ++i) {
            class_1799 stack = inv.getStackInSlot(i);
            if (!(stack.method_7909() instanceof class_1744)) continue;
            selected_id = i;
            break;
        }
        return selected_id;
    }

    public static boolean isInfinityBow(class_1799 bowStack, AbstractDog dog) {
        class_1937 class_19372 = dog.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 sLevel = (class_3218)class_19372;
        return ItemUtil.getEnchantmentLevelForItem((class_5321<class_1887>)class_1893.field_9125, dog.method_56673(), bowStack) > 0;
    }

    public static ShootHandler getActiveShootHandler(AbstractDog dog) {
        class_1799 mainhand_item = dog.method_6047();
        return DoggyToolsRangedAttack.getShootHandler(mainhand_item, dog);
    }

    public static ShootHandler getShootHandler(class_1799 stack, AbstractDog dog) {
        boolean eligible;
        if (stack.method_7960()) {
            return ShootHandler.NONE;
        }
        if (stack.method_7909() instanceof class_1753) {
            boolean bl = eligible = DoggyToolsRangedAttack.isInfinityBow(stack, dog) || DoggyToolsRangedAttack.findArrowsInInventory(dog).isPresent();
            if (eligible) {
                return ShootHandler.BOW;
            }
        }
        if (stack.method_7909() instanceof class_1764 && (eligible = DoggyToolsRangedAttack.findArrowsInInventory(dog).isPresent())) {
            return ShootHandler.CROSSBOW;
        }
        if (DoggyToolsRangedAttack.isTridentAndEligible(dog, stack)) {
            return ShootHandler.TRIDENT;
        }
        return ShootHandler.NONE;
    }
}

