/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent.doggy_tools.tool_actions;

import doggytalents.DoggyBlocks;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.DoggyToolsItemHandler;
import doggytalents.common.talent.doggy_tools.DoggyToolsTalent;
import doggytalents.common.talent.doggy_tools.tool_actions.ToolAction;
import doggytalents.common.util.RingSearchIterator;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;

public class DogFarmerAction
extends ToolAction {
    private static final int SEARCH_RADIUS = 4;
    private class_2338 nextFarmBlock;
    private int tickTillPathRecalc;
    private int tickTillResearch;
    private int checkAgainTimestamp;
    private class_1799 seedTarget = class_1799.field_8037;
    private class_1799 replacementStack = class_1799.field_8037;

    public DogFarmerAction(Dog dog, DoggyToolsTalent talent) {
        super(dog, talent);
    }

    @Override
    public void onStart() {
        this.tickTillPathRecalc = 3;
        this.tickTillResearch = 20;
    }

    @Override
    public void tick() {
        class_1799 hurtStack;
        FarmState farmState;
        class_1799 stack;
        boolean owner_check;
        boolean bl = owner_check = (Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_WANDER_FARM.get() == false || this.dog.getMode().shouldFollowOwner();
        if (owner_check) {
            class_1309 owner = this.dog.method_35057();
            if (owner == null || this.dog.method_5858((class_1297)owner) > (double)this.talent.getMaxOwnerDistSqr()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (!owner.method_5805() || owner.method_7325()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }
        if ((stack = this.dog.method_5998(class_1268.field_5808)) == null || !(stack.method_7909() instanceof class_1794)) {
            this.setState(TriggerableAction.ActionState.FINISHED);
            return;
        }
        if (this.tickTillPathRecalc > 0) {
            --this.tickTillPathRecalc;
        }
        this.refreshTargetSeed();
        if (this.nextFarmBlock == null && --this.tickTillResearch <= 0) {
            this.tickTillResearch = 10;
            this.nextFarmBlock = this.findNextFarmBlock();
            if (this.nextFarmBlock == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }
        if ((farmState = this.getFarmState(this.nextFarmBlock)) == FarmState.NONE) {
            this.nextFarmBlock = null;
            return;
        }
        boolean hurtTools = this.moveToAndFarmBlock(farmState);
        if (hurtTools && this.dog.method_59922().method_43048(3) == 0 && (hurtStack = this.dog.method_6047()) != null && hurtStack.method_7909() instanceof class_1794) {
            hurtStack.method_7970(1, (class_1309)this.dog, class_1304.field_6173);
        }
    }

    private void refreshTargetSeed() {
        boolean isDogHarvestable;
        class_1799 stack;
        this.seedTarget = class_1799.field_8037;
        this.replacementStack = class_1799.field_8037;
        DoggyToolsItemHandler inv = this.talent.getTools();
        int harvest_slot_id = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            stack = inv.getStackInSlot(i);
            isDogHarvestable = this.getCropBlockFromItem(stack).isPresent();
            if (!isDogHarvestable) continue;
            this.seedTarget = stack.method_7972();
            harvest_slot_id = i;
            break;
        }
        if (this.seedTarget.method_7960()) {
            return;
        }
        int replace_slot_id = harvest_slot_id + 1;
        if (replace_slot_id < inv.getSlots() && (isDogHarvestable = this.getCropBlockFromItem(stack = inv.getStackInSlot(replace_slot_id)).isPresent()) && !stack.method_31574(this.seedTarget.method_7909())) {
            this.replacementStack = stack.method_7972();
        }
    }

    private boolean moveToAndFarmBlock(FarmState farmState) {
        class_2338 dog_b0 = this.dog.method_24515();
        class_1408 dog_nav = this.dog.method_5942();
        boolean shouldHurtTool = false;
        this.dog.method_5988().method_19615(class_243.method_24955((class_2382)this.nextFarmBlock));
        if (dog_nav.method_6357() && dog_b0.method_10262((class_2382)this.nextFarmBlock) <= 4.0) {
            this.dog.method_5962().method_6239((double)this.nextFarmBlock.method_10263(), (double)this.nextFarmBlock.method_10264(), (double)this.nextFarmBlock.method_10260(), 1.0);
        }
        if (dog_b0.method_10262((class_2382)this.nextFarmBlock) < 4.0) {
            switch (farmState.ordinal()) {
                case 2: {
                    this.harvest();
                    shouldHurtTool = true;
                    break;
                }
                case 1: {
                    this.placeSeed();
                    shouldHurtTool = true;
                    break;
                }
            }
            this.nextFarmBlock = null;
            return shouldHurtTool;
        }
        if (this.tickTillPathRecalc <= 0) {
            this.tickTillPathRecalc = 20;
            dog_nav.method_6337((double)this.nextFarmBlock.method_10263(), (double)this.nextFarmBlock.method_10264(), (double)this.nextFarmBlock.method_10260(), 1.0);
        }
        return shouldHurtTool;
    }

    @Override
    public void onStop() {
        this.setState(TriggerableAction.ActionState.PENDING);
        this.nextFarmBlock = null;
        this.dog.method_5673(class_1304.field_6173, class_1799.field_8037);
    }

    @Override
    public boolean shouldUse(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (!(stack.method_7909() instanceof class_1794)) {
            return false;
        }
        if (this.dog.field_6012 < this.checkAgainTimestamp) {
            return false;
        }
        this.checkAgainTimestamp = this.dog.field_6012 + 30;
        this.refreshTargetSeed();
        this.nextFarmBlock = this.findNextFarmBlock();
        return this.nextFarmBlock != null;
    }

    private class_2338 findNextFarmBlock() {
        class_2338 bp = this.dog.method_24515();
        if (this.seedTarget == null || this.seedTarget.method_7960()) {
            return null;
        }
        boolean owner_check = (Boolean)ConfigHandler.SERVER.DOGGY_TOOLS_WANDER_FARM.get() == false || this.dog.getMode().shouldFollowOwner();
        class_1309 owner = null;
        if (owner_check && (owner = this.dog.method_35057()) == null) {
            return null;
        }
        for (class_2338 pos : RingSearchIterator.createWithRandom(bp, 4, 4, true, this.dog.method_59922())) {
            if (owner != null && owner.method_5707(class_243.method_24955((class_2382)pos)) + 1.0 >= (double)this.talent.getMaxOwnerDistSqr() || this.getFarmState(pos) == FarmState.NONE) continue;
            return pos;
        }
        return null;
    }

    private void placeSeed() {
        class_2680 wheatState = this.getCropBlockFromItem(this.replacementStack.method_7960() ? this.seedTarget : this.replacementStack).orElse(DoggyBlocks.RICE_CROP.get()).method_9564();
        this.dog.method_37908().method_8501(this.nextFarmBlock.method_10084(), wheatState);
        class_2498 soundtype = wheatState.method_26204().method_9573(wheatState);
        this.dog.method_5783(soundtype.method_10598(), (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
    }

    private void harvest() {
        this.dog.method_37908().method_22352(this.nextFarmBlock.method_10084(), true);
    }

    private FarmState getFarmState(class_2338 pos) {
        if (pos == null) {
            return FarmState.NONE;
        }
        if (this.seedTarget == null || this.seedTarget.method_7960()) {
            return FarmState.NONE;
        }
        class_2680 state = this.dog.method_37908().method_8320(pos);
        if (state.method_26204() != class_2246.field_10362) {
            return FarmState.NONE;
        }
        class_2680 state_above = this.dog.method_37908().method_8320(pos.method_10084());
        if (state_above.method_26204() == class_2246.field_10124) {
            return FarmState.PLACE_SEED;
        }
        Optional<class_2302> crop_block_optional = this.getCropBlockFromItem(this.seedTarget);
        if (!crop_block_optional.isPresent()) {
            return FarmState.NONE;
        }
        class_2302 crop_block = crop_block_optional.get();
        if (state_above.method_26204() == crop_block && crop_block.method_9825(state_above)) {
            return FarmState.HARVEST;
        }
        return FarmState.NONE;
    }

    private Optional<class_2302> getCropBlockFromItem(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (!(item instanceof class_1747)) {
            return Optional.empty();
        }
        class_1747 block_item = (class_1747)item;
        class_2248 block = block_item.method_7711();
        if (!(block instanceof class_2302)) {
            return Optional.empty();
        }
        class_2302 crop_block = (class_2302)block;
        return Optional.of(crop_block);
    }

    private static enum FarmState {
        NONE,
        PLACE_SEED,
        HARVEST;

    }
}

