/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.inferface.InferTypeContext;
import doggytalents.api.registry.Talent;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogNodeEvaluator;
import doggytalents.common.fabric_helper.util.FabricUtil;
import doggytalents.common.storage.DogLocationData;
import doggytalents.common.storage.DogLocationStorage;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.common.util.dogpromise.DogPromiseManager;
import doggytalents.common.util.dogpromise.promise.DogDistantTeleportToBedPromise;
import doggytalents.common.util.dogpromise.promise.DogDistantTeleportToOwnerCrossDimensionPromise;
import doggytalents.common.util.dogpromise.promise.DogDistantTeleportToOwnerPromise;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_14;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_3959;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_7;
import net.minecraft.class_9;
import net.minecraft.server.MinecraftServer;

public class DogUtil {
    private static List<Character> INVALID_NAME_CHARS = List.of(Character.valueOf('\"'));

    public static boolean dynamicSearchAndTeleportToOwnwer(Dog dog, class_1309 owner, int radius) {
        class_2338 target = owner.method_5624() || dog.avoidGoInFrontOfOwnerManager.isActive() ? CachedSearchUtil.getRandomSafePosUsingPoolExcludeInfrontOfOwner(dog, owner, owner.method_24515(), radius, 1) : CachedSearchUtil.getRandomSafePosUsingPool(dog, owner.method_24515(), radius, 1);
        if (target == null) {
            return false;
        }
        DogUtil.teleportDogAbs(dog, target);
        return true;
    }

    public static boolean dynamicSearchAndTeleportToOwnwerInBatch(class_1937 level, List<Dog> dogs, class_1309 owner, int radius) {
        if (dogs.isEmpty()) {
            return false;
        }
        List<class_2338> safePosList = owner.method_5624() ? CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(level, dogs, owner, owner.method_24515(), radius, 1) : CachedSearchUtil.getAllSafePosUsingPool(level, dogs, owner.method_24515(), radius, 1);
        if (safePosList.isEmpty()) {
            return false;
        }
        for (Dog dog : dogs) {
            int r_indx = dog.method_59922().method_43048(safePosList.size());
            DogUtil.teleportDogAbs(dog, safePosList.get(r_indx));
        }
        return true;
    }

    public static boolean dynamicSearchAndTeleportToOwnwerInBatchMaxDensity(class_1937 level, List<Dog> dogs, class_1309 owner, int radius, int max_density) {
        if (dogs.isEmpty()) {
            return false;
        }
        List<class_2338> safePosList = owner.method_5624() ? CachedSearchUtil.getAllSafePosUsingPoolExcludeInfrontOfOwner(level, dogs, owner, owner.method_24515(), radius, 1) : CachedSearchUtil.getAllSafePosUsingPool(level, dogs, owner.method_24515(), radius, 1);
        if (safePosList.isEmpty()) {
            return false;
        }
        ArrayList<Integer> densityMap = new ArrayList<Integer>(safePosList.size());
        for (int i = 0; i < safePosList.size(); ++i) {
            densityMap.add(0);
        }
        ArrayList<Dog> sorted_dogs = new ArrayList<Dog>(dogs);
        Collections.sort(sorted_dogs, new EntityUtil.Sorter((class_1297)owner));
        for (Dog dog : sorted_dogs) {
            if (safePosList.isEmpty()) break;
            int r_indx = dog.method_59922().method_43048(safePosList.size());
            DogUtil.teleportDogAbs(dog, safePosList.get(r_indx));
            int density_count = (Integer)densityMap.get(r_indx) + 1;
            if (density_count >= max_density) {
                densityMap.remove(r_indx);
                safePosList.remove(r_indx);
                continue;
            }
            densityMap.set(r_indx, density_count);
        }
        return true;
    }

    public static boolean dynamicSearchAndTeleportToBlockPos(Dog dog, class_2338 pos, int radius) {
        class_2338 target = CachedSearchUtil.getRandomSafePosUsingPool(dog, pos, radius, 1);
        if (target == null) {
            return false;
        }
        DogUtil.teleportDogAbs(dog, target);
        return true;
    }

    public static boolean guessAndTryToTeleportToOwner(Dog dog, class_1309 owner, int radius) {
        class_2338 owner_b0 = owner.method_24515();
        for (int i = 0; i < 10; ++i) {
            int randZ;
            int randY;
            int randX = owner_b0.method_10263() + EntityUtil.getRandomNumber((class_1309)dog, -radius, radius);
            class_2338 b0 = new class_2338(randX, randY = owner_b0.method_10264() + EntityUtil.getRandomNumber((class_1309)dog, -1, 1), randZ = owner_b0.method_10260() + EntityUtil.getRandomNumber((class_1309)dog, -radius, radius));
            if (!DogUtil.wantToTeleportToThePosition(dog, owner, b0)) continue;
            DogUtil.teleportDogAbs(dog, b0);
            return true;
        }
        return false;
    }

    public static boolean guessAndTryToTeleportToBlockPos(Dog dog, class_2338 pos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int randZ;
            int randY;
            int randX = pos.method_10263() + EntityUtil.getRandomNumber((class_1309)dog, -radius, radius);
            class_2338 b0 = new class_2338(randX, randY = pos.method_10264() + EntityUtil.getRandomNumber((class_1309)dog, -1, 1), randZ = pos.method_10260() + EntityUtil.getRandomNumber((class_1309)dog, -radius, radius));
            if (!DogUtil.isTeleportSafeBlock(dog, b0, null)) continue;
            DogUtil.teleportDogAbs(dog, b0);
            return true;
        }
        return false;
    }

    public static boolean wantToTeleportToThePosition(Dog dog, class_1309 owner, class_2338 pos) {
        class_2338 owner_b0 = owner.method_24515();
        boolean flag = (class_3532.method_15382((int)(owner_b0.method_10263() - pos.method_10263())) >= 2 || class_3532.method_15382((int)(owner_b0.method_10260() - pos.method_10260())) >= 2) && DogUtil.isTeleportSafeBlock(dog, pos, owner) && (!owner.method_5624() && !dog.avoidGoInFrontOfOwnerManager.isActive() || !DogUtil.posWillCollideWithOwnerMovingForward(dog, owner, pos));
        return flag;
    }

    public static boolean posWillCollideWithOwnerMovingForward(Dog dog, class_1309 owner, class_2338 pos) {
        float dz1;
        float a1;
        float dx1;
        class_243 ownerLookUnitVector;
        double DISTANCE_AWAY = 1.5;
        class_243 ownerPos = owner.method_19538();
        class_243 ownerPos2d = new class_243(ownerPos.method_10216(), 0.0, ownerPos.method_10215());
        class_243 targetPos2d = new class_243((double)pos.method_10263() + 0.5, 0.0, (double)pos.method_10260() + 0.5);
        double x = DogUtil.distanceFromPointToLineOfUnitVector2DSqr(targetPos2d, ownerPos2d, ownerLookUnitVector = new class_243((double)(dx1 = -class_3532.method_15374((float)((a1 = owner.method_5791()) * ((float)Math.PI / 180)))), 0.0, (double)(dz1 = class_3532.method_15362((float)(a1 * ((float)Math.PI / 180))))));
        return !(x < 0.0) && !(x > 1.5);
    }

    public static boolean hasLineOfSightToOwnerAtPos(Dog dog, class_1309 owner, class_2338 pos) {
        class_243 pos2;
        class_243 pos1 = new class_243((double)pos.method_10263() + 0.5, (double)((float)pos.method_10264() + owner.method_5751()), (double)pos.method_10260() + 0.5);
        if (pos1.method_1022(pos2 = new class_243(owner.method_23317(), owner.method_23318() + (double)owner.method_5751(), owner.method_23321())) > 128.0) {
            return false;
        }
        return dog.method_37908().method_17742(new class_3959(pos1, pos2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)dog)).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean isTeleportSafeBlock(Dog dog, class_2338 pos, @Nullable class_1309 owner) {
        class_7 pathnodetype = class_14.method_57625((class_1308)dog, (class_2338)pos.method_25503());
        boolean alterationWalkable = false;
        class_7 infer_type = dog.inferType(pathnodetype, InferTypeContext.forTeleport(owner));
        if (infer_type == class_7.field_12) {
            alterationWalkable = true;
        }
        if (dog.canDogFly() && pathnodetype == class_7.field_7) {
            alterationWalkable = true;
        }
        if (dog.method_5753() && pathnodetype == class_7.field_7 && dog.method_37908().method_8316(pos.method_10074()).method_15767(class_3486.field_15518)) {
            alterationWalkable = true;
        }
        if (pathnodetype != class_7.field_12 && !alterationWalkable) {
            return false;
        }
        class_2338 blockpos = pos.method_10059((class_2382)dog.method_24515());
        return dog.method_37908().method_8587((class_1297)dog, dog.method_5829().method_996(blockpos));
    }

    public static boolean isTeleportSafeBlockMidAir(Dog dog, class_2338 pos) {
        class_7 pathnodetype = class_14.method_57625((class_1308)dog, (class_2338)pos.method_25503());
        if (pathnodetype != class_7.field_7) {
            return false;
        }
        class_2338 blockpos = pos.method_10059((class_2382)dog.method_24515());
        return dog.method_37908().method_8587((class_1297)dog, dog.method_5829().method_996(blockpos));
    }

    public static double distanceFromPointToLineOfUnitVector2DSqr(class_243 A, class_243 B, class_243 v) {
        class_243 u = A.method_1019(B.method_1021(-1.0));
        double dot_u_v = u.method_1026(v);
        if (dot_u_v < 0.0) {
            return -1.0;
        }
        double dis_sqr = u.method_1027() - dot_u_v * dot_u_v;
        return dis_sqr;
    }

    public static boolean canPathReachTargetBlock(Dog dog, @Nonnull class_11 path, class_2338 pos, int maxDY_up, int maxDY_down) {
        class_9 endNode = path.method_45();
        if (endNode == null) {
            return false;
        }
        int dx = endNode.field_40 - pos.method_10263();
        int dz = endNode.field_38 - pos.method_10260();
        int d_sqr = dx * dx + dz * dz;
        int dy = pos.method_10264() - endNode.field_39;
        return d_sqr <= 1 && -maxDY_down <= dy && dy <= maxDY_up;
    }

    public static boolean pathGoingInFrontOfOwner(Dog dog) {
        class_1408 n = dog.method_5942();
        class_11 p = n.method_6345();
        if (p == null || p.method_38() <= 0) {
            return false;
        }
        class_1309 owner = dog.method_35057();
        if (owner == null) {
            return false;
        }
        int i0 = p.method_39();
        int i_end = class_3532.method_15340((int)(i0 + 5), (int)0, (int)p.method_38());
        for (int i = i0; i < i_end; ++i) {
            boolean flag = DogUtil.posWillCollideWithOwnerMovingForward(dog, owner, p.method_31031(i));
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean mayGetPushedIntoHazard(Dog dog, class_243 pushVec) {
        if (!dog.method_24828()) {
            return false;
        }
        class_243 dog_v0 = pushVec;
        class_243 dog_v01 = new class_243(dog_v0.field_1352, 0.0, dog_v0.field_1350);
        if (dog_v01.field_1352 == 0.0 && dog_v01.field_1350 == 0.0) {
            return false;
        }
        class_243 dog_v1 = dog_v01;
        class_243 dog_p0 = dog.method_19538();
        class_243 dog_p01 = new class_243(dog_p0.field_1352 + dog_v1.field_1352, dog_p0.field_1351, dog_p0.field_1350 + dog_v1.field_1350);
        class_2338 dog_b1 = new class_2338(class_3532.method_15357((double)dog_p01.field_1352), class_3532.method_15357((double)dog_p01.field_1351), class_3532.method_15357((double)dog_p01.field_1350));
        class_7 blockType = dog.getBlockPathTypeViaAlterations(dog_b1);
        if (FabricUtil.getDanger(blockType) != null) {
            return true;
        }
        if (blockType != class_7.field_7) {
            return false;
        }
        boolean noWalkable = true;
        for (int i = 1; i <= dog.method_5850(); ++i) {
            class_7 type = dog.getBlockPathTypeViaAlterations(dog_b1);
            if (type == class_7.field_7) continue;
            noWalkable = type != class_7.field_12;
            break;
        }
        return noWalkable;
    }

    public static boolean moveToIfReachOrElse(Dog dog, class_2338 pos, double speedModifier, int maxDY_up, int maxDY_down, Consumer<Dog> orElse) {
        class_11 p = dog.method_5942().method_6348(pos, 1);
        if (p == null) {
            orElse.accept(dog);
            return false;
        }
        if (DogUtil.canPathReachTargetBlock(dog, p, pos, maxDY_up, maxDY_down)) {
            dog.method_5942().method_6334(p, speedModifier);
            return true;
        }
        orElse.accept(dog);
        return false;
    }

    public static void moveToOwnerOrTeleportIfFarAway(Dog dog, class_1309 owner, double speedModifier, double distanceToTeleportSqr, boolean continueToMoveWhenTryTp, boolean forceTeleport, double distanceToForceTeleportSqr, int dY) {
        if (owner == null) {
            return;
        }
        double distance = dog.method_5858((class_1297)owner);
        if (!dog.method_60953() && !dog.method_5765()) {
            if (distance >= distanceToForceTeleportSqr) {
                if (forceTeleport) {
                    DogUtil.dynamicSearchAndTeleportToOwnwer(dog, owner, 4);
                } else {
                    DogUtil.guessAndTryToTeleportToOwner(dog, owner, 4);
                }
            } else if (distance >= distanceToTeleportSqr) {
                DogUtil.guessAndTryToTeleportToOwner(dog, owner, 4);
                if (continueToMoveWhenTryTp) {
                    dog.method_5942().method_6335((class_1297)owner, speedModifier);
                }
            } else {
                dog.method_5942().method_6335((class_1297)owner, speedModifier);
            }
        }
    }

    public static List<Dog> getOtherIncapacitatedDogNearby(Dog dog) {
        int SEARCH_RADIUS = 12;
        List l = dog.method_37908().method_8390(Dog.class, dog.method_5829().method_1009((double)SEARCH_RADIUS, 2.0, (double)SEARCH_RADIUS), d -> d.isDefeated());
        return l;
    }

    public static void attemptToTeleportDogNearbyOrSendPromise(@Nonnull UUID dogUUID, @Nonnull class_3222 owner) {
        class_1937 class_19372 = owner.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 sLevel = (class_3218)class_19372;
            class_1297 e = sLevel.method_14190(dogUUID);
            if (e != null && e instanceof Dog) {
                Dog d = (Dog)e;
                DogUtil.dynamicSearchAndTeleportToOwnwer(d, (class_1309)owner, 4);
            } else {
                MinecraftServer server;
                DogLocationStorage storage = DogLocationStorage.get((class_1937)sLevel);
                DogLocationData data = storage.getData(dogUUID);
                if (data == null) {
                    return;
                }
                class_243 dataPos = data.getPos();
                if (dataPos == null) {
                    return;
                }
                class_2338 pos = new class_2338(class_3532.method_15357((double)dataPos.field_1352), class_3532.method_15357((double)dataPos.field_1351), class_3532.method_15357((double)dataPos.field_1350));
                class_5321 dataDim = data.getDimension();
                if (dataDim == null) {
                    dataDim = class_1937.field_25179;
                }
                if ((server = owner.method_5682()) == null) {
                    return;
                }
                class_3218 dogLevel = server.method_3847(dataDim);
                if (dogLevel == null) {
                    return;
                }
                if (dogLevel != sLevel && ((Boolean)ConfigHandler.SERVER.CONDUCTING_BONE_CROSS_ORIGIN.get()).booleanValue()) {
                    DogPromiseManager.addPromiseWithOwner(new DogDistantTeleportToOwnerCrossDimensionPromise(dogUUID, (class_1309)owner, pos, dogLevel, sLevel), owner);
                } else {
                    DogPromiseManager.addPromiseWithOwner(new DogDistantTeleportToOwnerPromise(dogUUID, (class_1309)owner, pos), owner);
                }
            }
        }
    }

    public static void attemptToTeleportDogToBedOrSendPromise(@Nonnull Dog dog) {
        Optional<class_2338> bedPos = dog.getBedPos();
        if (!bedPos.isPresent()) {
            return;
        }
        class_1923 chunkpos = new class_1923(bedPos.get());
        class_1309 owner = dog.method_35057();
        if (dog.method_37908().method_8393(chunkpos.field_9181, chunkpos.field_9180)) {
            if (DogUtil.isTeleportSafeBlockMidAir(dog, bedPos.get().method_10084())) {
                DogUtil.teleportDogAbs(dog, bedPos.get().method_10084());
                dog.method_24346(true);
            }
        } else if (owner != null && owner instanceof class_3222) {
            class_3222 sP = (class_3222)owner;
            DogPromiseManager.addPromiseWithOwner(new DogDistantTeleportToBedPromise(dog), sP);
        }
    }

    public static Dog findBiggestDog(List<Dog> dogs) {
        if (dogs.isEmpty()) {
            return null;
        }
        Dog biggest_dog = dogs.get(0);
        for (Dog dog : dogs) {
            if (dog.getDogSize().getId() <= biggest_dog.getDogSize().getId()) continue;
            biggest_dog = dog;
        }
        return biggest_dog;
    }

    public static boolean isWalkNodeEvaluatorOpenPos(Dog dog, class_2338 pos) {
        return DogNodeEvaluator.dogGetPathTypeFromState((class_1922)dog.method_37908(), pos) == class_7.field_7;
    }

    public static boolean isWalkNodeEvaluatorBlockedPos(Dog dog, class_2338 pos) {
        return DogNodeEvaluator.dogGetPathTypeFromState((class_1922)dog.method_37908(), pos) == class_7.field_22;
    }

    public static void teleportDogAbs(Dog dog, class_2338 target) {
        dog.field_6017 = 0.0f;
        dog.method_5808((float)target.method_10263() + 0.5f, target.method_10264(), (float)target.method_10260() + 0.5f, dog.method_36454(), dog.method_36455());
        dog.method_5942().method_6340();
        dog.breakMoveControl();
    }

    public static class_2338 getSurfaceStandingInPos(Dog dog, double x, double z) {
        return class_2338.method_49637((double)x, (double)(dog.method_23318() + 0.5), (double)z);
    }

    public static int getSurfaceStandingInY(Dog dog) {
        return class_3532.method_15357((double)(dog.method_23318() + 0.5));
    }

    public static boolean playerCanTrainTalent(class_1657 player, Talent talent) {
        if (player != null && player.method_5687(4)) {
            return true;
        }
        return ConfigHandler.TALENT.getFlag(talent);
    }

    public static String checkAndCorrectInvalidName(String name) {
        if (name == null) {
            return name;
        }
        String str = name;
        if (str.isEmpty()) {
            return name;
        }
        str = DogUtil.checkFlipName(str);
        str = DogUtil.checkInvalidChar(str);
        str = DogUtil.stripIfNeccessary(str);
        return str;
    }

    private static String stripIfNeccessary(String x) {
        String str = x;
        if (str == null) {
            str = "";
        }
        if (str.isEmpty()) {
            return x;
        }
        if (str.charAt(0) == ' ' || str.charAt(str.length() - 1) == ' ') {
            str = str.strip();
            return str;
        }
        return x;
    }

    private static String checkInvalidChar(String x) {
        String str = x;
        if (str == null) {
            str = "";
        }
        if (str.isEmpty()) {
            return x;
        }
        boolean isInvalidStr = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (DogUtil.isValidChar(Character.valueOf(c))) continue;
            isInvalidStr = true;
            break;
        }
        if (!isInvalidStr) {
            return x;
        }
        StringBuilder builder = new StringBuilder("");
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (!DogUtil.isValidChar(Character.valueOf(c))) continue;
            builder.append(c);
        }
        str = builder.toString();
        return str;
    }

    public static String checkFlipName(String string) {
        if ("Dinnerbone".equals(string) || "Grumm".equals(string)) {
            return "_" + string;
        }
        return string;
    }

    public static boolean vertifySkinData(String hash) {
        if (hash == null || hash.isEmpty()) {
            return true;
        }
        ConfigHandler.DogCustomSkinConfig.DataStrategy strategy = ConfigHandler.DogCustomSkinConfig.getStrategy();
        if (strategy == ConfigHandler.DogCustomSkinConfig.DataStrategy.NONE) {
            return true;
        }
        ConfigHandler.DogCustomSkinConfig config = ConfigHandler.DogCustomSkinConfig.getInstance();
        if (config == null) {
            return true;
        }
        if (strategy == ConfigHandler.DogCustomSkinConfig.DataStrategy.ALLOW_EXCEPT && config.isBlacklisted(hash)) {
            return false;
        }
        return strategy != ConfigHandler.DogCustomSkinConfig.DataStrategy.DISALLOW_EXCEPT || config.isWhitelisted(hash);
    }

    private static boolean isValidChar(Character x) {
        return !INVALID_NAME_CHARS.contains(x) && class_3544.method_57175((char)x.charValue());
    }

    public static boolean checkIfOwnerIsLooking(Dog dog, class_1309 owner) {
        class_243 v_look_owner = owner.method_5828(1.0f);
        class_243 v_look_wanted = dog.method_33571().method_1020(owner.method_33571()).method_1029();
        double dot = v_look_wanted.method_1026(v_look_owner);
        return dot > 0.7;
    }

    public static boolean isTrident(class_1799 stack) {
        return stack.method_31574(class_1802.field_8547);
    }

    public static boolean isDangerPathType(class_7 pathType) {
        switch (pathType) {
            case field_33534: 
            case field_36432: 
            case field_14: 
            case field_9: 
            case field_3: 
            case field_5: 
            case field_17: 
            case field_43351: 
            case field_47413: 
            case field_19: {
                return true;
            }
        }
        return false;
    }

    public static boolean isScute(class_1799 stack) {
        return ((class_1856)((class_1741)class_1740.field_48846.comp_349()).comp_2301().get()).method_8093(stack);
    }

    public static int getWolfArmorRepairVal(class_1799 stack) {
        float repair_val = (float)stack.method_7936() * 0.125f;
        return (int)repair_val;
    }

    public static void stopAndForceLook(Dog dog, class_243 target) {
        dog.method_6125(0.0f);
        dog.method_5930(0.0f);
        dog.method_5702(class_2183.class_2184.field_9851, target);
    }

    public static Optional<Dog> getLookingAtDog(class_1657 player, int reach_range) {
        return DogUtil.getLookingAtDog(player, reach_range, filter_dog -> true);
    }

    public static Optional<Dog> getLookingAtDog(class_1657 player, int reach_range, Predicate<Dog> filter) {
        class_238 search_area;
        class_243 view_vec;
        class_243 max_reach_vec;
        class_243 max_pos;
        class_243 eye_pos = player.method_33571();
        class_3966 hitResult = class_1675.method_18075((class_1297)player, (class_243)eye_pos, (class_243)(max_pos = eye_pos.method_1019(max_reach_vec = (view_vec = player.method_5828(1.0f)).method_1021((double)reach_range))), (class_238)(search_area = player.method_5829().method_18804(max_reach_vec).method_1009(1.0, 1.0, 1.0)), e -> {
            Dog dog;
            return e instanceof Dog && filter.test(dog = (Dog)e);
        }, (double)(reach_range * reach_range));
        if (hitResult == null) {
            return Optional.empty();
        }
        class_1297 entity = hitResult.method_17782();
        if (entity == null) {
            return Optional.empty();
        }
        if (!(entity instanceof Dog)) {
            return Optional.empty();
        }
        Dog dog = (Dog)entity;
        return Optional.of(dog);
    }

    public static boolean checkOwnerByUUID(Dog dog, class_1309 to_check) {
        if (dog == null || to_check == null) {
            return false;
        }
        UUID dog_owner_id = dog.method_6139();
        UUID to_check_id = to_check.method_5667();
        if (dog_owner_id == null || to_check_id == null) {
            return false;
        }
        return dog_owner_id.equals(to_check_id);
    }
}

