/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8824;

public class NBTUtil {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static void putUniqueId(class_2487 compound, String key, @Nullable UUID uuid) {
        if (uuid != null) {
            compound.method_25927(key, uuid);
        }
    }

    @Nullable
    public static UUID getUniqueId(class_2487 compound, String key) {
        if (compound.method_25928(key)) {
            return compound.method_25926(key);
        }
        if (NBTUtil.hasOldUniqueId(compound, key)) {
            return NBTUtil.getOldUniqueId(compound, key);
        }
        return null;
    }

    public static UUID getOldUniqueId(class_2487 compound, String key) {
        return new UUID(compound.method_10537(key + "Most"), compound.method_10537(key + "Least"));
    }

    public static boolean hasOldUniqueId(class_2487 compound, String key) {
        return compound.method_10573(key + "Most", 99) && compound.method_10573(key + "Least", 99);
    }

    public static void removeOldUniqueId(class_2487 compound, String key) {
        compound.method_10551(key + "Most");
        compound.method_10551(key + "Least");
    }

    public static void putResourceLocation(class_2487 compound, String key, @Nullable class_2960 rl) {
        if (rl != null) {
            compound.method_10582(key, rl.toString());
        }
    }

    @Nullable
    public static class_2960 getResourceLocation(class_2487 compound, String key) {
        if (compound.method_10573(key, 8)) {
            return class_2960.method_12829((String)compound.method_10558(key));
        }
        return null;
    }

    public static void putVector3d(class_2487 compound, @Nullable class_243 vec3d) {
        if (vec3d != null) {
            compound.method_10549("x", vec3d.method_10216());
            compound.method_10549("y", vec3d.method_10214());
            compound.method_10549("z", vec3d.method_10215());
        }
    }

    @Nullable
    public static class_243 getVector3d(class_2487 compound) {
        if (compound.method_10573("x", 99) && compound.method_10573("y", 99) && compound.method_10573("z", 99)) {
            return new class_243(compound.method_10574("x"), compound.method_10574("y"), compound.method_10574("z"));
        }
        return null;
    }

    public static void putTextComponent(class_2487 compound, String key, @Nullable class_2561 component) {
        if (component != null) {
            compound.method_10582(key, NBTUtil.serializeComponentToJsonStr(component));
        }
    }

    @Nullable
    public static class_2561 getTextComponent(class_2487 compound, String key) {
        if (compound.method_10573(key, 8)) {
            return NBTUtil.parseComponentJsonStr(compound.method_10558(key));
        }
        return null;
    }

    private static class_2561 parseComponentJsonStr(String str) {
        JsonElement c1_json = JsonParser.parseString((String)str);
        if (c1_json == null) {
            return class_2561.method_43473();
        }
        class_5250 ret = null;
        try {
            ret = (class_2561)class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, (Object)c1_json).getOrThrow();
        }
        catch (Exception e) {
            ret = class_2561.method_43473();
        }
        if (ret == null) {
            ret = class_2561.method_43473();
        }
        return ret;
    }

    private static String serializeComponentToJsonStr(class_2561 c1) {
        if (c1 == null) {
            return "";
        }
        JsonElement c1_json = null;
        try {
            c1_json = (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)c1).getOrThrow();
        }
        catch (Exception e) {
            c1_json = null;
        }
        return c1_json != null ? GSON.toJson(c1_json) : "";
    }

    @Nullable
    public static <T> T getRegistryValue(class_2487 compound, String key, class_2378<T> registry) {
        class_2960 rl = NBTUtil.getResourceLocation(compound, key);
        if (rl != null && registry.method_10250(rl)) {
            return (T)registry.method_10223(rl);
        }
        return null;
    }

    public static void putRegistryValue(class_2487 compound, String key, class_2960 value) {
        if (value != null) {
            NBTUtil.putResourceLocation(compound, key, value);
        }
    }

    public static void putBlockPos(class_2487 compound, @Nullable class_2338 vec3d) {
        if (vec3d != null) {
            compound.method_10569("x", vec3d.method_10263());
            compound.method_10569("y", vec3d.method_10264());
            compound.method_10569("z", vec3d.method_10260());
        }
    }

    @Nullable
    public static class_2338 getBlockPos(class_2487 compound) {
        if (compound.method_10573("x", 99) && compound.method_10573("y", 99) && compound.method_10573("z", 99)) {
            return new class_2338(compound.method_10550("x"), compound.method_10550("y"), compound.method_10550("z"));
        }
        return null;
    }

    public static void putBlockPos(class_2487 compound, String key, Optional<class_2338> vec3d) {
        if (vec3d.isPresent()) {
            class_2487 posNBT = new class_2487();
            NBTUtil.putBlockPos(posNBT, vec3d.get());
            compound.method_10566(key, (class_2520)posNBT);
        }
    }

    public static Optional<class_2338> getBlockPos(class_2487 compound, String key) {
        if (compound.method_10573(key, 10)) {
            return Optional.of(NBTUtil.getBlockPos(compound.method_10562(key)));
        }
        return Optional.empty();
    }

    public static void putBlockPos(class_2487 compound, String key, @Nullable class_2338 vec3d) {
        if (vec3d != null) {
            class_2487 posNBT = new class_2487();
            NBTUtil.putBlockPos(posNBT, vec3d);
            compound.method_10566(key, (class_2520)posNBT);
        }
    }

    public static void writeItemStack(class_7225.class_7874 prov, class_2487 compound, String key, class_1799 stackIn) {
        if (!stackIn.method_7960()) {
            compound.method_10566(key, stackIn.method_57376(prov, (class_2520)new class_2487()));
        }
    }

    @Nonnull
    public static class_1799 readItemStack(class_7225.class_7874 prov, class_2487 compound, String key) {
        if (compound.method_10573(key, 10)) {
            return class_1799.method_57360((class_7225.class_7874)prov, (class_2520)compound.method_10562(key)).orElse(class_1799.field_8037);
        }
        return class_1799.field_8037;
    }
}

