/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.forge_imitate.network;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class PacketDistributor<T> {
    public static PacketDistributor<Void> SERVER = new PacketDistributor<Void>(new ToServerPacketTarget());
    public static PacketDistributor<class_1297> TRACKING_ENTITY = new PacketDistributor<class_1297>(new ToClientPacketTarget<class_1297>(PlayerLookup::tracking));
    public static PacketDistributor<class_3222> PLAYER = new PacketDistributor<class_3222>(new ToClientSinglePacketTarget());
    public static PacketDistributor<class_1297> TRACKING_ENTITY_AND_SELF = new PacketDistributor<class_1297>(new ToClientPacketTarget<class_1297>(PlayerLookup::tracking));
    private PacketTarget<T> defaultTarget;

    PacketDistributor(PacketTarget<T> target) {
        this.defaultTarget = target;
    }

    public PacketTarget<T> noArg() {
        return this.defaultTarget.acceptArg(null);
    }

    public PacketTarget<T> with(Supplier<T> arg) {
        return this.defaultTarget.acceptArg(arg.get());
    }

    public static abstract class PacketTarget<T> {
        protected Type type;

        public abstract void sendPacket(class_8710 var1);

        public Type getType() {
            return this.type;
        }

        public PacketTarget<T> acceptArg(T arg) {
            return this;
        }

        public static enum Type {
            TO_CLIENT,
            TO_SERVER;

        }
    }

    public static class ToServerPacketTarget
    extends PacketTarget<Void> {
        private final Consumer<class_8710> clientSender = p -> ClientPlayNetworking.send((class_8710)p);

        public ToServerPacketTarget() {
            this.type = PacketTarget.Type.TO_SERVER;
        }

        @Override
        public void sendPacket(class_8710 payload) {
            this.clientSender.accept(payload);
        }

        @Override
        public PacketTarget<Void> acceptArg(Void arg) {
            return this;
        }
    }

    public static class ToClientPacketTarget<T>
    extends PacketTarget<T> {
        private final Function<T, Collection<class_3222>> playerListSup;
        private T arg;

        public ToClientPacketTarget(Function<T, Collection<class_3222>> playerListSup) {
            this.type = PacketTarget.Type.TO_CLIENT;
            this.playerListSup = playerListSup;
        }

        @Override
        public void sendPacket(class_8710 payload) {
            Collection<class_3222> playerList = this.playerListSup.apply(this.arg);
            for (class_3222 player : playerList) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }
        }

        @Override
        public PacketTarget<T> acceptArg(T arg) {
            ToClientPacketTarget<T> ret = new ToClientPacketTarget<T>(this.playerListSup);
            ret.arg = arg;
            return ret;
        }
    }

    public static class ToClientSinglePacketTarget
    extends PacketTarget<class_3222> {
        private class_3222 arg;

        public ToClientSinglePacketTarget() {
            this.type = PacketTarget.Type.TO_CLIENT;
        }

        @Override
        public void sendPacket(class_8710 payload) {
            ServerPlayNetworking.send((class_3222)this.arg, (class_8710)payload);
        }

        @Override
        public PacketTarget<class_3222> acceptArg(class_3222 arg) {
            ToClientSinglePacketTarget ret = new ToClientSinglePacketTarget();
            ret.arg = arg;
            return ret;
        }
    }
}

