/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether;

import com.solegendary.reignofnether.ClientModConfigs;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.config.ReignOfNetherCommonConfigs;
import com.solegendary.reignofnether.mixin.DownloadPackSourceAccessor;
import com.solegendary.reignofnether.network.S2CReset;
import com.solegendary.reignofnether.registrars.BlockEntityRegistrar;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.registrars.ClientEventRegistrar;
import com.solegendary.reignofnether.registrars.ContainerRegistrar;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.registrars.ItemRegistrar;
import com.solegendary.reignofnether.registrars.MobEffectRegistrar;
import com.solegendary.reignofnether.registrars.ServerEventRegistrar;
import com.solegendary.reignofnether.registrars.SoundRegistrar;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.repository.Pack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.HandshakeHandler;
import net.minecraftforge.network.HandshakeMessages;
import net.minecraftforge.network.NetworkConstants;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.GameData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod(value="reignofnether")
public class ReignOfNether {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "reignofnether";
    public static final String VERSION_STRING = "1.2.3c";
    public static final Field handshakeField;
    public static final Constructor<?> contextConstructor;
    static final Logger logger;
    static final Marker RESETMARKER;
    public static SimpleChannel handshakeChannel;

    public ReignOfNether(final FMLJavaModLoadingContext mlctx) {
        ItemRegistrar.init(mlctx);
        EntityRegistrar.init(mlctx);
        ContainerRegistrar.init(mlctx);
        SoundRegistrar.init(mlctx);
        BlockRegistrar.init(mlctx);
        BlockEntityRegistrar.init(mlctx);
        GameRuleRegistrar.init();
        Buildings.init();
        ProductionItems.init();
        MobEffectRegistrar.init(mlctx);
        ClientEventRegistrar clientRegistrar = new ClientEventRegistrar();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> clientRegistrar::registerClientEvents);
        ServerEventRegistrar serverRegistrar = new ServerEventRegistrar();
        DistExecutor.safeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> serverRegistrar::registerServerEvents);
        IEventBus bus = mlctx.getModEventBus();
        bus.addListener(ReignOfNether::init);
        mlctx.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ReignOfNetherCommonConfigs.SPEC, "reignofnether-common-1.2.3c.toml");
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> new DistExecutor.SafeRunnable(){

            public void run() {
                ClientModConfigs.registerClientConfigs(mlctx);
            }
        });
        mlctx.registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        if (handshakeField == null) {
            logger.error(RESETMARKER, "Failed to find FML's handshake channel. Disabling mod.");
            return;
        }
        if (contextConstructor == null) {
            logger.error(RESETMARKER, "Failed to find FML's network event context constructor. Disabling mod.");
            return;
        }
        try {
            Object handshake = handshakeField.get(null);
            if (handshake instanceof SimpleChannel) {
                handshakeChannel = (SimpleChannel)handshake;
                logger.info(RESETMARKER, "Registering forge reset packet.");
                handshakeChannel.messageBuilder(S2CReset.class, 98).loginIndex(S2CReset::getLoginIndex, S2CReset::setLoginIndex).decoder(S2CReset::decode).encoder(S2CReset::encode).consumerNetworkThread(HandshakeHandler.biConsumerFor(ReignOfNether::handleReset)).add();
                logger.info(RESETMARKER, "Registered forge reset packet successfully.");
            }
        }
        catch (Exception e) {
            logger.error(RESETMARKER, "Caught exception when attempting to utilize FML's handshake. Disabling mod. Exception: " + e.getMessage());
        }
        ResourceCosts.deferredLoadResourceCosts();
    }

    public static void handleReset(HandshakeHandler handler, S2CReset msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        Connection connection = context.getNetworkManager();
        if (context.getDirection() != NetworkDirection.LOGIN_TO_CLIENT && context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            connection.m_129507_((Component)Component.m_237113_((String)"Illegal packet received, terminating connection"));
            throw new IllegalStateException("Invalid packet received, aborting connection");
        }
        logger.info(RESETMARKER, "Received reset packet from server.");
        if (!ReignOfNether.handleClear(context)) {
            return;
        }
        NetworkHooks.registerClientLoginChannel((Connection)connection);
        connection.m_129498_(ConnectionProtocol.LOGIN);
        connection.m_129505_((PacketListener)new ClientHandshakePacketListenerImpl(connection, Minecraft.m_91087_(), null, null, false, Duration.ZERO, statusMessage -> {}));
        Minecraft.m_91087_().f_91009_ = connection;
        context.setPacketHandled(true);
        try {
            handshakeChannel.reply((Object)new HandshakeMessages.C2SAcknowledge(), (NetworkEvent.Context)contextConstructor.newInstance(connection, NetworkDirection.LOGIN_TO_CLIENT, 98));
        }
        catch (Exception e) {
            logger.error(RESETMARKER, "Exception occurred when attempting to reply to reset packet.  Exception: " + e.getMessage());
            context.setPacketHandled(false);
            return;
        }
        logger.info(RESETMARKER, "Reset complete.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean handleClear(NetworkEvent.Context context) {
        CompletableFuture future = context.enqueueWork(() -> {
            logger.debug(RESETMARKER, "Clearing");
            ServerData serverData = Minecraft.m_91087_().m_91089_();
            Pack serverPack = ((DownloadPackSourceAccessor)Minecraft.m_91087_().m_247489_()).getServerPack();
            if (Minecraft.m_91087_().f_91073_ == null) {
                GameData.revertToFrozen();
            }
            ((DownloadPackSourceAccessor)Minecraft.m_91087_().m_247489_()).setServerPack(null);
            Minecraft.m_91087_().m_91320_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"connect.negotiating")));
            try {
                context.getNetworkManager().channel().pipeline().remove("forge:forge_fixes");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            try {
                context.getNetworkManager().channel().pipeline().remove("forge:vanilla_filter");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            ((DownloadPackSourceAccessor)Minecraft.m_91087_().m_247489_()).setServerPack(serverPack);
        });
        logger.debug(RESETMARKER, "Waiting for clear to complete");
        try {
            future.get();
            logger.debug("Clear complete, continuing reset");
            return true;
        }
        catch (Exception ex) {
            logger.error(RESETMARKER, "Failed to clear, closing connection", (Throwable)ex);
            context.getNetworkManager().m_129507_((Component)Component.m_237113_((String)"Failed to clear, closing connection"));
            return false;
        }
    }

    private static Field fetchHandshakeChannel() {
        try {
            return ObfuscationReflectionHelper.findField(NetworkConstants.class, (String)"handshakeChannel");
        }
        catch (Exception e) {
            logger.error("Exception occurred while accessing handshakeChannel: " + e.getMessage());
            return null;
        }
    }

    private static Constructor<?> fetchNetworkEventContext() {
        try {
            return ObfuscationReflectionHelper.findConstructor(NetworkEvent.Context.class, (Class[])new Class[]{Connection.class, NetworkDirection.class, Integer.TYPE});
        }
        catch (Exception e) {
            logger.error("Exception occurred while accessing getLoginIndex: " + e.getMessage());
            return null;
        }
    }

    static {
        logger = LogManager.getLogger();
        RESETMARKER = MarkerManager.getMarker((String)"RESETPACKET").setParents(new Marker[]{MarkerManager.getMarker((String)"FMLNETWORK")});
        handshakeField = ReignOfNether.fetchHandshakeChannel();
        contextConstructor = ReignOfNether.fetchNetworkEventContext();
    }
}

