/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import oshi.util.tuples.Pair;

public class Abilities {
    public static final List<Keybinding> ABILITY_KEYBINDS = List.of(Keybindings.keyQ, Keybindings.keyW, Keybindings.keyE, Keybindings.keyR, Keybindings.keyT, Keybindings.keyY);
    List<Pair<Ability, Keybinding>> abilities = new ArrayList<Pair<Ability, Keybinding>>();

    public Abilities() {
    }

    private Abilities(List<Pair<Ability, Keybinding>> abilities) {
        this.abilities = abilities;
    }

    public void add(Ability ability) {
        this.abilities.add((Pair<Ability, Keybinding>)new Pair((Object)ability, null));
    }

    public void add(Ability ability, Keybinding keybind) {
        this.abilities.add((Pair<Ability, Keybinding>)new Pair((Object)ability, (Object)keybind));
    }

    public List<AbilityButton> getButtons(BuildingPlacement placement) {
        ArrayList<AbilityButton> buttons = new ArrayList<AbilityButton>();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            for (int i = 0; i < this.abilities.size(); ++i) {
                Pair<Ability, Keybinding> ability = this.abilities.get(i);
                buttons.add(((Ability)ability.getA()).getButton(ability.getB() != null ? (Keybinding)ability.getB() : ABILITY_KEYBINDS.get(i), placement));
            }
        }
        return buttons;
    }

    public List<Button> getButtons(Unit unit) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            for (int i = 0; i < this.abilities.size(); ++i) {
                Pair<Ability, Keybinding> ability = this.abilities.get(i);
                buttons.add(((Ability)ability.getA()).getButton(ability.getB() != null ? (Keybinding)ability.getB() : ABILITY_KEYBINDS.get(i), unit));
            }
        }
        return buttons;
    }

    public List<Ability> get() {
        return new ArrayList<Ability>(Arrays.asList((Ability[])this.abilities.stream().map(Pair::getA).toArray(Ability[]::new)));
    }

    public Ability getDefaultAutocast() {
        for (Pair<Ability, Keybinding> ability : this.abilities) {
            if (!((Ability)ability.getA()).isDefaultAutocast()) continue;
            return (Ability)ability.getA();
        }
        return null;
    }

    public Abilities clone() {
        return new Abilities(new ArrayList<Pair<Ability, Keybinding>>(this.abilities));
    }

    public boolean isEmpty() {
        return this.abilities.isEmpty();
    }
}

