/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class AbilityServerboundPacket {
    private final int unitId;
    private final UnitAction unitAction;

    public static void rankUpAbility(int unitId, UnitAction abilityAction) {
        PacketHandler.INSTANCE.sendToServer((Object)new AbilityServerboundPacket(unitId, abilityAction));
    }

    public AbilityServerboundPacket(int unitId, UnitAction unitAction) {
        this.unitId = unitId;
        this.unitAction = unitAction;
    }

    public AbilityServerboundPacket(FriendlyByteBuf buffer) {
        this.unitId = buffer.readInt();
        this.unitAction = (UnitAction)buffer.m_130066_(UnitAction.class);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.unitId);
        buffer.m_130068_((Enum)this.unitAction);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("AbilityServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
                if (entity.m_19879_() != this.unitId || !(entity instanceof Unit)) continue;
                Unit unit = (Unit)entity;
                if (!player.m_7755_().getString().equals(unit.getOwnerName())) {
                    ReignOfNether.LOGGER.warn("AbilityServerboundPacket: Tried to process packet from " + player.m_7755_() + " for: " + unit.getOwnerName());
                    success.set(false);
                    return;
                }
                for (Ability ability : unit.getAbilities().get()) {
                    if (ability.action != this.unitAction || !(ability instanceof HeroAbility)) continue;
                    HeroAbility heroAbility = (HeroAbility)ability;
                    if (!(unit instanceof HeroUnit)) continue;
                    HeroUnit hero = (HeroUnit)unit;
                    heroAbility.rankUp(hero);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

